/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipCard;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipCardController;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipCardVM;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipMainCardVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.CreditSlipConrollerInterceptor;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.BinaryData;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class CreditSlipHandler
extends BaseRootEntityHandler<CreditSlip, Void, CreditSlipCardVM, CreditSlipCard> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<CreditSlip, Void>, CreditSlipCardVM>> toVM, List<BiConsumer<CreditSlipCardVM, DataTransferPackage<CreditSlip, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CreditSlipConrollerInterceptor());
        toVM.add((dtp, vm) -> {
            CreditSlip model = (CreditSlip)dtp.getContainer().getEntity();
            CreditSlipMainCardVM mainFull = vm.getMainCard();
            mainFull.setType(model.getType());
            mainFull.setName(model.getName());
            mainFull.setNumber(model.getNumber());
            mainFull.setOrganization(model.getOrganization());
            mainFull.setDate(DateUtils.asLocalDateTime((Date)model.getDate()));
            mainFull.setTotalAmount(model.getTotalAmount());
            if (model.getCashier() != null) {
                mainFull.setCashier(model.getCashier());
            } else {
                AgentData agentData = Prefetched.getData().getCurrentAgentData();
                if (agentData.getPersonTypes().contains(PersonType.AGENT) || agentData.getPersonTypes().contains(PersonType.CASHIER_CLERK) || agentData.getPersonTypes().contains(PersonType.CASHIER_ACCOUNTANT)) {
                    mainFull.setCashier(agentData.getAgent());
                } else {
                    mainFull.setCashier(model.getCashier());
                }
            }
            mainFull.setPerson(model.getPerson());
            mainFull.setPersonName(model.getPersonName());
            mainFull.setPersonReason(model.getPersonReason());
            mainFull.setPersonDocument(model.getPersonDocument());
            BinaryData content = model.getContent();
            if (content != null) {
                RichData docVM = new RichData();
                docVM.setContent(content.getData());
                docVM.setContentType(content.getContentType());
                vm.setEditor(docVM);
            } else {
                vm.setEditor(null);
            }
        });
        fromVM.add((vm, dtp) -> {
            CreditSlip model = (CreditSlip)dtp.getContainer().getEntity();
            CreditSlipMainCardVM mainFull = vm.getMainCard();
            model.setType(mainFull.getType());
            model.setName(mainFull.getName());
            model.setNumber(mainFull.getNumber());
            model.setOrganization(mainFull.getOrganization());
            model.setDate(DateUtils.asDate((LocalDateTime)mainFull.getDate()));
            model.setTotalAmount(mainFull.getTotalAmount());
            model.setCashier(mainFull.getCashier());
            model.setPerson(mainFull.getPerson());
            model.setPersonName(mainFull.getPersonName());
            model.setPersonReason(mainFull.getPersonReason());
            model.setPersonDocument(mainFull.getPersonDocument());
            RichData docVM = vm.getEditor();
            if (docVM == null) {
                model.setContent(null);
            } else {
                BinaryData content = model.getContent();
                if (content == null) {
                    content = new BinaryData();
                    model.setContent(content);
                }
                content.setData(docVM.getContent());
                content.setContentType(docVM.getContentType());
            }
        });
    }

    @Override
    protected ViewController<CreditSlipCard, CreditSlipCardVM> createSpaceController(boolean readonly) {
        return new CreditSlipCardController(readonly);
    }

    @Override
    protected CreditSlipCardVM createVM() {
        return new CreditSlipCardVM();
    }

    public Class<CreditSlip> getEntityClass() {
        return CreditSlip.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicPaymentDocumentIndex.class;
    }
}

