/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.DebitBankTransferOrderCard;
import com.gridnine.xtrip.client.fx.model.profile.DebitBankTransferOrderCardController;
import com.gridnine.xtrip.client.fx.model.profile.DebitBankTransferOrderCardVM;
import com.gridnine.xtrip.client.fx.model.profile.DebitBankTransferOrderMainCardVM;
import com.gridnine.xtrip.client.fx.model.profile.DebitBankTransferOrderPaymentItemsVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.DebitBankTransferOrderControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentUIData;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class DebitBankTransferOrderHandler
extends BaseRootEntityHandler<DebitBankTransferOrder, PaymentDocumentUIData, DebitBankTransferOrderCardVM, DebitBankTransferOrderCard> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<DebitBankTransferOrder, PaymentDocumentUIData>, DebitBankTransferOrderCardVM>> toVM, List<BiConsumer<DebitBankTransferOrderCardVM, DataTransferPackage<DebitBankTransferOrder, PaymentDocumentUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new DebitBankTransferOrderControllerInterceptor());
        toVM.add((dtp, vm) -> {
            DebitBankTransferOrder model = (DebitBankTransferOrder)dtp.getContainer().getEntity();
            PaymentDocumentUIData supplement = (PaymentDocumentUIData)dtp.getSupplement();
            DebitBankTransferOrderMainCardVM mainFull = vm.getMainCard();
            mainFull.setName(model.getName());
            mainFull.setNumber(model.getNumber());
            mainFull.setOrganization(model.getOrganization());
            mainFull.setDate(DateUtils.asLocalDateTime((Date)model.getDate()));
            mainFull.setPayer(model.getPayer());
            mainFull.setTotalAmount(model.getTotalAmount());
            mainFull.setContract(model.getContract());
            if (supplement != null && supplement.getPaymentItems() != null) {
                Money paymentsTotalAmount = supplement.getPaymentItems().getData().stream().map(PaymentItem::getAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MoneyHelper.sum((Money[])new Money[]{xva$0, xva$1})).orElse(null);
                mainFull.setPaymentsTotalAmount(paymentsTotalAmount);
                VMHelper.transfer(supplement.getPaymentItems().getData(), vm.getPaymentItems(), bi -> new DebitBankTransferOrderPaymentItemsVM(), (pi, piVM) -> {
                    piVM.setType(pi.getPaymentType());
                    piVM.setAmount(pi.getAmount());
                    piVM.setCurrency(pi.getAmount() == null ? null : pi.getAmount().getCurrency());
                });
            }
        });
        fromVM.add((vm, dtp) -> {
            DebitBankTransferOrder model = (DebitBankTransferOrder)dtp.getContainer().getEntity();
            DebitBankTransferOrderMainCardVM mainFull = vm.getMainCard();
            model.setName(mainFull.getName());
            model.setNumber(mainFull.getNumber());
            model.setOrganization(mainFull.getOrganization());
            model.setDate(DateUtils.asDate((LocalDateTime)mainFull.getDate()));
            model.setPayer(mainFull.getPayer());
            model.setTotalAmount(mainFull.getTotalAmount());
            model.setContract(mainFull.getContract());
        });
    }

    @Override
    protected ViewController<DebitBankTransferOrderCard, DebitBankTransferOrderCardVM> createSpaceController(boolean readonly) {
        return new DebitBankTransferOrderCardController(readonly);
    }

    @Override
    protected DebitBankTransferOrderCardVM createVM() {
        return new DebitBankTransferOrderCardVM();
    }

    public Class<DebitBankTransferOrder> getEntityClass() {
        return DebitBankTransferOrder.class;
    }

    public Class<PaymentDocumentUIData> getSupplementClass() {
        return PaymentDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicPaymentDocumentIndex.class;
    }
}

