/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.model.ExternalFinanceDocumentContainer;
import com.gridnine.xtrip.client.fx.standard.model.ExternalFinanceDocumentContainerController;
import com.gridnine.xtrip.client.fx.standard.model.ExternalFinanceDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.model.ExternalFinanceDocumentMainGridVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class ExternalFinanceDocumentHandler
extends BaseRootEntityHandler<ExternalFinanceDocument, Void, ExternalFinanceDocumentContainerVM, ExternalFinanceDocumentContainer> {
    public Class<ExternalFinanceDocument> getEntityClass() {
        return ExternalFinanceDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return ExternalFinanceDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ExternalFinanceDocument, Void>, ExternalFinanceDocumentContainerVM>> toVM, List<BiConsumer<ExternalFinanceDocumentContainerVM, DataTransferPackage<ExternalFinanceDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            ExternalFinanceDocument model = (ExternalFinanceDocument)dtp.getContainer().getEntity();
            ExternalFinanceDocumentMainGridVM mainCard = vm.getMain();
            mainCard.setCustomer(model.getCustomer());
            mainCard.setDate(DateUtils.asLocalDate((Date)model.getDate()));
            mainCard.setName(model.getName());
            mainCard.setNumber(model.getNumber());
            mainCard.setPayer(model.getPayer());
            mainCard.setSupplier(model.getSupplier());
            mainCard.setType(model.getFinanceDocumentType());
            mainCard.setAgent(model.getAgent());
            mainCard.setContract(model.getContract());
            mainCard.setCurrency(model.getCurrency());
            mainCard.setTotalAmount(model.getTotalAmount());
            mainCard.setBookingFile(model.getOwner());
            byte[] content = model.getContent();
            if (content != null) {
                RichData docVM = new RichData();
                docVM.setContent(model.getContent());
                docVM.setContentType(model.getContentType());
                vm.setDocument(docVM);
            } else {
                vm.setDocument(null);
            }
        });
        fromVM.add((vm, dtp) -> {
            ExternalFinanceDocument model = (ExternalFinanceDocument)dtp.getContainer().getEntity();
            ExternalFinanceDocumentMainGridVM mainCard = vm.getMain();
            model.setCustomer(mainCard.getCustomer());
            model.setDate(DateUtils.asDate((LocalDate)mainCard.getDate()));
            model.setName(mainCard.getName());
            model.setNumber(mainCard.getNumber());
            model.setPayer(mainCard.getPayer());
            model.setSupplier(mainCard.getSupplier());
            model.setFinanceDocumentType(mainCard.getType());
            model.setAgent(mainCard.getAgent());
            model.setContract(mainCard.getContract());
            model.setCurrency(mainCard.getCurrency());
            model.setTotalAmount(mainCard.getTotalAmount());
            model.setOwner(mainCard.getBookingFile());
            RichData docVM = vm.getDocument();
            if (docVM == null) {
                model.setContent(null);
                model.setContentType(null);
            } else {
                model.setContent(docVM.getContent());
                model.setContentType(docVM.getContentType());
            }
        });
    }

    @Override
    protected ViewController<ExternalFinanceDocumentContainer, ExternalFinanceDocumentContainerVM> createSpaceController(boolean readonly) {
        return new ExternalFinanceDocumentContainerController(readonly);
    }

    @Override
    protected ExternalFinanceDocumentContainerVM createVM() {
        return new ExternalFinanceDocumentContainerVM();
    }
}

