/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ComboBoxColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentContainerController;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentItemsBillingItemsFilterPanel;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentMainGrid;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

class FinanceDocumentContainerControllerInterceptor
extends ControllerInterceptor<FinanceDocumentContainerVM, FinanceDocumentContainerController> {
    private static final String BANK_ACCOUNT_PROPERTY = "bankAccount";
    private static final StringConverter SHIPMENT_REFERENCE_CONVERTER = new StringConverter(){

        public String toString(Object object) {
            return Messages.View_Document;
        }

        public Object fromString(String string) {
            return null;
        }
    };
    private static final MultiSupplier<IndexListParameters<BaseProfile, ?>> PAYERS_SUPPLIER = new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){
        IndexListParameters<?, ?>[] listParameters = new IndexListParameters[]{EntityIndexHandler.forIndexClass(OrganizationIndex.class).createListParameters(), EntityIndexHandler.forIndexClass(PersonIndex.class).createListParameters()};

        public int count() {
            return this.listParameters.length;
        }

        public String getDisplayName(int idx) {
            return MetaRegistryHelper.getDisplayName((Class)this.listParameters[idx].getIndexType());
        }

        public IndexListParameters<BaseProfile, ?> get(int idx) {
            return this.listParameters[idx];
        }
    };

    FinanceDocumentContainerControllerInterceptor() {
    }

    protected Class<FinanceDocumentContainerController> getControllerClass() {
        return FinanceDocumentContainerController.class;
    }

    protected void onCreate(FinanceDocumentContainerController controller) {
        FinanceDocumentMainGrid mainGrid = (FinanceDocumentMainGrid)controller.getView().getMainCard().getContent();
        mainGrid.getSupplierBankAccountNode().setNestedReferenceBuilder(idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), BankAccount.class, ((BankAccount)idx).getSettlementAccount()));
        ((FinanceDocumentMainGrid)controller.getView().getMainCard().getContent()).getTemplateNode().setListParametersSupplier(() -> this.getTemplateSupplier(controller));
        EntityBoxWidgetColumn shipmentColumn = (EntityBoxWidgetColumn)((TableWidget)controller.getView().getRelatedShipmentsCard().getContent()).getColumn("relatedShipment");
        ((TableWidget)controller.getView().getRelatedShipmentsCard().getContent()).setOnRowsAction(event -> {
            if (event.getEventType() == TableRowEvent.ROW_ADD) {
                EntityBoxWidget shipmentWidget = (EntityBoxWidget)shipmentColumn.getWidget(event.getRowIndex().intValue());
                shipmentWidget.setConverter(SHIPMENT_REFERENCE_CONVERTER);
            }
        });
        ((RichContentWidget)controller.getView().getDocumentCard().getContent()).setFileNameSupplier(() -> mainGrid.getNameNode().getValue());
        ((BigTableWidget)controller.getBillingItems().getView()).setControlButtonsAvailability(ControlsPane.NONE);
        controller.getMain().getView().getContractNode().getViewState().setNotEditable(true);
        controller.getMain().getView().getCurrencyNode().getViewState().setNotEditable(true);
        ComboBoxColumn paymentType = (ComboBoxColumn)((BigTableWidget)controller.getBillingItems().getView()).getColumn("paymentType");
        paymentType.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
        ((FinanceDocumentMainGrid)controller.getView().getMainCard().getContent()).getTypeNode().valueProperty().addListener((s, o, n) -> this.updateInvoicePrepayment(controller));
        ((BigTableWidget)controller.getBillingItems().getView()).setFiltering(() -> new FinanceDocumentItemsBillingItemsFilterPanel(false), filterPanel -> vm -> {
            String name = filterPanel.getNameNode().getValue();
            if (TextUtil.nonBlank((String)name) && (vm.getName() == null || !vm.getName().toLowerCase().contains(name.toLowerCase()))) {
                return false;
            }
            String product = filterPanel.getProductNode().getValue();
            if (TextUtil.nonBlank((String)product) && (vm.getProduct() == null || vm.getProduct().getCaption() == null || !vm.getProduct().getCaption().toLowerCase().contains(product.toLowerCase()))) {
                return false;
            }
            String traveller = filterPanel.getTravellerNode().getValue();
            return !TextUtil.nonBlank((String)traveller) || vm.getTraveller() != null && vm.getTraveller().getCaption() != null && vm.getTraveller().getCaption().toLowerCase().contains(traveller.toLowerCase());
        }, true);
        ((TextAreaWidget)controller.getView().getCaptionTemplateCard().getContent()).setWrapText(true);
    }

    private void updateInvoicePrepayment(FinanceDocumentContainerController controller) {
        RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)controller.getView());
        FinanceDocumentType financeDocumentType = null;
        if (rootEntityPane != null) {
            EntityContainer container = rootEntityPane.getData().getContainer();
            financeDocumentType = ((FinanceDocument)container.getEntity()).getType();
        }
        boolean editable = (financeDocumentType == null && FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)controller.getMain().getType()) || FinanceDocumentsHelper.isPrepayment(financeDocumentType)) && (controller.getBillingItems().getData() == null || ((Collection)controller.getBillingItems().getData()).stream().allMatch(bi -> bi.getProduct() == null));
        Predicate buttonAvailability = editable ? ControlsPane.ADD_REMOVE : ControlsPane.NONE;
        ((BigTableWidget)controller.getBillingItems().getView()).setControlButtonsAvailability(buttonAvailability);
        controller.getMain().getView().getContractNode().getViewState().setNotEditable(!editable);
        controller.getMain().getView().getCurrencyNode().getViewState().setNotEditable(!editable);
        ((BigTableWidget)controller.getBillingItems().getView()).getColumn("paymentType").setNotEditable(!editable);
        ((BigTableWidget)controller.getBillingItems().getView()).getColumn("amount").setNotEditable(!editable);
        ((BigTableWidget)controller.getBillingItems().getView()).getColumn("vat").setNotEditable(!editable);
    }

    private IndexListParameters<TemplateDocument, ?> getTemplateSupplier(FinanceDocumentContainerController controller) {
        FinanceDocumentType type = (FinanceDocumentType)((FinanceDocumentMainGrid)controller.getView().getMainCard().getContent()).getTypeNode().getValue();
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.modifiedDate.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.modifiedDate.name(), TemplateDocumentIndex.Property.created.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.title.name(), TemplateDocumentIndex.Property.size.name(), TemplateDocumentIndex.Property.created.name(), TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.financeDocumentType.name());
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.financeDocumentType.name(), (Object)type));
        return result;
    }

    protected void afterReadData(FinanceDocumentContainerController controller, FinanceDocumentContainerVM model) {
        boolean billingItemsExist = ((BigTableWidget)controller.getView().getBillingItemsCard().getContent()).getRowsCount() > 0;
        ((FinanceDocumentMainGrid)controller.getView().getMainCard().getContent()).getCustomerNode().getViewState().setNotEditable(billingItemsExist);
        ((FinanceDocumentMainGrid)controller.getView().getMainCard().getContent()).getSupplierNode().getViewState().setNotEditable(billingItemsExist);
        ((FinanceDocumentMainGrid)controller.getView().getMainCard().getContent()).getPayerNode().getViewState().setNotEditable(billingItemsExist);
        this.updateInvoicePrepayment(controller);
        FinanceDocumentMainGrid mainGridContent = (FinanceDocumentMainGrid)controller.getView().getMainCard().getContent();
        this.setupSupplierBankAccountSupplierList(mainGridContent);
        this.setupPayerBankAccountSupplierList(mainGridContent);
        mainGridContent.getPayerNode().setListParametersSupplier(PAYERS_SUPPLIER);
    }

    private void setupPayerBankAccountSupplierList(FinanceDocumentMainGrid content) {
        NestedEntityBoxWidget payerAccountWidget = content.getPayerBankAccountNode();
        EntityBoxWidget payerWidget = content.getPayerNode();
        if (payerWidget.getValue() != null && payerWidget.getValue().getType().equals(Organization.class)) {
            payerWidget.getProperties().put((Object)BANK_ACCOUNT_PROPERTY, this.getBankAccounts((EntityReference<Organization>)payerWidget.getValue()));
        } else {
            payerWidget.getProperties().put((Object)BANK_ACCOUNT_PROPERTY, (Object)Collections.EMPTY_LIST);
        }
        payerAccountWidget.setLive(true);
        payerAccountWidget.setItemsSupplier(() -> (List)payerWidget.getProperties().get((Object)BANK_ACCOUNT_PROPERTY), false);
        payerWidget.setValueSelectionListener(idx -> {
            content.getPayerBankAccountNode().setValue(null);
            if (content.getPayerNode().getValue().getType().equals(Person.class)) {
                payerWidget.getProperties().put((Object)BANK_ACCOUNT_PROPERTY, (Object)Collections.EMPTY_LIST);
            } else {
                payerWidget.getProperties().put((Object)BANK_ACCOUNT_PROPERTY, this.getBankAccounts((EntityReference<Organization>)payerWidget.getValue()));
            }
        });
    }

    private void setupSupplierBankAccountSupplierList(FinanceDocumentMainGrid content) {
        NestedEntityBoxWidget supplierAccountWidget = content.getSupplierBankAccountNode();
        EntityBoxWidget supplierWidget = content.getSupplierNode();
        supplierWidget.getProperties().put((Object)BANK_ACCOUNT_PROPERTY, this.getBankAccounts((EntityReference<Organization>)content.getSupplierNode().getValue()));
        supplierWidget.setValueSelectionListener(idx -> {
            content.getSupplierBankAccountNode().setValue(null);
            supplierWidget.getProperties().put((Object)BANK_ACCOUNT_PROPERTY, this.getBankAccounts((EntityReference<Organization>)supplierWidget.getValue()));
        });
        supplierAccountWidget.setLive(true);
        supplierAccountWidget.setItemsSupplier(() -> (List)supplierWidget.getProperties().get((Object)BANK_ACCOUNT_PROPERTY), false);
    }

    private List<NestedEntityReference> getBankAccounts(EntityReference<Organization> organization) {
        ArrayList<NestedEntityReference> result = new ArrayList<NestedEntityReference>();
        Notifications.get().submitTask(() -> {
            EntityContainer rpcContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), organization);
            if (rpcContainer != null) {
                Organization rpcOrganization = (Organization)rpcContainer.getEntity();
                FxUtil.submitToFxThread(() -> {
                    List nestedSupplierAccountsList = rpcOrganization.getBankAccounts().stream().map(x -> new NestedEntityReference(rpcContainer.toReference(), x.getUid(), BankAccount.class, x.toString())).collect(Collectors.toList());
                    result.addAll(nestedSupplierAccountsList);
                });
            }
        }, Messages.BankAccounts_is_filling);
        return result;
    }
}

