/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentAppliedRulesFilterPanel;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsAppliedRulesVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpaceController;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ShipmentsService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRules;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndex;
import com.gridnine.xtrip.common.model.rules.finance.Actions;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javafx.scene.Node;
import javafx.util.Pair;
import javafx.util.StringConverter;

public class ShipmentAppliedRulesFilterableDataHandler
extends FilterableDataViewHandler<ShipmentItemsAppliedRulesVM, ShipmentAppliedRulesFilterPanel> {
    private static final int DEFAULT_LIMIT = 10;
    private final ShipmentSpaceController controller;
    private int offset;

    protected ShipmentAppliedRulesFilterableDataHandler(ShipmentSpaceController controller) {
        super(ShipmentAppliedRulesFilterableDataHandler::createFilterPanel, false);
        this.controller = controller;
    }

    protected int getLimit() {
        return 10;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected void reloadData(int newOffset, List<Pair<String, SortOrder>> sorting) {
        Notifications.get().submitTask(() -> {
            EntityContainer shipment;
            DataTransferPackage dtp;
            FilteringPane filteringPane = this.getFilteringPane();
            Targets target = (Targets)((ShipmentAppliedRulesFilterPanel)filteringPane.getContent()).getRuleTargetNode().getValue();
            Actions action = (Actions)((ShipmentAppliedRulesFilterPanel)filteringPane.getContent()).getRuleActionNode().getValue();
            String productName = ((ShipmentAppliedRulesFilterPanel)filteringPane.getContent()).getProductNode().getValue();
            ArrayList<ShipmentItemsAppliedRulesVM> result = new ArrayList<ShipmentItemsAppliedRulesVM>();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)this.controller.getView());
            if (rootEntityPane != null && (dtp = rootEntityPane.getData()) != null && (shipment = dtp.getContainer()) != null && TextUtil.nonBlank((String)productName)) {
                List indices = ((ShipmentsService)RpcServiceManager.get().getService(ShipmentsService.class)).getShipmentProductAppliedRulesIndices(ServiceInvocationContext.get(), shipment, productName.trim(), target, action, newOffset, 10);
                for (ShipmentProductAppliedRulesIndex index : indices) {
                    EntityContainer shipmentProductAppliedRulesByDate;
                    ArrayList appliedRules;
                    AppliedRule appliedRule;
                    EntityContainer shipmentProductAppliedRules = entityService.load(ServiceInvocationContext.get(), index.getSource());
                    if (shipmentProductAppliedRules == null || (appliedRule = (AppliedRule)(appliedRules = new ArrayList((shipmentProductAppliedRulesByDate = ((ShipmentsService)RpcServiceManager.get().getService(ShipmentsService.class)).getShipmentProductAppliedRulesByDate(ServiceInvocationContext.get(), shipmentProductAppliedRules, shipment.getVersionInfo().getCreated())) != null ? ((ShipmentProductAppliedRules)shipmentProductAppliedRulesByDate.getEntity()).getAppliedRules() : ((ShipmentProductAppliedRules)shipmentProductAppliedRules.getEntity()).getAppliedRules())).stream().filter(item -> item.getUid().equals(index.getNavigationKey())).findFirst().orElse(null)) == null) continue;
                    ShipmentItemsAppliedRulesVM appliedRulesVM = new ShipmentItemsAppliedRulesVM();
                    appliedRulesVM.setReference(appliedRule.getRulesContainer());
                    appliedRulesVM.setRuleUid(appliedRule.getRuleUid());
                    appliedRulesVM.setService(index.getShortProductName());
                    if (appliedRule.getContract() != null) {
                        appliedRulesVM.setContract(appliedRule.getContract().getCaption());
                    }
                    if (appliedRule.getRulesContainer() != null) {
                        appliedRulesVM.setRulesContainer(appliedRule.getRulesContainer().getCaption());
                    }
                    appliedRulesVM.setName(appliedRule.getRuleName());
                    appliedRulesVM.setDescription(appliedRule.getRuleDescription());
                    appliedRulesVM.setDate(DateUtils.asLocalDate((Date)appliedRule.getCalculationDate()).toString());
                    result.add(appliedRulesVM);
                }
            }
            FxUtil.waitForFxThread(() -> {
                this.getData().setAll((Collection)result);
                this.offset = newOffset;
            });
        }, this.getMutex());
    }

    private static ShipmentAppliedRulesFilterPanel createFilterPanel() {
        ShipmentAppliedRulesFilterPanel filterPanel = new ShipmentAppliedRulesFilterPanel(false);
        filterPanel.getRuleTargetNode().setConverter((StringConverter)new StringConverter<Targets>(){

            public String toString(Targets object) {
                if (object == null) {
                    return "";
                }
                String result = object.getDisplayName();
                return TextUtil.isBlank((String)result) ? object.getId() : result;
            }

            public Targets fromString(String string) {
                return null;
            }
        });
        filterPanel.getRuleActionNode().setConverter((StringConverter)new StringConverter<Actions>(){

            public String toString(Actions object) {
                if (object == null) {
                    return "";
                }
                String result = object.getDisplayName();
                return TextUtil.isBlank((String)result) ? object.getId() : result;
            }

            public Actions fromString(String string) {
                return null;
            }
        });
        return filterPanel;
    }
}

