/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ActionColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpace;
import com.gridnine.xtrip.client.fx.model.system.SysLogDataItemVM;
import com.gridnine.xtrip.client.fx.standard.entity.ShipmentsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.ShipmentAppliedRulesFilterableDataHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentContainer;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsAppliedRulesVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsBillingItemsFilterPanel;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsVendorFinanceDocumentsVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentMainGrid;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpaceController;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.util.StringConverter;

class ShipmentSpaceControllerInterceptor
extends ControllerInterceptor<ShipmentSpaceVM, ShipmentSpaceController> {
    private static final StringConverter DOCUMENT_REFERENCE_CONVERTER = new StringConverter(){

        public String toString(Object object) {
            return Messages.View_Document;
        }

        public Object fromString(String string) {
            return null;
        }
    };
    private static final MultiSupplier<IndexListParameters<BaseProfile, ?>> PAYERS_SUPPLIER = new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){
        IndexListParameters<?, ?>[] listParameters = new IndexListParameters[]{EntityIndexHandler.forIndexClass(OrganizationIndex.class).createListParameters(), EntityIndexHandler.forIndexClass(PersonIndex.class).createListParameters()};

        public int count() {
            return this.listParameters.length;
        }

        public String getDisplayName(int idx) {
            return MetaRegistryHelper.getDisplayName((Class)this.listParameters[idx].getIndexType());
        }

        public IndexListParameters<BaseProfile, ?> get(int idx) {
            return this.listParameters[idx];
        }
    };

    ShipmentSpaceControllerInterceptor() {
    }

    protected Class<ShipmentSpaceController> getControllerClass() {
        return ShipmentSpaceController.class;
    }

    protected void onCreate(ShipmentSpaceController controller) {
        ShipmentContainer shipmentContainer = controller.getView().getOverviewNode();
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getPayerNode().setListParametersSupplier(PAYERS_SUPPLIER);
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getContractNode().setListParametersSupplier(() -> this.getContractSupplier(controller));
        ActionColumn vendorFinanceDocumentColumn = (ActionColumn)((BigTableWidget)shipmentContainer.getVendorFinanceDocumentsCard().getContent()).getColumn("openFinanceDocumentAction");
        vendorFinanceDocumentColumn.setActionHandler(event -> {
            ShipmentItemsVendorFinanceDocumentsVM viewModel = (ShipmentItemsVendorFinanceDocumentsVM)event.getItem();
            RootEntityEditingService.navigateTo((EntityReference)((EntityReference)viewModel.getFinanceDocumentReference()));
        });
        DataViewWidgetHelper.configureSysLogDataView((DataViewWidget<SysLogDataItemVM>)((DataViewWidget)controller.getView().getSystemDataTile().getFullNode()), () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer().toReference();
        }, (ObservableValue<Boolean>)Bindings.not((ObservableBooleanValue)((DataViewWidget)controller.getView().getSystemDataTile().getFullNode()).visibleProperty()));
        ((BigTableWidget)controller.getOverview().getBillingItems().getView()).setControlButtonsAvailability(ControlsPane.NONE);
        ((BigTableWidget)controller.getOverview().getBillingItems().getView()).setFiltering(() -> new ShipmentItemsBillingItemsFilterPanel(false), filterPanel -> vm -> {
            String name = filterPanel.getNameNode().getValue();
            if (TextUtil.nonBlank((String)name) && (vm.getName() == null || !vm.getName().toLowerCase().contains(name.toLowerCase()))) {
                return false;
            }
            String product = filterPanel.getProductNode().getValue();
            if (TextUtil.nonBlank((String)product) && (vm.getProduct() == null || vm.getProduct().getCaption() == null || !vm.getProduct().getCaption().toLowerCase().contains(product.toLowerCase()))) {
                return false;
            }
            String traveller = filterPanel.getTravellerNode().getValue();
            return !TextUtil.nonBlank((String)traveller) || vm.getTraveller() != null && vm.getTraveller().getCaption() != null && vm.getTraveller().getCaption().toLowerCase().contains(traveller.toLowerCase());
        }, true);
        DataViewWidget dataViewWidget = (DataViewWidget)controller.getView().getAppliedRulesTile().getFullNode();
        ShipmentAppliedRulesFilterableDataHandler handler = new ShipmentAppliedRulesFilterableDataHandler(controller);
        dataViewWidget.setHandler((DataViewHandler)handler);
        dataViewWidget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<ShipmentItemsAppliedRulesVM>(){

            public boolean isActive(TableColumn<ShipmentItemsAppliedRulesVM, ?> column, ShipmentItemsAppliedRulesVM item) {
                return false;
            }

            public void onAction(TableColumn<ShipmentItemsAppliedRulesVM, ?> column, ShipmentItemsAppliedRulesVM item) {
                if ("navigate".equals(column.getId())) {
                    ShipmentSpaceControllerInterceptor.this.navigate(item);
                }
            }
        });
        dataViewWidget.setDefaultActionHandler(() -> {
            ShipmentItemsAppliedRulesVM selectedItem = (ShipmentItemsAppliedRulesVM)dataViewWidget.getTableView().getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.navigate(selectedItem);
            }
        });
    }

    private void navigate(ShipmentItemsAppliedRulesVM item) {
        RootEntityEditingService service = RootEntityEditingService.get();
        if (service == null) {
            return;
        }
        service.open(item.getReference(), false, pane -> {
            Node editor = pane.getEditor();
            if (!(editor instanceof ModelContractSpace)) {
                return;
            }
            ModelContractSpace space = (ModelContractSpace)editor;
            space.expand(space.getRulesTile());
            FullRulesWidget fullRulesWidget = (FullRulesWidget)space.getRulesTile().getFullNode();
            fullRulesWidget.selectRule(item.getRuleUid());
            fullRulesWidget.scrollToSelected();
        });
    }

    protected void beforeReadData(ShipmentSpaceController controller, ShipmentSpaceVM model) {
        ((ShipmentMainGrid)controller.getView().getOverviewNode().getMainCard().getContent()).getAmountCheckedNode().valueProperty().removeListener((ChangeListener)new AmountChangedNodeListener(controller));
    }

    protected void afterReadData(ShipmentSpaceController controller, ShipmentSpaceVM model) {
        ShipmentContainer shipmentContainer = controller.getView().getOverviewNode();
        boolean billingItemsExist = ((BigTableWidget)shipmentContainer.getBillingItemsCard().getContent()).getRowsCount() > 0;
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getCustomerNode().getViewState().setNotEditable(billingItemsExist);
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getSupplierNode().getViewState().setNotEditable(billingItemsExist);
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getPayerNode().getViewState().setNotEditable(billingItemsExist);
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getContractNode().getViewState().setNotEditable(billingItemsExist);
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getCorrectingShipmentsCell().setHidden(model.getOverview().getMain().isCorrection());
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getOriginalShipmentCell().setHidden(!model.getOverview().getMain().isCorrection());
        ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getAmountCheckedNode().valueProperty().addListener((ChangeListener)new AmountChangedNodeListener(controller));
        ((DataViewWidget)controller.getView().getAppliedRulesTile().getFullNode()).reloadData();
    }

    private IndexListParameters<Contract, ?> getContractSupplier(ShipmentSpaceController controller) {
        ShipmentContainer shipmentContainer = controller.getView().getOverviewNode();
        EntityReference supplier = ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getSupplierNode().getValue();
        EntityReference customer = ((ShipmentMainGrid)shipmentContainer.getMainCard().getContent()).getCustomerNode().getValue();
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(ContractIndex.class);
        ListParametersHelper.setColumns(result, ContractIndex.Property.name.name(), ContractIndex.Property.supplier.name(), ContractIndex.Property.customer.name(), ContractIndex.Property.contractType.name());
        if (supplier != null) {
            result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier));
        }
        if (customer != null) {
            result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)customer));
        }
        return result;
    }

    private static class AmountChangedNodeListener
    implements ChangeListener<Boolean> {
        private final ShipmentSpaceController controller;
        private final BooleanValueWidget widget;

        public AmountChangedNodeListener(ShipmentSpaceController controller) {
            this.controller = controller;
            this.widget = ((ShipmentMainGrid)controller.getView().getOverviewNode().getMainCard().getContent()).getAmountCheckedNode();
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (((TableWidget)this.controller.getOverview().getFinanceDocuments().getView()).getRowsCount() > 0) {
                RootEntityPane context = Objects.requireNonNull(RootEntityPane.lookup((Node)this.controller.getView()));
                Dialog.confirm((String)Messages.UpdateRelatedFinanceDocuments, () -> Notifications.get().submitTask(() -> {
                    context.saveData();
                    ShipmentsHelper.updateShipment((EntityReference<Shipment>)context.getData().getContainer().toReference());
                }, context.getMutex()));
            }
        }

        public int hashCode() {
            return this.widget.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AmountChangedNodeListener)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.widget.equals(((AmountChangedNodeListener)obj).widget);
        }
    }
}

