/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentMainGrid;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpace;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.ShipmentsService;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;

public class ShipmentEditorInterceptor
implements RootEntityEditorInterceptor<Shipment, ShipmentUIData> {
    public void onLoad(DataTransferPackage<Shipment, ShipmentUIData> data, Node editor) {
    }

    public boolean onSave(DataTransferPackage<Shipment, ShipmentUIData> data, Node editor) {
        try {
            ShipmentSpace space = (ShipmentSpace)editor;
            ArrayList<Message> messages = new ArrayList<Message>();
            this.checkNumber(data, space, messages);
            Notifications.get().showMessages(messages);
            return !MessagesHelper.hasErrorMessage(messages);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return true;
        }
    }

    private void checkNumber(DataTransferPackage<Shipment, ShipmentUIData> data, ShipmentSpace space, List<Message> messages) throws Exception {
        String oldNumber = ((Shipment)data.getContainer().getEntity()).getNumber();
        String newNumber = ((ShipmentMainGrid)space.getOverviewNode().getMainCard().getContent()).getNumberNode().getValue();
        if (TextUtil.isBlank((String)newNumber) || newNumber.equals(oldNumber)) {
            return;
        }
        boolean shipmentWithSameNumberExists = ((ShipmentsService)RpcServiceManager.get().getService(ShipmentsService.class)).isShipmentWithSameNumberExists(ServiceInvocationContext.get(), newNumber, data.getContainer().toReference(), ((ShipmentMainGrid)space.getOverviewNode().getMainCard().getContent()).getSupplierNode().getValue(), ((Shipment)data.getContainer().getEntity()).getContract(), MiscUtil.toDate((LocalDateTime)((ShipmentMainGrid)space.getOverviewNode().getMainCard().getContent()).getDateNode().getValue()));
        if (shipmentWithSameNumberExists) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ShipmentWithNumberAlreadyExists, (Object[])new Object[]{newNumber}));
        }
    }
}

