/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.profile.HoldingAddressGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingAddressMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingContactsPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingCreditsFilterPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingCreditsGridPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingCreditsPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingGeneral;
import com.gridnine.xtrip.client.fx.model.profile.HoldingGeneralHolding;
import com.gridnine.xtrip.client.fx.model.profile.HoldingGeneralRequisites;
import com.gridnine.xtrip.client.fx.model.profile.HoldingOtherParametersMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingOtherParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.HoldingSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.HoldingSpaceVM;
import com.gridnine.xtrip.client.fx.standard.helpers.CompactConverter;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Collections;
import javafx.event.EventHandler;
import javafx.scene.Node;

public class HoldingControllerInterceptor
extends ControllerInterceptor<HoldingSpaceVM, HoldingSpaceController> {
    private static final CompactConverter<HoldingCreditsGridPanel> CREDITS_CONVERTER = new CompactConverter<HoldingCreditsGridPanel>(panel -> {
        ArrayList<String> list = new ArrayList<String>();
        if (panel.getCreditorNode().getValue() != null) {
            list.add(panel.getCreditorNode().getValue().toString());
        }
        return list;
    });
    private static final CompactConverter<HoldingAddressMainPanel> ADDRESS_PANEL_CONVERTER = new CompactConverter<HoldingAddressMainPanel>(panel -> {
        StringBuilder builder = new StringBuilder();
        if (((HoldingAddressGeneralPanel)panel.getGeneralCard().getContent()).getTypeNode().getValue() != null) {
            builder.append(((AddressType)((HoldingAddressGeneralPanel)panel.getGeneralCard().getContent()).getTypeNode().getValue()).toString());
            builder.append(" ");
        }
        if (((HoldingAddressGeneralPanel)panel.getGeneralCard().getContent()).getCityNode().getValue() != null) {
            builder.append(((HoldingAddressGeneralPanel)panel.getGeneralCard().getContent()).getCityNode().getValue().toString());
        }
        return Collections.singletonList(builder.toString());
    });

    private static HoldingCreditsFilterPanel createCreditFilterPanel(HoldingSpaceController controller) {
        HoldingCreditsFilterPanel filterPanel = new HoldingCreditsFilterPanel(false);
        filterPanel.getCreditorNode().setLive(true);
        filterPanel.getCreditorNode().setItemsSupplier(() -> {
            ArrayList result = new ArrayList();
            ((ExpandedGroupsWidget)((HoldingCreditsPanel)controller.getView().getFinanceTile().getFullNode()).getContent()).getViews().forEach(view -> {
                if (view.getCreditorNode().valueProperty().get() != null) {
                    result.add(view.getCreditorNode().valueProperty().get());
                }
            });
            return result;
        }, false);
        return filterPanel;
    }

    private static void setStringConverters(HoldingSpaceController main) {
        ((HoldingOtherParametersMainPanel)((HoldingOtherParametersPanel)main.getView().getOtherParametersTile().getFullNode()).getMainCard().getContent()).getIrrelevantNode().setConverter(Converters.boolConverter((String)Messages.Dont_show_in_list, (String)Messages.Show_in_list));
        ((HoldingGeneralRequisites)((HoldingGeneral)main.getView().getGeneralTile().getFullNode()).getRequisitesCard().getContent()).getForeignNode().setConverter(Converters.boolConverter((String)Messages.NonResident, (String)Messages.Resident));
        ((HoldingGeneralRequisites)((HoldingGeneral)main.getView().getGeneralTile().getFullNode()).getRequisitesCard().getContent()).getSimpleTaxedNode().setConverter(Converters.boolConverter((String)Messages.Simplified_USN, (String)Messages.Common_OSNO));
        ((ExpandedGroupsWidget)((HoldingContactsPanel)main.getView().getContactsTile().getFullNode()).getAddressesCard().getContent()).setConverter(ADDRESS_PANEL_CONVERTER);
        ((ExpandedGroupsWidget)((HoldingCreditsPanel)main.getView().getFinanceTile().getFullNode()).getContent()).setConverter(CREDITS_CONVERTER);
    }

    protected Class<HoldingSpaceController> getControllerClass() {
        return HoldingSpaceController.class;
    }

    protected void onCreate(HoldingSpaceController controller) {
        HoldingControllerInterceptor.setStringConverters(controller);
        controller.getView().getGeneralTile().expandedProperty().addListener((s, o, n) -> {
            if (!n.booleanValue()) {
                controller.getOverview().setCode(((HoldingGeneralHolding)((HoldingGeneral)controller.getView().getGeneralTile().getFullNode()).getHoldingCard().getContent()).getCodeNode().getValue());
                controller.getOverview().setName((L10nString)((HoldingGeneralHolding)((HoldingGeneral)controller.getView().getGeneralTile().getFullNode()).getHoldingCard().getContent()).getFullNameNode().valueProperty().get());
            }
        });
        ((ExpandedGroupsWidget)((HoldingCreditsPanel)controller.getView().getFinanceTile().getFullNode()).getContent()).setFiltering(() -> HoldingControllerInterceptor.createCreditFilterPanel(controller), filterPanel -> view -> {
            if (filterPanel.getCreditorNode().valueProperty().get() == null) {
                return true;
            }
            if (view.getCreditorNode().valueProperty().get() != null) {
                return ((EntityReference)view.getCreditorNode().valueProperty().get()).equals(filterPanel.getCreditorNode().valueProperty().get());
            }
            return false;
        }, true);
        EventHandler handler = evt -> {
            DataTransferPackage dtp = RootEntityPane.lookup((Node)controller.getView()).getData();
            if (dtp == null || dtp.getContainer() == null) {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
                return;
            }
            EntityReference ref = dtp.getContainer().toReference();
            IndexListParameters params = EntityIndexHandler.forIndexClass(OrganizationIndex.class).createListParameters();
            params.getSearchCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.holding.name(), (Object)ref));
            IndexListService.get().open("organizations-for-" + ref.getUid(), Messages.Organizations_related_to + ref, params);
        };
        controller.getView().getOverviewNode().getOrganizationsNode().setOnAction(handler);
    }
}

