/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractActionsDialogContainerContractsTableVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;

final class ModelContractActionsHelper {
    private ModelContractActionsHelper() {
    }

    static void addToContractList(final Collection<ModelContractActionsDialogContainerContractsTableVM> contractTableVM, final EntityReference<ModelContract> modelContractRef, final ContractsCallback executable) {
        Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Adding_a_rule_to_the_contract;
            }

            protected void execute() throws Exception {
                int progressPercent = 0;
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService service = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                this.setProgress((byte)(progressPercent += 15), "");
                int step = 85 / contractTableVM.size();
                ArrayList<EntityReference> contractList = new ArrayList<EntityReference>();
                for (ModelContractActionsDialogContainerContractsTableVM contractVM : contractTableVM) {
                    EntityReference contractRef = contractVM.getCustomer();
                    Date startDate = DateUtils.asDate((LocalDate)contractVM.getStartDate());
                    Date endDate = MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)contractVM.getEndDate()));
                    boolean translateSupplierFees = contractVM.isTranslateSupplierFees();
                    EntityContainer contractContainer = service.load(sic, contractRef);
                    this.setProgress((byte)(progressPercent += step), "");
                    if (((Contract)contractContainer.getEntity()).getModelContracts().stream().noneMatch(c2mc -> modelContractRef.equals((Object)c2mc.getModelContract()) && Objects.equals(c2mc.getStartDate(), startDate) && Objects.equals(c2mc.getEndDate(), endDate) && c2mc.isTranslateSupplierFees() == translateSupplierFees)) {
                        Contract2ModelContract c2mc2 = new Contract2ModelContract();
                        contractList.add(contractRef);
                        c2mc2.setModelContract(modelContractRef);
                        c2mc2.setStartDate(startDate);
                        c2mc2.setEndDate(endDate);
                        c2mc2.setTranslateSupplierFees(translateSupplierFees);
                        ((Contract)contractContainer.getEntity()).getModelContracts().add(c2mc2);
                        contractContainer.getVersionInfo().setDataSource("fx-contract-editor");
                        contractContainer.getVersionInfo().setVersionNotes("add model contract to contracts");
                        executable.setContainer(service.save(sic, contractContainer, null, true));
                        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Rule + modelContractRef.getCaption() + Messages.Added_to_the_contract + contractRef.getCaption()), (Object[])new Object[0])});
                        continue;
                    }
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Rule + modelContractRef.getCaption() + Messages.Already_in_the_contract + contractRef.getCaption()), (Object[])new Object[0])});
                }
                if (!contractList.isEmpty()) {
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)contractList.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                }
                FxUtil.waitForFxThread((Executable)executable);
                this.setProgress((byte)100, "");
            }
        });
    }

    static void removeFromContractList(final Collection<ContractData> contractDataList, final EntityReference<ModelContract> modelContractRef, final ContractsCallback executable) {
        Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Remove_rule_from_contract;
            }

            protected void execute() throws Exception {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService service = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                this.setProgress((byte)15, "");
                ArrayList<EntityReference<Contract>> contractList = new ArrayList<EntityReference<Contract>>();
                for (ContractData contractData : contractDataList) {
                    EntityReference<Contract> contractRef = contractData.getContractRef();
                    EntityContainer contractContainer = service.load(sic, contractRef);
                    ((Contract)contractContainer.getEntity()).getModelContracts().removeIf(m2mc -> modelContractRef.equals((Object)m2mc.getModelContract()) && Objects.equals(m2mc.getStartDate(), contractData.getStartDate()) && Objects.equals(m2mc.getEndDate(), contractData.getEndDate()) && m2mc.isTranslateSupplierFees() == contractData.isTranslateSupplierFees());
                    contractContainer.getVersionInfo().setDataSource("fx-contract-editor");
                    contractContainer.getVersionInfo().setVersionNotes("remove model contract from contracts");
                    executable.setContainer(service.save(sic, contractContainer, null, true));
                    contractList.add(contractRef);
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Rule + modelContractRef.getCaption() + Messages.Deleted_from_contract + contractRef.getCaption()), (Object[])new Object[0])});
                }
                if (!contractList.isEmpty()) {
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)contractList.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                }
                FxUtil.waitForFxThread((Executable)executable);
                this.setProgress((byte)100, "");
            }
        });
    }

    public static abstract class ContractsCallback
    implements Executable {
        protected EntityContainer<?> container;

        public void setContainer(EntityContainer<?> containerValue) {
            this.container = containerValue;
        }
    }

    static class ContractData {
        private final EntityReference<Contract> contractRef;
        private final Date startDate;
        private final Date endDate;
        private final boolean translateSupplierFees;

        public ContractData(EntityReference<Contract> contractRef, Date startDate, Date endDate, boolean translateSupplierFees) {
            this.contractRef = contractRef;
            this.startDate = startDate;
            this.endDate = endDate;
            this.translateSupplierFees = translateSupplierFees;
        }

        public EntityReference<Contract> getContractRef() {
            return this.contractRef;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public boolean isTranslateSupplierFees() {
            return this.translateSupplierFees;
        }
    }
}

