/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationBankAccountVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationDocumentsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentSettingVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPaymentDocumentSettingVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPaymentDocumentVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSignatureVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentSettings;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.BinaryData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OrganizationDocumentsTileHelper {
    private OrganizationDocumentsTileHelper() {
    }

    public static void toVM(ShipmentProperties shipmentProperties, FinanceDocumentsProperties financeDocumentsProperties, PaymentDocumentsProperties paymentDocumentProperties, OrganizationDocumentsPanelVM full) {
        full.getShipment().setNumberPeriod(shipmentProperties.getNumberPeriod());
        full.getShipment().setNumberSerial(shipmentProperties.getNumberSerial());
        full.getShipment().setNumberPattern(shipmentProperties.getNumberPattern());
        full.getShipment().setNumberPatternCorrection(shipmentProperties.getNumberPatternCorrection());
        full.getShipment().setCreateAfterShipmentDateOnly(shipmentProperties.isCreateAfterShipmentDateOnly());
        full.getFinanceDocuments().setNumberSerial(financeDocumentsProperties.getNumberSerial());
        full.getFinanceDocuments().setNumberPeriod(financeDocumentsProperties.getNumberPeriod());
        if (financeDocumentsProperties.getBankAccount() != null) {
            OrganizationBankAccountVM bankAccount = new OrganizationBankAccountVM();
            bankAccount.setBankAccount(financeDocumentsProperties.getBankAccount());
            full.getFinanceDocuments().setBankAccount(bankAccount);
        }
        full.getPaymentDocuments().setNumberPeriod(paymentDocumentProperties.getNumberPeriod());
        full.getPaymentDocuments().setNumberSerial(paymentDocumentProperties.getNumberSerial());
        OrganizationDocumentsTileHelper.updateFinanceDocumentsSettings(financeDocumentsProperties.getFinanceDocumentsSettings());
        VMHelper.transfer(financeDocumentsProperties.getFinanceDocumentsSettings(), full.getFinanceDocuments().getTable(), settings -> new OrganizationFinanceDocumentVM(), (settings, documentVM) -> {
            documentVM.setType(settings.getType());
            documentVM.setUseDocument(settings.isUseDocument());
            documentVM.setUseSettings(settings.isUseSettings());
            OrganizationFinanceDocumentSettingVM settingsVM = documentVM.getSettings();
            settingsVM.getGeneral().setTemplate(settings.getTemplate());
            settingsVM.getGeneral().setNumberPattern(settings.getNumberPattern());
            settingsVM.getGeneral().setNumberPatternVendor(settings.getNumberPatternVendor());
            VMHelper.transfer(settings.getSignatures(), documentVM.getSettings().getSignatures(), signature -> new OrganizationSignatureVM(), (signature, vm) -> {
                vm.setSigner(signature.getSigner());
                vm.setPosition(signature.getPosition());
                vm.setTitle(signature.getTitle());
                vm.setComment(signature.getComment());
            });
            if (settings.getStamp() != null) {
                BinaryData bd = new BinaryData();
                bd.setData(settings.getStamp());
                documentVM.getSettings().setStamp(bd);
            }
        });
        OrganizationDocumentsTileHelper.updatePaymentDocumentsSettings(paymentDocumentProperties.getPaymentDocumentsSettings());
        VMHelper.transfer(paymentDocumentProperties.getPaymentDocumentsSettings(), full.getPaymentDocuments().getTable(), settings -> new OrganizationPaymentDocumentVM(), (settings, documentVM) -> {
            documentVM.setType(settings.getType());
            documentVM.setUseDocument(settings.isUseDocument());
            documentVM.setUseSettings(settings.isUseSettings());
            OrganizationPaymentDocumentSettingVM settingsVM = documentVM.getSettings();
            settingsVM.getGeneral().setTemplate(settings.getTemplate());
            settingsVM.getGeneral().setUseFacsimile(settings.isUseFacsimile());
            settingsVM.getGeneral().setNumberPattern(settings.getNumberPattern());
            VMHelper.transfer(settings.getSignatures(), documentVM.getSettings().getSignatures(), signature -> new OrganizationSignatureVM(), (signature, vm) -> {
                vm.setSigner(signature.getSigner());
                vm.setPosition(signature.getPosition());
                vm.setTitle(signature.getTitle());
                vm.setComment(signature.getComment());
            });
            if (settings.getStamp() != null) {
                BinaryData bd = new BinaryData();
                bd.setData(settings.getStamp());
                documentVM.getSettings().setStamp(bd);
            }
        });
    }

    private static void updateFinanceDocumentsSettings(List<FinanceDocumentSettings> financeDocumentsSettings) {
        ArrayList<FinanceDocumentSettings> updatedSettings = new ArrayList<FinanceDocumentSettings>();
        Predicate<FinanceDocumentType> filter = OrganizationDocumentsTileHelper.getFinanceDocumentTypesFilter();
        for (FinanceDocumentType type : Stream.of(FinanceDocumentType.values()).filter(filter).collect(Collectors.toList())) {
            FinanceDocumentSettings settings = null;
            for (FinanceDocumentSettings financeDocumentSettings : financeDocumentsSettings) {
                if (financeDocumentSettings.getType() == null || !financeDocumentSettings.getType().equals((Object)type)) continue;
                settings = financeDocumentSettings;
                break;
            }
            if (settings == null) {
                settings = new FinanceDocumentSettings();
                settings.setType(type);
            }
            updatedSettings.add(settings);
        }
        financeDocumentsSettings.clear();
        financeDocumentsSettings.addAll(updatedSettings);
    }

    private static void updatePaymentDocumentsSettings(List<PaymentDocumentSettings> paymentDocumentsSettings) {
        ArrayList<PaymentDocumentSettings> updatedSettings = new ArrayList<PaymentDocumentSettings>();
        Predicate<PaymentDocumentType> filter = OrganizationDocumentsTileHelper.getPaymentDocumentTypesFilter();
        for (PaymentDocumentType type : Stream.of(PaymentDocumentType.values()).filter(filter).collect(Collectors.toList())) {
            PaymentDocumentSettings settings = null;
            for (PaymentDocumentSettings paymentDocumentSettings : paymentDocumentsSettings) {
                if (paymentDocumentSettings.getType() == null || !paymentDocumentSettings.getType().equals((Object)type)) continue;
                settings = paymentDocumentSettings;
                break;
            }
            if (settings == null) {
                settings = new PaymentDocumentSettings();
                settings.setType(type);
            }
            updatedSettings.add(settings);
        }
        paymentDocumentsSettings.clear();
        paymentDocumentsSettings.addAll(updatedSettings);
    }

    private static Predicate<FinanceDocumentType> getFinanceDocumentTypesFilter() {
        return FinanceDocumentsHelper.types::contains;
    }

    private static Predicate<PaymentDocumentType> getPaymentDocumentTypesFilter() {
        return type -> type != PaymentDocumentType.DEBIT_BANK_TRANSFER_ORDER && type != PaymentDocumentType.CREDIT_BANK_TRANSFER_ORDER;
    }

    public static void fromVM(OrganizationDocumentsPanelVM full, ShipmentProperties shipmentProperties, FinanceDocumentsProperties financeDocumentsProperties, PaymentDocumentsProperties paymentDocumentProperties) {
        shipmentProperties.setNumberPeriod(full.getShipment().getNumberPeriod());
        shipmentProperties.setNumberSerial(full.getShipment().getNumberSerial());
        shipmentProperties.setNumberPattern(full.getShipment().getNumberPattern());
        shipmentProperties.setNumberPatternCorrection(full.getShipment().getNumberPatternCorrection());
        shipmentProperties.setCreateAfterShipmentDateOnly(full.getShipment().isCreateAfterShipmentDateOnly());
        financeDocumentsProperties.setNumberSerial(full.getFinanceDocuments().getNumberSerial());
        financeDocumentsProperties.setNumberPeriod(full.getFinanceDocuments().getNumberPeriod());
        paymentDocumentProperties.setNumberPeriod(full.getPaymentDocuments().getNumberPeriod());
        paymentDocumentProperties.setNumberSerial(full.getPaymentDocuments().getNumberSerial());
        VMHelper.transfer(full.getFinanceDocuments().getTable(), financeDocumentsProperties.getFinanceDocumentsSettings(), vm -> new FinanceDocumentSettings(), (vm, settings) -> {
            settings.setType(vm.getType());
            settings.setUseDocument(vm.isUseDocument());
            settings.setUseSettings(vm.isUseSettings());
            OrganizationFinanceDocumentSettingVM settingsVM = vm.getSettings();
            settings.setTemplate(settingsVM.getGeneral().getTemplate());
            settings.setNumberPattern(settingsVM.getGeneral().getNumberPattern());
            settings.setNumberPatternVendor(settingsVM.getGeneral().getNumberPatternVendor());
            VMHelper.transfer(vm.getSettings().getSignatures(), settings.getSignatures(), signatureVM -> new Signature(), (signatureVM, signature) -> {
                signature.setSigner(signatureVM.getSigner());
                signature.setPosition(signatureVM.getPosition());
                if (signatureVM.getTitle() != null) {
                    signature.getTitle().getValues().clear();
                    signature.getTitle().getValues().putAll(signatureVM.getTitle().getValues());
                }
                signature.setComment(signatureVM.getComment());
            });
            settings.setStamp(vm.getSettings().getStamp() == null ? null : vm.getSettings().getStamp().getData());
        });
        VMHelper.transfer(full.getPaymentDocuments().getTable(), paymentDocumentProperties.getPaymentDocumentsSettings(), vm -> new PaymentDocumentSettings(), (vm, settings) -> {
            settings.setType(vm.getType());
            settings.setUseDocument(vm.isUseDocument());
            settings.setUseSettings(vm.isUseSettings());
            OrganizationPaymentDocumentSettingVM settingsVM = vm.getSettings();
            settings.setTemplate(settingsVM.getGeneral().getTemplate());
            settings.setNumberPattern(settingsVM.getGeneral().getNumberPattern());
            settings.setUseFacsimile(settingsVM.getGeneral().isUseFacsimile());
            settings.setStamp(vm.getSettings().getStamp() == null ? null : vm.getSettings().getStamp().getData());
            VMHelper.transfer(vm.getSettings().getSignatures(), settings.getSignatures(), signatureVM -> new Signature(), (signatureVM, signature) -> {
                signature.setSigner(signatureVM.getSigner());
                signature.setPosition(signatureVM.getPosition());
                if (signatureVM.getTitle() != null) {
                    signature.getTitle().getValues().clear();
                    signature.getTitle().getValues().putAll(signatureVM.getTitle().getValues());
                }
                signature.setComment(signatureVM.getComment());
            });
        });
    }
}

