/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGroupVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import java.util.stream.Collectors;

final class OrganizationGeneralTileHelper {
    private OrganizationGeneralTileHelper() {
    }

    static void toVM(Organization model, OrganizationGeneralPanelVM full) {
        full.getMain().getTypes().clear();
        model.getTypes().forEach(type -> full.getMain().getTypes().add(type));
        full.getMain().setCode(model.getCode());
        full.getMain().setClientId(model.getClientID());
        full.getMain().setHolding(model.getHolding());
        full.getMain().setParent(model.getParent());
        full.getMain().setCompanyGroup(model.getCompanyGroup());
        full.getMain().setLegalForm(model.getLegalForm());
        full.getMain().setShortName(model.getShortName());
        full.getMain().setFullName(model.getFullName());
        full.getMain().setProfile(model.getIndividualEntrepreneur());
        full.getRequisites().getRegistrationId().clear();
        model.getRegistrationIdHistory().forEach(full.getRequisites().getRegistrationId()::add);
        full.getRequisites().getKpp().clear();
        model.getKppHistory().forEach(full.getRequisites().getKpp()::add);
        full.getRequisites().getBin().clear();
        model.getBinHistory().forEach(full.getRequisites().getBin()::add);
        full.getRequisites().getVatSeriesNumber().clear();
        model.getVatSeriesNumberHistory().forEach(full.getRequisites().getVatSeriesNumber()::add);
        full.getRequisites().getVatSeriesDate().clear();
        model.getVatSeriesDateHistory().forEach(full.getRequisites().getVatSeriesDate()::add);
        full.getRequisites().setOkpoCode(model.getOkpoCode());
        full.getRequisites().getVatLicenseNumber().clear();
        model.getVatLicenseNumberHistory().forEach(full.getRequisites().getVatLicenseNumber()::add);
        full.getRequisites().getVatPayer().clear();
        model.getVatPayerHistory().forEach(full.getRequisites().getVatPayer()::add);
        full.getRequisites().setVatExemption(model.isVATExemption());
        full.getRequisites().setPenaltyUnderVAT(model.isPenaltyUnderVAT());
        full.getRequisites().setSimpleTaxed(model.isSimpleTaxed());
        full.getRequisites().getVatRate().clear();
        model.getVatRateHistory().forEach(full.getRequisites().getVatRate()::add);
        full.getRequisites().setForeign(model.isForeign());
        full.getRequisites().setBeneficiaryCode(model.getBeneficiaryCode());
        VMHelper.transfer(model.getMetadata().stream().filter(data -> data.getKey() != null && MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name().equals(data.getKey().getCode())).collect(Collectors.toList()), full.getGroups().getGroupTable(), md -> new OrganizationGroupVM(), (md, vm) -> vm.setGroup((DictionaryReference)md.getValue()));
        full.getMain().setAirline(model.getAirline());
        if (!model.getProfileGroups().isEmpty()) {
            full.getGroups().getGroupTable().clear();
            model.getProfileGroups().stream().distinct().forEach(group -> {
                OrganizationGroupVM groupVM = new OrganizationGroupVM();
                groupVM.setGroup(group);
                full.getGroups().getGroupTable().add(groupVM);
            });
        }
    }

    static void fromVM(OrganizationGeneralPanelVM full, Organization model) {
        model.setCode(full.getMain().getCode());
        model.setClientID(full.getMain().getClientId());
        model.setHolding(full.getMain().getHolding());
        model.setParent(full.getMain().getParent());
        model.setCompanyGroup(full.getMain().getCompanyGroup());
        model.setLegalForm(full.getMain().getLegalForm());
        model.setIndividualEntrepreneur(full.getMain().getProfile());
        if (full.getMain().getShortName() != null) {
            model.getShortName().getValues().clear();
            model.getShortName().getValues().putAll(full.getMain().getShortName().getValues());
        }
        if (full.getMain().getFullName() != null) {
            model.getFullName().getValues().clear();
            model.getFullName().getValues().putAll(full.getMain().getFullName().getValues());
        }
        model.getTypes().clear();
        model.getTypes().addAll(full.getMain().getTypes());
        model.setAirline(full.getMain().getAirline());
        model.getRegistrationIdHistory().clear();
        full.getRequisites().getRegistrationId().forEach(model.getRegistrationIdHistory()::add);
        model.getKppHistory().clear();
        full.getRequisites().getKpp().forEach(model.getKppHistory()::add);
        model.getBinHistory().clear();
        full.getRequisites().getBin().forEach(model.getBinHistory()::add);
        model.getVatSeriesNumberHistory().clear();
        full.getRequisites().getVatSeriesNumber().forEach(model.getVatSeriesNumberHistory()::add);
        model.getVatSeriesDateHistory().clear();
        full.getRequisites().getVatSeriesDate().forEach(model.getVatSeriesDateHistory()::add);
        model.setOkpoCode(full.getRequisites().getOkpoCode());
        model.getVatLicenseNumberHistory().clear();
        full.getRequisites().getVatLicenseNumber().forEach(model.getVatLicenseNumberHistory()::add);
        model.getVatPayerHistory().clear();
        full.getRequisites().getVatPayer().forEach(model.getVatPayerHistory()::add);
        model.setVATExemption(full.getRequisites().isVatExemption());
        model.setPenaltyUnderVAT(full.getRequisites().isPenaltyUnderVAT());
        model.setSimpleTaxed(full.getRequisites().isSimpleTaxed());
        model.getVatRateHistory().clear();
        full.getRequisites().getVatRate().forEach(model.getVatRateHistory()::add);
        model.setForeign(full.getRequisites().isForeign());
        model.setBeneficiaryCode(full.getRequisites().getBeneficiaryCode());
        VMHelper.transfer(full.getGroups().getGroupTable(), model.getMetadata(), md -> md.getKey() != null && MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name().equals(md.getKey().getCode()), vm -> new Metadata(), (vm, md) -> {
            md.setKey((DictionaryReference)new MetadataKeyDescriptorReference(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()));
            md.setValue((Object)vm.getGroup());
        });
        VMHelper.transfer(full.getGroups().getGroupTable(), model.getProfileGroups(), vm -> {
            if (vm.getGroup() == null) {
                return null;
            }
            ProfileGroupReference profileGroupReference = new ProfileGroupReference();
            profileGroupReference.setCode(vm.getGroup().getCode());
            profileGroupReference.setCaption(vm.getGroup().getCaption());
            return profileGroupReference;
        });
    }
}

