/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidValueVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.stream.Collectors;

public final class OrganizationUdidsTileHelper {
    private OrganizationUdidsTileHelper() {
    }

    static void toVM(Organization model, OrganizationUdidsPanelVM fullGeneral, OrganizationUdidsDetailsPanelVM fullDetails) {
        model.getCostCodeProperties().forEach(udidType -> {
            OrganizationUdidVM fullGeneralVM = new OrganizationUdidVM();
            fullGeneralVM.setUid(udidType.getUid());
            fullGeneralVM.setNumber(udidType.getType());
            fullGeneralVM.setCategory(udidType.getCategory());
            fullGeneralVM.setName(udidType.getName());
            fullGeneralVM.setShowInTickets(udidType.getDisplayType());
            fullGeneralVM.setStartDate(DateUtils.asLocalDate((Date)udidType.getStartDate()));
            fullGeneralVM.setEndDate(DateUtils.asLocalDate((Date)udidType.getEndDate()));
            fullGeneral.getGeneral().add(fullGeneralVM);
            OrganizationUdidDetailsVM fullDetailsVM = new OrganizationUdidDetailsVM();
            fullDetailsVM.setUid(udidType.getUid());
            fullDetailsVM.getUdidType().setCategoryHidden(udidType.getCategory());
            fullDetailsVM.getUdidType().setNumberHidden(udidType.getType());
            fullDetailsVM.getUdidType().setSabreRemarks(udidType.getSabreRemarks());
            fullDetailsVM.getUdidType().setSabreValue(udidType.getSabreValue());
            fullDetailsVM.getUdidType().setMask(udidType.getMask());
            fullDetailsVM.getUdidType().setSabreDropList(udidType.isSabreDropList());
            fullDetailsVM.getUdidType().setDontSyncToSabre(udidType.isDontSyncToSabre());
            fullDetailsVM.getUdidType().setPassValueInSabreToOrder(udidType.isPassValueInSabreToOrder());
            fullDetailsVM.getUdidType().setFillingPoint(udidType.getFillingPoint());
            VMHelper.transfer(model.getCostCodes().stream().filter(udid -> udid.getCostCodeProperties().equals(udidType)).collect(Collectors.toList()), fullDetailsVM.getUdidValues(), uv -> new OrganizationUdidValueVM(), (uv, vm) -> {
                vm.getValue().set((Object)uv.getValue());
                vm.setLocalValue(uv.getLocalValue());
                vm.setEnglishValue(uv.getEnglishValue());
            });
            fullDetailsVM.getUdidValues().sort(Comparator.comparing(vm -> (String)vm.getValue().get(), Comparator.nullsLast(Comparator.naturalOrder())));
            fullDetails.getExtraParameters().add(fullDetailsVM);
        });
    }

    static void fromVM(OrganizationUdidsPanelVM fullGeneral, OrganizationUdidsDetailsPanelVM fullDetails, Organization model) {
        ArrayList newValues = new ArrayList();
        VMHelper.transfer(fullGeneral.getGeneral(), model.getCostCodeProperties(), vm -> new CostCodeProperties(), (vm, props) -> {
            props.setType(vm.getNumber());
            props.setCategory(vm.getCategory());
            props.setName(vm.getName());
            props.setDisplayType(vm.getShowInTickets());
            props.setStartDate(DateUtils.asDate((LocalDate)vm.getStartDate()));
            props.setEndDate(DateUtils.asDate((LocalDate)vm.getEndDate()));
        });
        VMHelper.transfer(fullDetails.getExtraParameters(), model.getCostCodeProperties(), vm -> new CostCodeProperties(), (vm, props) -> {
            props.setSabreRemarks(vm.getUdidType().getSabreRemarks());
            props.setSabreValue(vm.getUdidType().getSabreValue());
            props.setMask(vm.getUdidType().getMask());
            props.setSabreDropList(vm.getUdidType().isSabreDropList());
            props.setDontSyncToSabre(vm.getUdidType().isDontSyncToSabre());
            props.setPassValueInSabreToOrder(vm.getUdidType().isPassValueInSabreToOrder());
            props.setFillingPoint(vm.getUdidType().getFillingPoint());
            ArrayList list = new ArrayList();
            vm.getUdidValues().forEach(udidValue -> {
                CostCode code = new CostCode();
                code.setUid(udidValue.getUid());
                code.setCostCodeProperties(props);
                code.setValue((String)udidValue.getValue().get());
                code.setLocalValue(udidValue.getLocalValue());
                code.setEnglishValue(udidValue.getEnglishValue());
                list.add(code);
            });
            VMHelper.transfer(list, model.getCostCodes(), udidVM -> new CostCode(), (udidVM, udid) -> {
                udid.setCostCodeProperties(props);
                udid.setValue(udidVM.getValue());
                udid.setLocalValue(udidVM.getLocalValue());
                udid.setEnglishValue(udidVM.getEnglishValue());
            });
            newValues.addAll(list);
        });
        model.getCostCodes().clear();
        model.getCostCodes().addAll(newValues);
    }
}

