/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.profile.CardPanel;
import com.gridnine.xtrip.client.fx.model.profile.CardPanelController;
import com.gridnine.xtrip.client.fx.model.profile.CardVM;
import com.gridnine.xtrip.client.fx.model.profile.CardsMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.standard.helpers.CardsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.PCIDSSService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class OrganizationAndPersonCardsPanelControllerInterceptor
extends ControllerInterceptor<CardVM, CardPanelController> {
    protected Class<CardPanelController> getControllerClass() {
        return CardPanelController.class;
    }

    protected void afterReadData(CardPanelController controller, CardVM model) {
        controller.getView().getPopulateCardNumberNode().setText(controller.getView().getNumberNode().getValue() == null ? Messages.Fill_in_the_number : Messages.View_Number);
        CardPanel panel = controller.getView();
        PCIDSSServerExchangeSettings settings = Prefetched.getData().getPCIDSSServerExchangeSettings();
        boolean cirEnabled = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)settings);
        if (panel.getNumberNode().getValue() != null) {
            panel.getOwnerNode().getViewState().setNotEditable(cirEnabled);
            panel.getExpirationDateNode().getViewState().setNotEditable(cirEnabled);
            panel.getCardTypeNode().getViewState().setNotEditable(cirEnabled);
        }
    }

    protected void onCreate(CardPanelController controller) {
        CardPanel panel = controller.getView();
        panel.getCirUidCell().setHidden(true);
        panel.getUidCell().setHidden(true);
        PCIDSSServerExchangeSettings settings = Prefetched.getData().getPCIDSSServerExchangeSettings();
        boolean cirEnabled = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)settings);
        panel.getPopulateCardNumberCell().setHidden(!cirEnabled);
        panel.getNumberNode().getViewState().setNotEditable(cirEnabled);
        if (cirEnabled) {
            panel.getNumberNode().valueProperty().addListener((obj, oldValue, newValue) -> panel.getPopulateCardNumberNode().setText(newValue == null ? Messages.Fill_in_the_number : Messages.View_Number));
            panel.getPopulateCardNumberNode().onActionProperty().setValue(event -> OrganizationAndPersonCardsPanelControllerInterceptor.openBrowserToPopulateCardNumberInCIR(panel, settings));
        }
    }

    private static void openBrowserToPopulateCardNumberInCIR(CardPanel cardPanel, PCIDSSServerExchangeSettings settings) {
        Card shortcutCard = CardsHelper.getShortcutCardFromView(cardPanel);
        if (cardPanel.getNumberNode().getValue() != null && cardPanel.getCirUidNode().getValue() != null) {
            String webAddress = String.format("%s/card_data?uid=%s", settings.getServerAddress(), shortcutCard.getCirUid());
            FxUtil.openUrl((String)webAddress);
        } else {
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)cardPanel);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            RpcServiceManager rsm = RpcServiceManager.get();
            if (!rootEntityPane.isDataChanged()) {
                Notifications.get().submitTask(() -> {
                    try {
                        PCIDSSService service = (PCIDSSService)rsm.getService(PCIDSSService.class);
                        Card card = service.updateCard(sic, shortcutCard, settings, rootEntityPane.getData().getContainer().toReference());
                        OrganizationAndPersonCardsPanelControllerInterceptor.transferCirUidAndNameToView(cardPanel, card);
                        rootEntityPane.saveData();
                    }
                    catch (Exception e) {
                        OrganizationAndPersonCardsPanelControllerInterceptor.fillingCardNumberInWeb(settings, shortcutCard, rootEntityPane.getData().getContainer().toReference());
                    }
                }, Messages.Receiving_CIR_data);
            } else {
                Dialog dialog = new Dialog();
                dialog.setTitle(Messages.Confirmation_required).setMessage(Messages.Must_save_the_changes).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> Notifications.get().submitTask(() -> {
                    try {
                        rootEntityPane.saveData();
                        PCIDSSService service = (PCIDSSService)rsm.getService(PCIDSSService.class);
                        Card card = service.updateCard(sic, shortcutCard, settings, rootEntityPane.getData().getContainer().toReference());
                        CardPanel cardPanelNew = OrganizationAndPersonCardsPanelControllerInterceptor.getCardPanelAfterReloadRootPane(rootEntityPane, card);
                        OrganizationAndPersonCardsPanelControllerInterceptor.transferCirUidAndNameToView(cardPanelNew, card);
                        rootEntityPane.saveData();
                    }
                    catch (Exception e) {
                        OrganizationAndPersonCardsPanelControllerInterceptor.fillingCardNumberInWeb(settings, shortcutCard, rootEntityPane.getData().getContainer().toReference());
                    }
                }, Messages.Receiving_CIR_data)).show((Node)cardPanel);
            }
        }
    }

    private static void transferCirUidAndNameToView(CardPanel cardPanel, Card shortcutCard) throws Exception {
        FxUtil.waitForFxThread(() -> {
            cardPanel.getCirUidNode().setValue(shortcutCard.getCirUid());
            cardPanel.getNumberNode().setValue(shortcutCard.getNumber());
            cardPanel.getExpirationDateNode().readData((Object)new ValueHolder((Object)DateUtils.asLocalDate((Date)shortcutCard.getExpiration())));
            cardPanel.getOwnerNode().setValue(shortcutCard.getNameOnCard());
        });
    }

    private static void fillingCardNumberInWeb(PCIDSSServerExchangeSettings settings, Card shortcutCard, EntityReference<?> ref) throws Exception {
        if (TextUtil.isBlank((String)shortcutCard.getNameOnCard())) {
            Notifications.get().showFlashNotification(Messages.Error_cardholder_is_not_filled, Messages.Error_cardholder_is_not_filled);
            return;
        }
        if (shortcutCard.getExpiration() == null) {
            Notifications.get().showFlashNotification(Messages.Error_expiration_date_is_not_filled, Messages.Error_expiration_date_is_not_filled);
            return;
        }
        String webAddress = OrganizationAndPersonCardsPanelControllerInterceptor.fillCardNumberLink(settings, shortcutCard, ref);
        FxUtil.openUrl((String)webAddress);
    }

    private static String fillCardNumberLink(PCIDSSServerExchangeSettings settings, Card shortcutCard, EntityReference<?> ref) throws Exception {
        PCIDSSService service = (PCIDSSService)RpcServiceManager.get().getService(PCIDSSService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        return service.prepareNewCard(sic, shortcutCard, settings, ref);
    }

    private static CardPanel getCardPanelAfterReloadRootPane(RootEntityPane<?, ?> rootEntityPane, Card shortcutCard) {
        ObservableList listCardsPanel = ((ExpandedGroupsWidget)((CardsMainPanel)((OrganizationSpace)rootEntityPane.getEditor()).getCreditCardsTile().getFullNode()).getCardsCard().getContent()).getViews();
        for (CardPanel cardPanel : listCardsPanel) {
            if (!cardPanel.getUidNode().getValue().equals(shortcutCard.getUid())) continue;
            return cardPanel;
        }
        return null;
    }
}

