/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalanceDataVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalanceFilterContainer;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalancePanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.model.profile.TransactionActionsDialogContainer;
import com.gridnine.xtrip.client.fx.model.profile.TransactionActionsDialogPanel;
import com.gridnine.xtrip.client.fx.standard.balance.AddOperation;
import com.gridnine.xtrip.client.fx.standard.entity.actions.TransactionActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors.OrganizationControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.OperationType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Pane;

enum OrganizationBalanceTileActions implements TileAction<Node, OrganizationBalancePanel>
{
    ADD{

        public String getName(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Add_Transaction;
        }

        public String getDescription(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Add_New_Transaction;
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, OrganizationBalancePanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null) {
                isEnabled = !((OrganizationMainPanel)((OrganizationGeneralPanel)((OrganizationSpace)pane.getEditor()).getMainTile().getFullNode()).getMainCard().getContent()).getTypesNode().getViewState().isImmutable();
            }
            return isEnabled;
        }

        public void execute(Control source, Tile<Node, OrganizationBalancePanel> tile, boolean alt) {
            EntityReference organization = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer().toReference();
            ComboBoxWidget typeWidget = new ComboBoxWidget(false);
            typeWidget.setNoNulls(true);
            typeWidget.setItemsSupplier(() -> {
                ArrayList<OperationType> list = new ArrayList<OperationType>();
                list.add(OperationType.CUSTOM_TRANSACTION);
                list.add(OperationType.REFILL);
                return list;
            });
            typeWidget.valueProperty().set((Object)OperationType.CUSTOM_TRANSACTION);
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Choose_type_of_operation).setBody((Node)typeWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
                if (((OperationType)typeWidget.valueProperty().get()).equals((Object)OperationType.CUSTOM_TRANSACTION)) {
                    this.createTransaction(source, tile);
                } else {
                    AddOperation.createRefillOperation((EntityReference<Organization>)organization, source, () -> this.refresh(tile));
                }
            }).show((Node)source);
        }

        private void refresh(Tile<Node, OrganizationBalancePanel> tile) {
            Pane additionalPanes = ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getAdditionalPanesContainer();
            for (Node node : additionalPanes.getChildren()) {
                if (!node.getClass().isAssignableFrom(FilteringPane.class)) continue;
                node.getProperties().put((Object)"SLAVE", (Object)false);
                ((FilteringPane)node).apply();
                break;
            }
        }

        public void createTransaction(Control source, final Tile<Node, OrganizationBalancePanel> tile) {
            TransactionActionsDialogContainer dialogContainer = this.createDialogPanel(tile);
            TransactionActionsDialogPanel panel = (TransactionActionsDialogPanel)dialogContainer.getMainCard().getContent();
            EntityContainer container = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            if (container != null) {
                panel.getClientNode().valueProperty().set((Object)container.toReference());
            }
            panel.getDateNode().valueProperty().set((Object)LocalDateTime.now());
            panel.getPaymentTypeNode().setValue((Object)PaymentType.INVOICE);
            panel.getStatusNode().setValue((Object)BillingTransactionStatus.ACTIVE);
            FilterableDataViewHandler handler = (FilterableDataViewHandler)((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getHandler();
            panel.getAgencyNode().setValue(handler != null ? ((OrganizationBalanceFilterContainer)handler.getFilteringPane().getContent()).getAgencyNode().getValue() : null);
            if (container != null) {
                Notifications.get().submitTask(() -> {
                    EntityContainer agencyCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ((OrganizationBalanceFilterContainer)handler.getFilteringPane().getContent()).getAgencyNode().getValue());
                    if (ProfileHelper.isOrganizationType((Organization)((Organization)container.getEntity()), (OrganizationType)OrganizationType.CORPORATE_CLIENT)) {
                        FxUtil.waitForFxThread(() -> panel.getContractNode().setValue((Object)ContractType.CLIENT));
                    } else if (agencyCtr != null && ProfileHelper.isOrganizationType((Organization)((Organization)agencyCtr.getEntity()), (OrganizationType)OrganizationType.AGENCY)) {
                        FxUtil.waitForFxThread(() -> panel.getContractNode().setValue((Object)ContractType.SUBAGENCY));
                    } else {
                        FxUtil.waitForFxThread(() -> panel.getContractNode().setValue((Object)ContractType.VENDOR));
                    }
                }, "");
            }
            TransactionActions.TransactionsCallback callback = new TransactionActions.TransactionsCallback(){

                public void execute() throws Exception {
                    Pane additionalPanes = ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getAdditionalPanesContainer();
                    for (Node node : additionalPanes.getChildren()) {
                        if (!node.getClass().isAssignableFrom(FilteringPane.class)) continue;
                        node.getProperties().put((Object)"SLAVE", (Object)false);
                        ((FilteringPane)node).apply();
                        break;
                    }
                }
            };
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Adding_New_Transaction).setBody((Node)dialogContainer).setAutoClose(false).setExpandToParent().setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
                dialogContainer.getChildren().removeAll((Collection)dialogContainer.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                List listMessage = OrganizationBalanceTileActions.validateData(panel);
                if (!listMessage.isEmpty()) {
                    listMessage.forEach(message -> dialogContainer.getChildren().add(0, (Object)MessagePane.error((String)message)));
                    return;
                }
                dialog.close();
                TransactionActions.createTransaction(panel, callback);
            }).show((Node)source);
        }
    }
    ,
    EDIT{

        public String getName(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Edit_Transaction;
        }

        public String getDescription(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Edit_Selected_Transaction;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, OrganizationBalancePanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null) {
                isEnabled = !((OrganizationMainPanel)((OrganizationGeneralPanel)((OrganizationSpace)pane.getEditor()).getMainTile().getFullNode()).getMainCard().getContent()).getTypesNode().getViewState().isImmutable();
            }
            return isEnabled && ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedCells().size() > 0;
        }

        public void execute(Control source, final Tile<Node, OrganizationBalancePanel> tile, boolean alt) {
            TransactionActionsDialogContainer dialogContainer = this.createDialogPanel(tile);
            TransactionActionsDialogPanel panel = (TransactionActionsDialogPanel)dialogContainer.getMainCard().getContent();
            OrganizationBalanceDataVM transactionVM = (OrganizationBalanceDataVM)((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedItems().get(0);
            if (transactionVM.getSourceBillingTransaction() == null || transactionVM.getSourceBillingTransaction().getUid() == null) {
                Notifications.get().showStaticNotification(Messages.Failure_To_Action_Because_Source_An_BillingTransaction_Is_Null, null);
                return;
            }
            Notifications.get().submitTask(() -> {
                EntityContainer transactionContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), transactionVM.getSourceBillingTransaction());
                if (transactionContainer == null) {
                    FxUtil.waitForFxThread(() -> Notifications.get().showStaticNotification(Messages.Failure_load_transaction + transactionVM.getSourceBillingTransaction(), null));
                } else {
                    BillingTransaction transaction = (BillingTransaction)transactionContainer.getEntity();
                    FxUtil.waitForFxThread(() -> {
                        OrganizationBalanceTileActions.filingPanelFromContainer(panel, transaction);
                        final RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)source);
                        TransactionActions.TransactionsCallback callback = new TransactionActions.TransactionsCallback(){

                            public void execute() throws Exception {
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)rootEntityPane, new EntityModification(this.container.toReference(), EntityModification.ModificationType.CHANGE)));
                                Pane additionalPanes = ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getAdditionalPanesContainer();
                                for (Node node : additionalPanes.getChildren()) {
                                    if (!node.getClass().isAssignableFrom(FilteringPane.class)) continue;
                                    node.getProperties().put((Object)"SLAVE", (Object)false);
                                    ((FilteringPane)node).apply();
                                    break;
                                }
                            }
                        };
                        Dialog dialog = new Dialog();
                        dialog.setTitle(Messages.Editing_Transaction).setBody((Node)dialogContainer).setAutoClose(false).setExpandToParent().setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> {
                            dialogContainer.getChildren().removeAll((Collection)dialogContainer.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                            List listMessage = OrganizationBalanceTileActions.validateData(panel);
                            if (!listMessage.isEmpty()) {
                                listMessage.forEach(message -> dialogContainer.getChildren().add(0, (Object)MessagePane.error((String)message)));
                                return;
                            }
                            dialog.close();
                            TransactionActions.editTransaction(panel, (EntityReference<BillingTransaction>)transactionVM.getSourceBillingTransaction(), callback);
                        }).show((Node)source);
                    });
                }
            }, Messages.Notifications_getting_data);
        }
    }
    ,
    COPY{

        public String getName(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Copy_Transaction;
        }

        public String getDescription(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Copy_Selected_Transaction;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, OrganizationBalancePanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null) {
                isEnabled = !((OrganizationMainPanel)((OrganizationGeneralPanel)((OrganizationSpace)pane.getEditor()).getMainTile().getFullNode()).getMainCard().getContent()).getTypesNode().getViewState().isImmutable();
            }
            return isEnabled && ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedCells().size() > 0;
        }

        public void execute(Control source, Tile<Node, OrganizationBalancePanel> tile, boolean alt) {
            TransactionActionsDialogContainer dialogContainer = this.createDialogPanel(tile);
            TransactionActionsDialogPanel panel = (TransactionActionsDialogPanel)dialogContainer.getMainCard().getContent();
            OrganizationBalanceDataVM transactionVM = (OrganizationBalanceDataVM)((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedItems().get(0);
            if (transactionVM.getSourceBillingTransaction() == null) {
                Notifications.get().showStaticNotification(Messages.Failure_To_Action_Because_Source_An_BillingTransaction_Is_Null, null);
                return;
            }
            Notifications.get().submitTask(() -> {
                EntityContainer transactionContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), transactionVM.getSourceBillingTransaction());
                if (transactionContainer == null) {
                    FxUtil.waitForFxThread(() -> Notifications.get().showStaticNotification(Messages.Failure_load_transaction + transactionVM.getSourceBillingTransaction(), null));
                } else {
                    BillingTransaction transaction = (BillingTransaction)transactionContainer.getEntity();
                    FxUtil.waitForFxThread(() -> {
                        OrganizationBalanceTileActions.filingPanelFromContainer(panel, transaction);
                        Dialog dialog = new Dialog();
                        dialog.setBody((Node)dialogContainer).setTitle(Messages.Copying_Transaction).setAutoClose(false).setExpandToParent().setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Copy, () -> {
                            dialogContainer.getChildren().removeAll((Collection)dialogContainer.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                            List listMessage = OrganizationBalanceTileActions.validateData(panel);
                            if (!listMessage.isEmpty()) {
                                listMessage.forEach(message -> dialogContainer.getChildren().add(0, (Object)MessagePane.error((String)message)));
                                return;
                            }
                            dialog.close();
                            OrganizationBalanceTileActions.copyTransaction(panel, (EntityReference<BillingTransaction>)transactionVM.getSourceBillingTransaction(), (Tile<Node, OrganizationBalancePanel>)tile);
                        }).show((Node)source);
                    });
                }
            }, Messages.Notifications_getting_data);
        }
    }
    ,
    DELETE{

        public String getName(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Delete_Trasaction;
        }

        public String getDescription(Tile<Node, OrganizationBalancePanel> tile) {
            return Messages.Delete_Selected_Transaction;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, OrganizationBalancePanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null) {
                isEnabled = !((OrganizationMainPanel)((OrganizationGeneralPanel)((OrganizationSpace)pane.getEditor()).getMainTile().getFullNode()).getMainCard().getContent()).getTypesNode().getViewState().isImmutable();
            }
            return isEnabled && ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedCells().size() > 0;
        }

        public void execute(Control source, Tile<Node, OrganizationBalancePanel> tile, boolean alt) {
            ObservableList transactions = ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedItems();
            Dialog.confirm((Node)source, (String)Messages.Do_you_want_to_delete_selected_transaction, null, (String)Messages.Delete, () -> this.lambda$execute$1((List)transactions, tile), null);
        }

        private /* synthetic */ void lambda$execute$1(List transactions, final Tile tile) {
            Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask(transactions.stream().map(idx -> idx.getSourceBillingTransaction() != null ? idx.getSourceBillingTransaction() : idx.getSourceTransaction()).collect(Collectors.toList())){

                @Override
                protected void execute() throws Exception {
                    super.execute();
                    FxUtil.waitForFxThread(() -> {
                        Pane additionalPanes = ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getAdditionalPanesContainer();
                        for (Node node : additionalPanes.getChildren()) {
                            if (!node.getClass().isAssignableFrom(FilteringPane.class)) continue;
                            node.getProperties().put((Object)"SLAVE", (Object)false);
                            ((FilteringPane)node).apply();
                            break;
                        }
                    });
                }
            });
        }
    };


    private static void filingPanelFromContainer(TransactionActionsDialogPanel panel, BillingTransaction transaction) {
        panel.getClientNode().valueProperty().set((Object)transaction.getClient());
        panel.getAmountNode().valueProperty().set((Object)transaction.getSum());
        panel.getAgencyNode().valueProperty().set((Object)transaction.getAgency());
        panel.getPaymentTypeNode().valueProperty().set((Object)transaction.getPaymentType());
        panel.getContractNode().valueProperty().set((Object)transaction.getContractType());
        panel.getDateNode().valueProperty().set((Object)DateUtils.asLocalDateTime((Date)transaction.getDate()));
        panel.getCategoryNode().valueProperty().set((Object)transaction.getCategory());
        panel.getAgentNode().valueProperty().set((Object)transaction.getAgent());
        panel.getTypeNode().valueProperty().set((Object)transaction.getType());
        panel.getOrderNode().valueProperty().set((Object)transaction.getEntity());
        panel.getStatusNode().valueProperty().set((Object)transaction.getStatus());
        panel.getDescriptionNode().setValue(transaction.getDescription());
    }

    protected TransactionActionsDialogContainer createDialogPanel(Tile<Node, OrganizationBalancePanel> tile) {
        TransactionActionsDialogContainer panel = new TransactionActionsDialogContainer(false);
        ((TransactionActionsDialogPanel)panel.getMainCard().getContent()).getAgencyNode().setListParametersSupplier(() -> OrganizationControllerInterceptor.getDependentAgencies((OrganizationSpace)RootEntityPane.lookup((Node)tile.getFullNode()).getEditor()));
        ((TransactionActionsDialogPanel)panel.getMainCard().getContent()).getOrderNode().setListParametersSupplier(ControllerInterceptorsHelper::getOrders);
        ((TransactionActionsDialogPanel)panel.getMainCard().getContent()).getPaymentTypeNode().setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
        return panel;
    }

    private static List<String> validateData(TransactionActionsDialogPanel panel) {
        ArrayList<String> result = new ArrayList<String>();
        if (panel.getClientNode().getValue() == null) {
            result.add(Messages.Customer_must_be_specified);
        }
        if (panel.getContractNode().getValue() == null) {
            result.add(Messages.Must_select_the_contract_type);
        }
        if (panel.getCategoryNode().getValue() == null) {
            result.add(Messages.Must_select_category);
        }
        if (panel.getTypeNode().getValue() == null) {
            result.add(Messages.Must_select_type_of_transaction);
        }
        if (panel.getStatusNode().getValue() == null) {
            result.add(Messages.Must_select_status_of_transaction);
        }
        if (panel.getDateNode().getValue() == null) {
            result.add(Messages.Date_is_required);
        }
        if (panel.getAmountNode().valueProperty().get() == null) {
            result.add(Messages.Sum_is_required);
        }
        if (panel.getPaymentTypeNode().getValue() == null) {
            result.add(Messages.Must_select_a_form_of_payment);
        }
        return result;
    }

    private static void copyTransaction(TransactionActionsDialogPanel panel, final EntityReference<BillingTransaction> source, final Tile<Node, OrganizationBalancePanel> tile) {
        final EntityReference client = (EntityReference)panel.getClientNode().valueProperty().get();
        final Money amount = (Money)panel.getAmountNode().valueProperty().get();
        final EntityReference agency = (EntityReference)panel.getAgencyNode().valueProperty().get();
        final PaymentType paymentType = (PaymentType)panel.getPaymentTypeNode().valueProperty().get();
        final ContractType contractType = (ContractType)panel.getContractNode().valueProperty().get();
        final Date date = DateUtils.asDate((LocalDateTime)((LocalDateTime)panel.getDateNode().valueProperty().get()));
        final BillingTransactionCategory transactionCategory = (BillingTransactionCategory)panel.getCategoryNode().valueProperty().get();
        final EntityReference agent = (EntityReference)panel.getAgentNode().valueProperty().get();
        final BillingTransactionType transactionType = (BillingTransactionType)panel.getTypeNode().valueProperty().get();
        final EntityReference order = (EntityReference)panel.getOrderNode().valueProperty().get();
        final BillingTransactionStatus transactionStatus = (BillingTransactionStatus)panel.getStatusNode().valueProperty().get();
        final String description = panel.getDescriptionNode().getValue();
        Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Action_Copying;
            }

            protected void execute() throws Exception {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                this.setProgress((byte)15, "");
                EntityContainer transactionContainer = new EntityContainer(BillingTransaction.class);
                transactionContainer.getVersionInfo().setDataSource("fx-copy-transaction");
                EntityContainer oldTransactionContainer = entityService.load(sic, source);
                this.setProgress((byte)25, "");
                ((BillingTransaction)transactionContainer.getEntity()).setClient(client);
                ((BillingTransaction)transactionContainer.getEntity()).setSum(amount);
                ((BillingTransaction)transactionContainer.getEntity()).setAgency(agency);
                ((BillingTransaction)transactionContainer.getEntity()).setPaymentType(paymentType);
                ((BillingTransaction)transactionContainer.getEntity()).setContractType(contractType);
                ((BillingTransaction)transactionContainer.getEntity()).setDate(date);
                ((BillingTransaction)transactionContainer.getEntity()).setCategory(transactionCategory);
                ((BillingTransaction)transactionContainer.getEntity()).setAgent(agent);
                ((BillingTransaction)transactionContainer.getEntity()).setType(transactionType);
                ((BillingTransaction)transactionContainer.getEntity()).setEntity(order);
                ((BillingTransaction)transactionContainer.getEntity()).setStatus(transactionStatus);
                ((BillingTransaction)transactionContainer.getEntity()).setDescription(description);
                ((BillingTransaction)transactionContainer.getEntity()).setFinDocNumber(((BillingTransaction)oldTransactionContainer.getEntity()).getFinDocNumber());
                ((BillingTransaction)transactionContainer.getEntity()).setFinDocDate(((BillingTransaction)oldTransactionContainer.getEntity()).getFinDocDate());
                ((BillingTransaction)transactionContainer.getEntity()).setFopUid(((BillingTransaction)oldTransactionContainer.getEntity()).getFopUid());
                ((BillingTransaction)transactionContainer.getEntity()).setParent(((BillingTransaction)oldTransactionContainer.getEntity()).getParent());
                ((BillingTransaction)transactionContainer.getEntity()).setProductType(((BillingTransaction)oldTransactionContainer.getEntity()).getProductType());
                ((BillingTransaction)transactionContainer.getEntity()).setDetails(((BillingTransaction)oldTransactionContainer.getEntity()).getDetails());
                ((BillingTransaction)transactionContainer.getEntity()).setAutoCreated(false);
                this.setProgress((byte)85, "");
                entityService.save(sic, transactionContainer, null, true);
                this.setProgress((byte)90, "");
                FxUtil.waitForFxThread(() -> {
                    Pane additionalPanes = ((DataViewWidget)((OrganizationBalancePanel)tile.getFullNode()).getTransactionsCard().getContent()).getAdditionalPanesContainer();
                    for (Node node : additionalPanes.getChildren()) {
                        if (!node.getClass().isAssignableFrom(FilteringPane.class)) continue;
                        node.getProperties().put((Object)"SLAVE", (Object)false);
                        ((FilteringPane)node).apply();
                        break;
                    }
                });
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Transaction_Created, (Object[])new Object[0])});
                this.setProgress((byte)100, "");
            }
        });
    }
}

