/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationAddressesFilterPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContactsPanelController;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContactsPanelGeneral;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContactsPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ContactsPaneHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.RiskManagementCompany;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.WorkModeType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class OrganizationContactsControllerInterceptor
extends ControllerInterceptor<OrganizationContactsPanelVM, OrganizationContactsPanelController> {
    private static final List<SabreProfileLineType> LINE_TYPES = Arrays.asList(SabreProfileLineType.A, SabreProfileLineType.O);
    private static final List<WorkModeType> MODE_TYPE_LIST = Arrays.asList(WorkModeType.WEEKDAYS, WorkModeType.HOLIDAYS, WorkModeType.EVERYDAY, WorkModeType.MON, WorkModeType.TUE, WorkModeType.WED, WorkModeType.THU, WorkModeType.FRI, WorkModeType.SAT, WorkModeType.SUN, WorkModeType.MONTHU);

    protected Class<OrganizationContactsPanelController> getControllerClass() {
        return OrganizationContactsPanelController.class;
    }

    protected void onCreate(OrganizationContactsPanelController controller) {
        ((OrganizationContactsPanelGeneral)controller.getView().getGeneralInfoCard().getContent()).getRiskManagementCompaniesNode().setItemsSupplier(Suppliers.createEnumSupplier(RiskManagementCompany.class));
        ContactsPaneHelper.configurePhonesTable((TableWidget<? extends ContactPhonesTableVM>)((TableWidget)controller.getView().getPhonesCard().getContent()), null);
        ComboBoxWidgetColumn lineTypeColumn = (ComboBoxWidgetColumn)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("lineType");
        lineTypeColumn.setItemsSupplier(() -> LINE_TYPES);
        EntityBoxWidgetColumn personColumn = (EntityBoxWidgetColumn)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("person");
        personColumn.setListParametersSupplier(() -> OrganizationContactsControllerInterceptor.getKeyContactsPersonListParameters(controller));
        EntityBoxWidgetColumn personColumnAccountManagers = (EntityBoxWidgetColumn)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("person");
        personColumnAccountManagers.setListParametersSupplier(() -> OrganizationContactsControllerInterceptor.getAccountManagersPersonListParameters(controller));
        ComboBoxWidgetColumn modeColumn = (ComboBoxWidgetColumn)((TableWidget)controller.getView().getModeCard().getContent()).getColumn("workModeType");
        modeColumn.setSortItems(false);
        modeColumn.setItemsSupplier(() -> MODE_TYPE_LIST);
        OrganizationAddressesFilterPanel panel = new OrganizationAddressesFilterPanel(false);
        panel.getActualNode().setSelected(true);
        TableWidget addressTableWidget = (TableWidget)controller.getView().getAddressesCard().getContent();
        addressTableWidget.setFiltering(() -> panel, filterPanel -> vm -> {
            AddressType addressType = (AddressType)filterPanel.getTypeNode().getValue();
            if (addressType != null && addressType != vm.getType()) {
                return false;
            }
            if (filterPanel.getActualNode().isSelected()) {
                LocalDate now = LocalDate.now();
                LocalDate startDate = vm.getStartDate();
                if (startDate != null && now.isBefore(startDate)) {
                    return false;
                }
                LocalDate endDate = vm.getEndDate();
                return endDate == null || !now.isAfter(endDate);
            }
            return true;
        }, true);
    }

    protected void afterReadData(OrganizationContactsPanelController controller, OrganizationContactsPanelVM model) {
        EntityBoxWidget personWidget;
        InfoLabelWidget numberWidget;
        Integer index;
        int i;
        for (i = 0; i < ((TableWidget)controller.getView().getKeyContactsCard().getContent()).getRowsCount(); ++i) {
            index = i;
            numberWidget = (InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("number").getWidget(index.intValue());
            numberWidget.setText(Integer.toString(i + 1));
            personWidget = (EntityBoxWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("person").getWidget(index.intValue());
            OrganizationContactsControllerInterceptor.setKeyContactsPersonDataFields(controller, (EntityReference<Person>)((EntityReference)personWidget.valueProperty().get()), index);
        }
        for (i = 0; i < ((TableWidget)controller.getView().getAccountManagersCard().getContent()).getRowsCount(); ++i) {
            index = i;
            numberWidget = (InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("number").getWidget(index.intValue());
            numberWidget.setText(Integer.toString(i + 1));
            personWidget = (EntityBoxWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("person").getWidget(index.intValue());
            OrganizationContactsControllerInterceptor.setAccountManagersPersonDataFields(controller, (EntityReference<Person>)((EntityReference)personWidget.valueProperty().get()), index);
        }
        ((TableWidget)controller.getView().getKeyContactsCard().getContent()).setOnRowsAction(action -> {
            if (action.getEventType().equals(TableRowEvent.ROW_ADD)) {
                Integer index = action.getRowIndex();
                InfoLabelWidget numberWidget = (InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("number").getWidget(index.intValue());
                numberWidget.setText("-");
                EntityBoxWidget personWidget = (EntityBoxWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("person").getWidget(index.intValue());
                personWidget.valueProperty().addListener((obj, oldValue, newValue) -> OrganizationContactsControllerInterceptor.setKeyContactsPersonDataFields(controller, (EntityReference<Person>)newValue, index));
            }
        });
        ((TableWidget)controller.getView().getAccountManagersCard().getContent()).setOnRowsAction(action -> {
            if (action.getEventType().equals(TableRowEvent.ROW_ADD)) {
                Integer index = action.getRowIndex();
                InfoLabelWidget numberWidget = (InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("number").getWidget(index.intValue());
                numberWidget.setText("-");
                EntityBoxWidget personWidget = (EntityBoxWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("person").getWidget(index.intValue());
                personWidget.valueProperty().addListener((obj, oldValue, newValue) -> OrganizationContactsControllerInterceptor.setAccountManagersPersonDataFields(controller, (EntityReference<Person>)newValue, index));
            }
        });
    }

    private static String getPhoneNumber(PersonCommunication communication) {
        StringBuilder builder = new StringBuilder();
        if (communication.getCountryCode() != null && !communication.getCountryCode().trim().equals("")) {
            String countryCode = communication.getCountryCode().replace("-", "");
            builder.append(countryCode.trim()).append('-');
        }
        if (communication.getCityCode() != null && !communication.getCityCode().trim().equals("")) {
            String cityCode = communication.getCityCode().replace("-", "");
            builder.append(cityCode.trim()).append('-');
        }
        if (communication.getSense() != null && !communication.getSense().trim().equals("")) {
            String number = communication.getSense().replace("-", "");
            builder.append(number.trim()).append('-');
        }
        if (communication.getInternalNumber() != null && !communication.getInternalNumber().trim().equals("")) {
            String internal = communication.getInternalNumber().replace("-", "");
            builder.append(internal.trim()).append('-');
        }
        if (builder.length() > 1) {
            return builder.deleteCharAt(builder.length() - 1).toString();
        }
        return null;
    }

    private static void setKeyContactsPersonDataFields(OrganizationContactsPanelController controller, EntityReference<Person> reference, Integer index) {
        if (reference != null) {
            Notifications.get().submitTask(() -> {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer person = entityService.load(sic, reference);
                if (person != null) {
                    if (((Person)person.getEntity()).getEmployments() != null && ((Person)person.getEntity()).getEmployments().size() > 0) {
                        FxUtil.waitForFxThread(() -> ((DictBoxWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("position").getWidget(index.intValue())).valueProperty().set((Object)((PersonEmployment)((Person)person.getEntity()).getEmployments().get(0)).getPosition()));
                    }
                    boolean fieldNumberFilled = false;
                    boolean fieldEmailFilled = false;
                    for (PersonCommunication communication : ((Person)person.getEntity()).getCommunications()) {
                        CommunicationType type = communication.getType();
                        if (type == null || type == CommunicationType.EMAIL || type == CommunicationType.WEB || type == CommunicationType.EMERGENCY) continue;
                        fieldNumberFilled = true;
                        String phone = OrganizationContactsControllerInterceptor.getPhoneNumber(communication);
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("phoneNumber").getWidget(index.intValue())).setText(phone));
                        break;
                    }
                    for (PersonCommunication communication : ((Person)person.getEntity()).getCommunications()) {
                        if (communication.getType() != CommunicationType.EMAIL) continue;
                        fieldEmailFilled = true;
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("email").getWidget(index.intValue())).setText(communication.getSense()));
                        break;
                    }
                    if (!fieldNumberFilled) {
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("phoneNumber").getWidget(index.intValue())).setText(null));
                    }
                    if (!fieldEmailFilled) {
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("email").getWidget(index.intValue())).setText(null));
                    }
                }
            }, ObservableMutex.lookup((Node)controller.getView()));
        } else {
            ((InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("phoneNumber").getWidget(index.intValue())).setText(null);
            ((InfoLabelWidget)((TableWidget)controller.getView().getKeyContactsCard().getContent()).getColumn("email").getWidget(index.intValue())).setText(null);
        }
    }

    private static void setAccountManagersPersonDataFields(OrganizationContactsPanelController controller, EntityReference<Person> reference, Integer index) {
        if (reference != null) {
            Notifications.get().submitTask(() -> {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer person = entityService.load(sic, reference);
                if (person != null) {
                    if (((Person)person.getEntity()).getEmployments() != null && ((Person)person.getEntity()).getEmployments().size() > 0) {
                        FxUtil.waitForFxThread(() -> ((DictBoxWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("position").getWidget(index.intValue())).valueProperty().set((Object)((PersonEmployment)((Person)person.getEntity()).getEmployments().get(0)).getPosition()));
                    }
                    boolean fieldNumberFilled = false;
                    boolean fieldEmailFilled = false;
                    for (PersonCommunication communication : ((Person)person.getEntity()).getCommunications()) {
                        if (communication.getType() == null) continue;
                        if (!(communication.getType().equals((Object)CommunicationType.EMAIL) || communication.getType().equals((Object)CommunicationType.WEB) || communication.getType().equals((Object)CommunicationType.EMERGENCY))) {
                            fieldNumberFilled = true;
                            String phone = OrganizationContactsControllerInterceptor.getPhoneNumber(communication);
                            FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("phoneNumber").getWidget(index.intValue())).setText(phone));
                            if (fieldEmailFilled) break;
                        }
                        if (!communication.getType().equals((Object)CommunicationType.EMAIL)) continue;
                        fieldEmailFilled = true;
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("email").getWidget(index.intValue())).setText(communication.getSense()));
                        if (!fieldNumberFilled) continue;
                        break;
                    }
                    if (!fieldNumberFilled) {
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("phoneNumber").getWidget(index.intValue())).setText(null));
                    }
                    if (!fieldEmailFilled) {
                        FxUtil.waitForFxThread(() -> ((InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("email").getWidget(index.intValue())).setText(null));
                    }
                }
            }, ObservableMutex.lookup((Node)controller.getView()));
        } else {
            ((InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("phoneNumber").getWidget(index.intValue())).setText(null);
            ((InfoLabelWidget)((TableWidget)controller.getView().getAccountManagersCard().getContent()).getColumn("email").getWidget(index.intValue())).setText(null);
        }
    }

    private static IndexListParameters<Person, PersonIndex> getKeyContactsPersonListParameters(OrganizationContactsPanelController controller) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSortings().put(PersonIndex.Property.code.name(), SortOrder.ASC);
        EntityContainer ctr = RootEntityPane.lookup((Node)controller.getView()).getData().getContainer();
        if (ctr != null) {
            result.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)ctr.getUid()));
        }
        TableColumnSettings filter = new TableColumnSettings();
        filter.setId(PersonIndex.Property.name.name());
        result.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(PersonIndex.Property.code.name());
        result.getFilters().add(filter);
        TableColumnSettings column3 = new TableColumnSettings();
        column3.setId(PersonIndex.Property.name.name());
        result.getColumns().add(column3);
        TableColumnSettings column4 = new TableColumnSettings();
        column4.setId(PersonIndex.Property.code.name());
        result.getColumns().add(column4);
        return result;
    }

    private static IndexListParameters<Person, PersonIndex> getAccountManagersPersonListParameters(OrganizationContactsPanelController controller) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSortings().put(PersonIndex.Property.code.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT), SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.MANAGER)}));
        TableColumnSettings filter = new TableColumnSettings();
        filter.setId(PersonIndex.Property.name.name());
        result.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(PersonIndex.Property.code.name());
        result.getFilters().add(filter);
        TableColumnSettings column3 = new TableColumnSettings();
        column3.setId(PersonIndex.Property.name.name());
        result.getColumns().add(column3);
        TableColumnSettings column4 = new TableColumnSettings();
        column4.setId(PersonIndex.Property.code.name());
        result.getColumns().add(column4);
        return result;
    }
}

