/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.PopupWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBankAccountVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationDocumentsPanelController;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationDocumentsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationDocumentsPaymentCard;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationDocumentsShipmentCard;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentSetting;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentsCard;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationFinanceDocumentsGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPaymentDocumentSetting;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPaymentDocumentsGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSignatureVM;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberSerial;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class OrganizationDocumentsPanelControllerInterceptor
extends ControllerInterceptor<OrganizationDocumentsPanelVM, OrganizationDocumentsPanelController> {
    protected Class<OrganizationDocumentsPanelController> getControllerClass() {
        return OrganizationDocumentsPanelController.class;
    }

    protected void onCreate(OrganizationDocumentsPanelController controller) {
        ((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getBankAccountNode().setLive(true);
        ((OrganizationDocumentsShipmentCard)controller.getView().getShipmentCard().getContent()).getNumberSerialNode().setItemsSupplier(() -> Arrays.asList(ConsecutiveNumberSerial.AGENCY, ConsecutiveNumberSerial.CONTRACT));
        ((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getNumberSerialNode().setItemsSupplier(() -> Arrays.asList(ConsecutiveNumberSerial.AGENCY, ConsecutiveNumberSerial.CONTRACT));
        ((OrganizationDocumentsPaymentCard)controller.getView().getPaymentDocumentsCard().getContent()).getNumberSerialNode().setItemsSupplier(() -> Arrays.asList(ConsecutiveNumberSerial.AGENCY, ConsecutiveNumberSerial.CASH));
        ((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getBankAccountNode().setItemsSupplier(() -> {
            EntityContainer ctr = RootEntityPane.lookup((Node)controller.getView()).getData().getContainer();
            ArrayList bankAccountList = new ArrayList();
            if (ctr != null && ctr.getEntity().getClass().isAssignableFrom(Organization.class)) {
                bankAccountList.addAll(((Organization)ctr.getEntity()).getBankAccounts());
            } else if (ctr != null && ctr.getEntity().getClass().isAssignableFrom(Branch.class)) {
                bankAccountList.addAll(((Branch)ctr.getEntity()).getBankAccounts());
            }
            ArrayList<OrganizationBankAccountVM> result = new ArrayList<OrganizationBankAccountVM>();
            for (BankAccount bankAccount : bankAccountList) {
                if (TextUtil.isBlank((String)bankAccount.getBankName()) || TextUtil.isBlank((String)bankAccount.getSettlementAccount())) continue;
                OrganizationBankAccountVM vm = new OrganizationBankAccountVM();
                vm.setBankAccount(bankAccount);
                result.add(vm);
            }
            return result;
        });
        ((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getBankAccountNode().setConverter((StringConverter)new StringConverter<OrganizationBankAccountVM>(){

            public String toString(OrganizationBankAccountVM object) {
                if (object != null && object.getBankAccount() != null) {
                    if (object.getBankAccount().getBankName() != null && object.getBankAccount().getBankName().length() > 0 && object.getBankAccount().getSettlementAccount() != null && object.getBankAccount().getSettlementAccount().length() > 0) {
                        return object.getBankAccount().getBankName() + " - " + object.getBankAccount().getSettlementAccount();
                    }
                    if (object.getBankAccount().getBankName() != null && object.getBankAccount().getBankName().length() > 0) {
                        return object.getBankAccount().getBankName();
                    }
                    if (object.getBankAccount().getSettlementAccount() != null && object.getBankAccount().getSettlementAccount().length() > 0) {
                        return object.getBankAccount().getSettlementAccount();
                    }
                }
                return UiUtil.NULL_TEXT;
            }

            public OrganizationBankAccountVM fromString(String string) {
                return null;
            }
        });
        ((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getTableNode().setControlButtonsAvailability(ControlsPane.NONE);
        ((OrganizationDocumentsPaymentCard)controller.getView().getPaymentDocumentsCard().getContent()).getTableNode().setControlButtonsAvailability(ControlsPane.NONE);
    }

    protected void afterReadData(OrganizationDocumentsPanelController controller, OrganizationDocumentsPanelVM model) {
        int i;
        for (i = 0; i < ((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getTableNode().getRowsCount(); ++i) {
            OrganizationDocumentsPanelControllerInterceptor.setTemplateIndexListParameters((FinanceDocumentType)((ComboBoxWidget)((ComboBoxWidgetColumn)((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getTableNode().getColumn("type")).getWidget(i)).valueProperty().get(), (EntityBoxWidget<TemplateDocument>)((OrganizationFinanceDocumentsGeneralPanel)((OrganizationFinanceDocumentSetting)((PopupWidget)((PopupWidgetColumn)((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getTableNode().getColumn("settings")).getWidget(i)).getView()).getGeneralCard().getContent()).getTemplateNode());
            ((ExpandedGroupsWidget)((OrganizationFinanceDocumentSetting)((PopupWidget)((PopupWidgetColumn)((OrganizationFinanceDocumentsCard)controller.getView().getFinanceDocumentsCard().getContent()).getTableNode().getColumn("settings")).getWidget(i)).getView()).getSignaturesCard().getContent()).getViews().forEach(view -> view.getSignerNode().setListParametersSupplier(OrganizationDocumentsPanelControllerInterceptor::getSigners));
        }
        for (i = 0; i < ((OrganizationDocumentsPaymentCard)controller.getView().getPaymentDocumentsCard().getContent()).getTableNode().getRowsCount(); ++i) {
            OrganizationDocumentsPanelControllerInterceptor.setTemplateIndexListParameters((PaymentDocumentType)((ComboBoxWidget)((ComboBoxWidgetColumn)((OrganizationDocumentsPaymentCard)controller.getView().getPaymentDocumentsCard().getContent()).getTableNode().getColumn("type")).getWidget(i)).valueProperty().get(), (EntityBoxWidget<TemplateDocument>)((OrganizationPaymentDocumentsGeneralPanel)((OrganizationPaymentDocumentSetting)((PopupWidget)((PopupWidgetColumn)((OrganizationDocumentsPaymentCard)controller.getView().getPaymentDocumentsCard().getContent()).getTableNode().getColumn("settings")).getWidget(i)).getView()).getGeneralCard().getContent()).getTemplateNode());
            ((ExpandedGroupsWidget)((OrganizationPaymentDocumentSetting)((PopupWidget)((PopupWidgetColumn)((OrganizationDocumentsPaymentCard)controller.getView().getPaymentDocumentsCard().getContent()).getTableNode().getColumn("settings")).getWidget(i)).getView()).getSignaturesCard().getContent()).getViews().forEach(view -> view.getSignerNode().setListParametersSupplier(OrganizationDocumentsPanelControllerInterceptor::getSigners));
        }
    }

    private static void setTemplateIndexListParameters(PaymentDocumentType documentType, EntityBoxWidget<TemplateDocument> templateNode) {
        templateNode.setListParametersSupplier(() -> {
            IndexListParameters parameters = new IndexListParameters();
            parameters.setIndexType(TemplateDocumentIndex.class);
            parameters.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
            parameters.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.paymentDocumentType.name(), (Object)documentType));
            TableColumnSettings column1 = new TableColumnSettings();
            column1.setId(TemplateDocumentIndex.Property.title.name());
            parameters.getColumns().add(column1);
            TableColumnSettings column2 = new TableColumnSettings();
            column2.setId(TemplateDocumentIndex.Property.type.name());
            parameters.getColumns().add(column2);
            return parameters;
        });
    }

    private static void setTemplateIndexListParameters(FinanceDocumentType documentType, EntityBoxWidget<TemplateDocument> templateNode) {
        templateNode.setListParametersSupplier(() -> {
            IndexListParameters parameters = new IndexListParameters();
            parameters.setIndexType(TemplateDocumentIndex.class);
            parameters.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
            parameters.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.financeDocumentType.name(), (Object)documentType));
            TableColumnSettings column1 = new TableColumnSettings();
            column1.setId(TemplateDocumentIndex.Property.title.name());
            parameters.getColumns().add(column1);
            TableColumnSettings column2 = new TableColumnSettings();
            column2.setId(TemplateDocumentIndex.Property.type.name());
            parameters.getColumns().add(column2);
            return parameters;
        });
    }

    private static IndexListParameters<Person, PersonIndex> getSigners() {
        IndexListParameters parameters = new IndexListParameters();
        parameters.setIndexType(PersonIndex.class);
        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT), SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.MANAGER)}));
        TableColumnSettings nameFilter = new TableColumnSettings();
        nameFilter.setId(PersonIndex.Property.name.name());
        parameters.getFilters().add(nameFilter);
        TableColumnSettings positionsFilter = new TableColumnSettings();
        positionsFilter.setId(PersonIndex.Property.positions.name());
        parameters.getFilters().add(positionsFilter);
        TableColumnSettings nameCol = new TableColumnSettings();
        nameCol.setId(PersonIndex.Property.name.name());
        parameters.getColumns().add(nameCol);
        TableColumnSettings positionsCol = new TableColumnSettings();
        positionsCol.setId(PersonIndex.Property.positions.name());
        parameters.getColumns().add(positionsCol);
        return parameters;
    }

    protected void beforeReadData(OrganizationDocumentsPanelController controller, OrganizationDocumentsPanelVM model) {
        Map<Locale, String> newValues;
        Map values;
        for (OrganizationFinanceDocumentVM vm : model.getFinanceDocuments().getTable()) {
            for (OrganizationSignatureVM signature : vm.getSettings().getSignatures()) {
                values = signature.getTitle().getValues();
                newValues = values.entrySet().stream().map(entry -> {
                    if (TextUtil.isBlank((String)((Locale)entry.getKey()).getLanguage())) {
                        return new AbstractMap.SimpleEntry(LocaleHelper.getCurrentLocale(), entry.getValue());
                    }
                    return entry;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                signature.getTitle().getValues().clear();
                signature.getTitle().getValues().putAll(newValues);
            }
        }
        for (OrganizationFinanceDocumentVM vm : model.getPaymentDocuments().getTable()) {
            for (OrganizationSignatureVM signature : vm.getSettings().getSignatures()) {
                values = signature.getTitle().getValues();
                newValues = values.entrySet().stream().map(entry -> {
                    if (TextUtil.isBlank((String)((Locale)entry.getKey()).getLanguage())) {
                        return new AbstractMap.SimpleEntry(LocaleHelper.getCurrentLocale(), entry.getValue());
                    }
                    return entry;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                signature.getTitle().getValues().clear();
                signature.getTitle().getValues().putAll(newValues);
            }
        }
    }
}

