/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationMetadataMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsExtraPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsPanel;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProfileService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.licence.LicenceServerProvider;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import com.gridnine.xtrip.common.model.profile.CompanyGroup;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationMetadataIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;

public class OrganizationEditorInterceptor
implements RootEntityEditorInterceptor<Organization, OrganizationUIData> {
    private static final List<String> READ_ONLY_CONTAINER_UIDS = Arrays.asList("sabre_technical_provider_profile");

    public void onLoad(DataTransferPackage<Organization, OrganizationUIData> data, Node editor) {
    }

    public boolean onSave(DataTransferPackage<Organization, OrganizationUIData> data, Node editor) {
        try {
            OrganizationSpace space = (OrganizationSpace)editor;
            ArrayList<Message> result = new ArrayList<Message>();
            this.checkMainAgency(data, space, result);
            this.checkUDID(space, result);
            this.checkCode(data, space, result);
            this.checkHolding(space, result);
            if (!result.isEmpty()) {
                FxUtil.waitForFxThread(() -> space.setMessages(result));
                return result.stream().noneMatch(message -> message.getType() == MessageType.ERROR);
            }
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
    }

    public boolean isReadOnly(DataTransferPackage<Organization, OrganizationUIData> data) {
        return READ_ONLY_CONTAINER_UIDS.contains(data.getContainer().getUid()) && !Environment.isPublished(LicenceServerProvider.class);
    }

    private void checkMainAgency(DataTransferPackage<Organization, OrganizationUIData> data, OrganizationSpace space, List<Message> messages) throws Exception {
        Boolean isSetToMainAgency = ((OrganizationMetadataMainPanel)space.getMetadataTile().getFullNode()).getMainAgencyNode().getValue();
        if (isSetToMainAgency == null || !isSetToMainAgency.booleanValue()) {
            return;
        }
        EntityReference<Organization> existingMainAgency = OrganizationEditorInterceptor.getMainAgencyUid();
        if (existingMainAgency != null && !data.getContainer().getUid().equals(existingMainAgency.getUid())) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OrganizationParametersPanel_mainAgencyAlreadyExists, (Object[])new Object[]{existingMainAgency}));
        }
    }

    private static EntityReference<Organization> getMainAgencyUid() throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationMetadataIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataKey.name(), (Object)MetadataKey.KEY_MAIN_AGENCY.name()), SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataBooleanValue.name(), (Object)Boolean.TRUE)}));
        List indices = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), OrganizationMetadataIndex.class, query);
        if (!indices.isEmpty()) {
            return ((OrganizationMetadataIndex)indices.get(0)).getSource();
        }
        return null;
    }

    private void checkUDID(OrganizationSpace space, List<Message> messages) {
        for (OrganizationUdidsDetailsExtraPanel panel : ((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)space.getUdidsDetailsTile().getFullNode()).getExtraParametersCard().getContent()).getViews()) {
            if (!((TableWidget)panel.getUdidValuesCard().getContent()).getRowsData().stream().map(item -> (String)item.getValue().get()).filter(Objects::nonNull).anyMatch(value -> value.contains("*"))) continue;
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OrganizationSabre_Incorrect_input, (Object[])new Object[0]));
        }
        ((TableWidget)((OrganizationUdidsPanel)space.getUdidsTile().getFullNode()).getGeneralCard().getContent()).getRowsData().stream().map(OrganizationUdidVM::getCategory).filter(Objects::isNull).forEach(item -> messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.UDID_category_missing, (Object[])new Object[0])));
    }

    private void checkCode(DataTransferPackage<Organization, OrganizationUIData> data, OrganizationSpace space, List<Message> messages) throws Exception {
        if (!Prefetched.getData().isCheckOrganizationsCodeUniquenessEnabled()) {
            return;
        }
        String code = ((OrganizationMainPanel)((OrganizationGeneralPanel)space.getMainTile().getFullNode()).getMainCard().getContent()).getCodeNode().getValue();
        if (TextUtil.isBlank((String)code)) {
            return;
        }
        MiscUtil.Pair validationResult = ((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).validateOrganizationCode(ServiceInvocationContext.get(), code, data.getContainer().getUid());
        if (!((Boolean)validationResult.getFirst()).booleanValue()) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Organization_code_validate_error, (Object[])new Object[]{code, validationResult.getSecond()}));
        }
    }

    private void checkHolding(OrganizationSpace space, List<Message> messages) throws Exception {
        EntityContainer companyGroupCtr;
        EntityReference companyGroup = ((OrganizationMainPanel)((OrganizationGeneralPanel)space.getMainTile().getFullNode()).getMainCard().getContent()).getCompanyGroupNode().getValue();
        EntityReference holding = ((OrganizationMainPanel)((OrganizationGeneralPanel)space.getMainTile().getFullNode()).getMainCard().getContent()).getHoldingNode().getValue();
        if (companyGroup != null && holding != null && ((CompanyGroup)(companyGroupCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), companyGroup)).getEntity()).getHolding() != null && !holding.equals((Object)((CompanyGroup)companyGroupCtr.getEntity()).getHolding())) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Organization_holding_validate_error, (Object[])new Object[0]));
        }
    }
}

