/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalanceDataVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalanceFilterContainer;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalanceSummaryFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBalanceSummaryPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpaceController;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorFilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors.OrganizationControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceProperties;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceResult;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.util.Pair;

public class OrganizationFilterableDataViewHandler
extends FilterableDataViewHandler<OrganizationBalanceDataVM, OrganizationBalanceFilterContainer> {
    private static final int DEFAULT_LIMIT = 40;
    private int offset;
    private final OrganizationSpaceController controller;
    private final OrganizationBalanceSummaryFullPanel balanceSummary;

    protected OrganizationFilterableDataViewHandler(OrganizationBalanceSummaryFullPanel balanceSummary, OrganizationSpaceController controller) {
        super(() -> OrganizationFilterableDataViewHandler.createBalanceFilterPanel(controller.getView()), false);
        this.controller = controller;
        this.balanceSummary = balanceSummary;
        OrganizationBalanceSummaryPanel balancePanel = (OrganizationBalanceSummaryPanel)balanceSummary.getBalanceSummaryCard().getContent();
        balancePanel.getHoldAmountNode().setVisible(false);
        balancePanel.getPlannedDebitAmountNode().setVisible(false);
        balancePanel.getPlannedCreditAmountNode().setVisible(false);
        balancePanel.getEndDatePlannedBalanceAmountNode().setVisible(false);
        balancePanel.getStartDatePlannedBalanceAmountNode().setVisible(false);
    }

    private static OrganizationBalanceFilterContainer createBalanceFilterPanel(OrganizationSpace space) {
        OrganizationBalanceFilterContainer filterPanel = new OrganizationBalanceFilterContainer(false);
        filterPanel.getAgencyNode().setListParametersSupplier(() -> OrganizationControllerInterceptor.getDependentAgencies(space));
        filterPanel.getEndDateNode().setInitialTimeSupplier(() -> LocalTime.MAX);
        filterPanel.getCurrencyNode().setNoNulls(true);
        return filterPanel;
    }

    protected int getLimit() {
        return 40;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected void reloadData(int newOffset, List<Pair<String, SortOrder>> sorting) {
        FinanceServiceProperties prop = new FinanceServiceProperties();
        EntityContainer container = RootEntityPane.lookup((Node)this.controller.getView()).getData().getContainer();
        if (container == null || container.getRevision() == null) {
            return;
        }
        OrganizationBalanceFilterContainer filterPane = (OrganizationBalanceFilterContainer)this.getFilteringPane().getContent();
        prop.setAgencyRef(filterPane.getAgencyNode().getValue());
        prop.setClientRef(container.toReference());
        prop.setStartDate(DateUtils.asDate((LocalDateTime)filterPane.getStartDateNode().getValue()));
        LocalDateTime dateTemp = ((OrganizationBalanceFilterContainer)this.getFilteringPane().getContent()).getEndDateNode().getValue();
        LocalDateTime endDate = null;
        if (dateTemp != null) {
            LocalTime localTime = LocalTime.of(dateTemp.toLocalTime().getHour(), dateTemp.toLocalTime().getMinute(), 59, 999999999);
            endDate = LocalDateTime.of(dateTemp.toLocalDate(), localTime);
        }
        prop.setEndDate(DateUtils.asDate(endDate));
        prop.setOffset(newOffset);
        prop.setLimit(this.getLimit());
        prop.setCurrency(filterPane.getCurrencyNode().getValue());
        prop.setCreditLimitInfo(((Organization)container.getEntity()).getFinanceRestrictions().getCreditLimits());
        Notifications.get().submitTask(() -> {
            FinanceService financeService = (FinanceService)RpcServiceManager.get().getService(FinanceService.class);
            FinanceServiceResult result = financeService.loadDataForOrganization(ServiceInvocationContext.get(), prop);
            FxUtil.waitForFxThread(() -> {
                if (this.getWidget() == null) {
                    return;
                }
                this.offset = result.getOffset();
                this.getData().setAll(this.filingDataView(result));
            });
        }, this.getMutex());
    }

    private List<OrganizationBalanceDataVM> filingDataView(FinanceServiceResult result) {
        ArrayList<OrganizationBalanceDataVM> dataVM = new ArrayList<OrganizationBalanceDataVM>();
        if (result == null) {
            return dataVM;
        }
        this.fillingDataBalancePanel(result);
        if (result.isNewTransaction()) {
            this.tuningWidgetForNewWidget(result);
        } else {
            this.tuningWidgetForOldTransaction();
        }
        if (result.getTransactionData() == null) {
            return dataVM;
        }
        result.getTransactionData().forEach(index -> {
            OrganizationBalanceDataVM view = new OrganizationBalanceDataVM();
            view.setClientReference(index.getClientRef());
            if (index.getTransactionSum() != null) {
                Money amount = new Money();
                amount.setValue(index.getTransactionSum());
                amount.setCurrency(index.getCurrency());
                view.setAmountValue(amount);
            }
            view.setAgencyReference(index.getAgencyRef());
            view.setPaymentTypeValue(index.getPaymentType());
            view.setContractValue(index.getContractType());
            view.setDateValue(DateUtils.asLocalDateTime((Date)index.getTransactionDate()));
            view.setCategoryValue(index.getCategory());
            view.setAgentReference(index.getAgentRef());
            view.setTypeValue(index.getType());
            view.setOrderReference(index.getReferencedEntity());
            view.setStatusValue(index.getStatus());
            view.setSourceBillingTransaction(index.getSourceBillingTransaction());
            view.setSourceTransaction(index.getSourceTransaction());
            if (index.getType() != null) {
                view.setType(index.getType().toString());
            }
            if (index.getStatus() != null) {
                view.setStatus(index.getStatus().toString());
            }
            if (index.getCategory() != null && index.getCategory().equals((Object)BillingTransactionCategory.DEBIT) && index.getTransactionSum() != null && index.getTransactionSum() != null) {
                view.setDebit((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
            }
            if (index.getCategory() != null && index.getCategory().equals((Object)BillingTransactionCategory.CREDIT) && index.getTransactionSum() != null && index.getTransactionSum() != null) {
                view.setCredit((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
            }
            if (result.isNewTransaction()) {
                if (result.getDimensionType1() != null) {
                    view.setAgencyOrDem1(BalanceEditorFilterableDataViewHandler.getStringFromObject(index.getDimensionValue1(), result.getDimensionType1()));
                }
                if (result.getDimensionType2() != null) {
                    view.setAgentOrDem2(BalanceEditorFilterableDataViewHandler.getStringFromObject(index.getDimensionValue2(), result.getDimensionType2()));
                }
                if (result.getDimensionType3() != null) {
                    view.setPaymentMethodOrDem3(BalanceEditorFilterableDataViewHandler.getStringFromObject(index.getDimensionValue3(), result.getDimensionType3()));
                }
                view.setProductUid(index.getProductUid());
                view.setOrderReference(index.getBookingFileRef());
                view.setDocumentReference(index.getDocumentRef());
            } else {
                if (index.getAgencyRef() != null) {
                    view.setAgencyOrDem1(index.getAgencyRef().getCaption());
                }
                if (index.getAgentRef() != null) {
                    view.setAgentOrDem2(index.getAgentRef().getCaption());
                }
                if (index.getPaymentType() != null) {
                    view.setPaymentMethodOrDem3(index.getPaymentType().toString());
                }
            }
            if (index.getTransactionDate() != null) {
                view.setDate((String)StandardRenderers.DATE.apply((Object)index.getTransactionDate()));
            }
            if (index.getReferencedEntity() != null) {
                view.setOrder(index.getReferencedEntity().getCaption());
                view.setOrderReference(index.getReferencedEntity());
            }
            view.setDescription(index.getDescription());
            view.setDocumentNumber(index.getFinDocNumber());
            dataVM.add(view);
        });
        return dataVM;
    }

    private void fillingDataBalancePanel(FinanceServiceResult result) {
        OrganizationBalanceSummaryPanel balancePanel = (OrganizationBalanceSummaryPanel)this.balanceSummary.getBalanceSummaryCard().getContent();
        balancePanel.getCreditAmountNode().getCreditAmountValueNode().setValue((Number)result.getCreditAmount());
        balancePanel.getDebitAmountNode().getDebitAmountValueNode().setValue((Number)result.getDebitAmount());
        balancePanel.getAvailableAmountNode().getAvailableAmountValueNode().setValue((Number)result.getAvailableAmount());
        balancePanel.getBalanceAmountNode().getBalanceAmountValueNode().setValue((Number)result.getBalanceAmount());
        balancePanel.getEndDateBalanceAmountNode().getEndDateBalanceAmountValueNode().setValue((Number)result.getEndDateBalanceAmount());
        balancePanel.getStartDateBalanceAmountNode().getStartDateBalanceAmountValueNode().setValue((Number)result.getStartDateBalanceAmount());
    }

    private void tuningWidgetForNewWidget(FinanceServiceResult result) {
        String captionColumns;
        ObservableList columns = this.getWidget().getTableView().getColumns();
        ((TableColumn)columns.get(3)).setVisible(false);
        ((TableColumn)columns.get(10)).setVisible(false);
        ((TableColumn)columns.get(0)).setVisible(result.getDimensionType1() != null);
        ((TableColumn)columns.get(1)).setVisible(result.getDimensionType2() != null);
        ((TableColumn)columns.get(2)).setVisible(result.getDimensionType3() != null);
        if (result.getDimensionType1() != null) {
            captionColumns = this.getCaptionFromDimensionType(result.getDimensionType1());
            ((TableColumn)columns.get(0)).setText(captionColumns);
        }
        if (result.getDimensionType2() != null) {
            captionColumns = this.getCaptionFromDimensionType(result.getDimensionType2());
            ((TableColumn)columns.get(1)).setText(captionColumns);
        }
        if (result.getDimensionType3() != null) {
            captionColumns = this.getCaptionFromDimensionType(result.getDimensionType3());
            ((TableColumn)columns.get(2)).setText(captionColumns);
        }
    }

    private void tuningWidgetForOldTransaction() {
        ObservableList columns = this.getWidget().getTableView().getColumns();
        ((TableColumn)columns.get(0)).setVisible(true);
        ((TableColumn)columns.get(1)).setVisible(true);
        ((TableColumn)columns.get(2)).setVisible(true);
        ((TableColumn)columns.get(3)).setVisible(true);
        ((TableColumn)columns.get(10)).setVisible(true);
        ((TableColumn)columns.get(0)).setText(Messages.Dimension_organization);
        ((TableColumn)columns.get(1)).setText(Messages.Dimension_agent);
        ((TableColumn)columns.get(2)).setText(Messages.Dimension_payment_type);
    }

    private String getCaptionFromDimensionType(DimensionType type) {
        String caption;
        switch (type) {
            case PAYMENT_TYPE: {
                caption = Messages.Dimension_payment_type;
                break;
            }
            case CONTRACT_TYPE: {
                caption = Messages.Dimension_contract_type;
                break;
            }
            case ORGANIZATION: {
                caption = Messages.Dimension_organization;
                break;
            }
            case SALES_POINT: {
                caption = Messages.Dimension_sales_point;
                break;
            }
            case AGENT: {
                caption = Messages.Dimension_agent;
                break;
            }
            case CASH: {
                caption = Messages.Dimension_cash;
                break;
            }
            case CASH_REGISTER: {
                caption = Messages.Dimension_cash_register;
                break;
            }
            case CASH_REGISTER_WORKPLACE: {
                caption = Messages.Dimension_cash_register_workplace;
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)String.format("for dimension type: %s, not found view", type), (Object[])new Object[0]);
            }
        }
        return caption;
    }
}

