/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.DoubleHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGeneralPanelController;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationRequisitesPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.incidents.IncidentsContext;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.profile.CompanyGroupIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.system.model.RegionalType;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class OrganizationGeneralParametersControllerInterceptor
extends ControllerInterceptor<OrganizationGeneralPanelVM, OrganizationGeneralPanelController> {
    private Set<RegionalType> organizationRegionalPropertiesTypes = Collections.singleton(RegionalType.RU);

    protected Class<OrganizationGeneralPanelController> getControllerClass() {
        return OrganizationGeneralPanelController.class;
    }

    protected void afterReadData(OrganizationGeneralPanelController controller, OrganizationGeneralPanelVM model) {
        super.afterReadData((ViewController)controller, (Object)model);
        OrganizationMainPanel content = (OrganizationMainPanel)controller.getView().getMainCard().getContent();
        if (content.getLegalFormNode().getValue() == null) {
            content.getProfileCell().setHidden(true);
        } else {
            Notifications.get().submitTask(() -> {
                boolean isIndividualEntrepreneur = this.getLegalForm(content).map(LegalForm::isIndividualEntrepreneur).orElse(false);
                FxUtil.runInFxThread(() -> content.getProfileCell().setHidden(!isIndividualEntrepreneur));
            }, "");
        }
        boolean simpleTaxed = ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getSimpleTaxedNode().getValue();
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatRateCell().setHidden(!simpleTaxed || !this.organizationRegionalPropertiesTypes.contains(RegionalType.RU));
    }

    protected void onCreate(OrganizationGeneralPanelController controller) {
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getHoldingNode().setListParametersSupplier(ControllerInterceptorsHelper::getHoldings);
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getLegalFormNode().setValueSelectionListener(item -> {
            OrganizationMainPanel content = (OrganizationMainPanel)controller.getView().getMainCard().getContent();
            if (item != null && item.getReference() != null) {
                Notifications.get().submitTask(() -> {
                    boolean isIndividualEntrepreneur = this.getLegalForm(content).map(LegalForm::isIndividualEntrepreneur).orElse(false);
                    FxUtil.runInFxThread(() -> content.getProfileCell().setHidden(!isIndividualEntrepreneur));
                }, "");
            }
        });
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getLegalFormNode().setClearAction(() -> {
            ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getLegalFormNode().setValue(null);
            ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getProfileCell().setHidden(true);
        });
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getParentNode().setListParametersSupplier(ControllerInterceptorsHelper::getOrganizations);
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getTypesNode().setItemsSupplier(Suppliers.createEnumSupplier(OrganizationType.class));
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getTypesNode().getValues().addListener(c -> ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getAirlineCell().setHidden(!c.getList().contains((Object)OrganizationType.BLANK_OWNER)));
        if (Prefetched.getData().getRegionalSettings() != null && !Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes().isEmpty()) {
            this.organizationRegionalPropertiesTypes = Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes();
        }
        ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getHoldingNode().valueProperty().addListener((observable, oldValue, newValue) -> ((OrganizationMainPanel)controller.getView().getMainCard().getContent()).getCompanyGroupNode().setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(CompanyGroupIndex.class);
            result.getSortings().put(CompanyGroupIndex.Property.shortName.name(), SortOrder.ASC);
            result.getPatternSearchFields().add(CompanyGroupIndex.Property.shortName.name());
            result.getPatternSearchFields().add(CompanyGroupIndex.Property.fullName.name());
            ListParametersHelper.setFilters(result, CompanyGroupIndex.Property.shortName.name(), CompanyGroupIndex.Property.fullName.name());
            ListParametersHelper.setColumns(result, CompanyGroupIndex.Property.shortName.name(), CompanyGroupIndex.Property.fullName.name());
            if (newValue != null) {
                result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CompanyGroupIndex.Property.holding.name(), (Object)newValue), SearchCriterion.isEmpty((String)CompanyGroupIndex.Property.holding.name())}));
            }
            return result;
        }));
        DoubleHistoricalWidget vatRateNode = ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatRateNode();
        vatRateNode.setItemsSupplier(ControllerInterceptorVatHelper.getVatSimpleTaxedSupplier());
        vatRateNode.setConverter(ControllerInterceptorVatHelper.vatConverter);
        boolean regionalPropertiesContainsRU = this.organizationRegionalPropertiesTypes.contains(RegionalType.RU);
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getSimpleTaxedNode().valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Boolean.FALSE || !regionalPropertiesContainsRU) {
                ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatRateNode().getValues().clear();
                ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatRateCell().setHidden(true);
            } else {
                ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatRateCell().setHidden(false);
            }
        });
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getRegistrationIdCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.RU));
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getKppCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.RU));
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatRateCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.RU));
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getBinCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.KZ));
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatSeriesNumberCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.KZ));
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getVatSeriesDateCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.KZ));
        ((OrganizationRequisitesPanel)controller.getView().getRequisitesCard().getContent()).getBeneficiaryCodeCell().setHidden(!this.organizationRegionalPropertiesTypes.contains(RegionalType.KZ));
    }

    private Optional<LegalForm> getLegalForm(OrganizationMainPanel content) {
        try {
            DictService service = (DictService)RpcServiceManager.get().getService(DictService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            DictionaryReference legalFormRef = content.getLegalFormNode().getValue();
            return Optional.ofNullable(service.load(sic, legalFormRef));
        }
        catch (Exception exception) {
            IncidentsContext.setContextValue((String)"Method", (String)"getLegalForm");
            IncidentsLog.reportStackTrace((String)exception.getMessage());
            return Optional.empty();
        }
    }
}

