/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsExtraPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsUdidTypeContainer;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class OrganizationUdidsImportAction
implements TileAction<Node, OrganizationUdidsDetailsPanel> {
    OrganizationUdidsImportAction() {
    }

    public boolean isEnabled(Tile<Node, OrganizationUdidsDetailsPanel> tile) {
        return !((CompactGroupsWidget)((OrganizationUdidsDetailsPanel)tile.getFullNode()).getExtraParametersCard().getContent()).getViewState().isImmutable();
    }

    public double getWeight() {
        return 0.0;
    }

    public String getName(Tile<Node, OrganizationUdidsDetailsPanel> tile) {
        return Messages.Import_UDID_values;
    }

    public String getDescription(Tile<Node, OrganizationUdidsDetailsPanel> tile) {
        return Messages.Import_UDID_values;
    }

    public void execute(Control source, Tile<Node, OrganizationUdidsDetailsPanel> tile, boolean alt) {
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.OPEN_SINGLE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Excel_UDID_value_files, new String[]{"*.xls", "*.xlsx"})));
        RadioBoxWidget updateOptionsWidget = new RadioBoxWidget(false);
        updateOptionsWidget.setItemsSupplier(() -> {
            ArrayList<ImportCosCodesType> list = new ArrayList<ImportCosCodesType>();
            list.add(ImportCosCodesType.FULL_UPDATE);
            list.add(ImportCosCodesType.APPEND);
            return list;
        });
        updateOptionsWidget.valueProperty().set((Object)ImportCosCodesType.FULL_UPDATE);
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("file", UiCardsContainer.Style.STATIC, Messages.File, (Node)GridContainer.wrap((Node)fileChooserWidget)));
        cardsContainer.getCards().add((Object)new Card("updateOptions", UiCardsContainer.Style.STATIC, Messages.Upgrade_approach, (Node)updateOptionsWidget));
        new Dialog().setTitle(Messages.Importing_UDID_values).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Import, () -> {
            ArrayList importFiles = new ArrayList(fileChooserWidget.getFiles());
            if (importFiles.isEmpty()) {
                Dialog.info((String)Messages.Must_specify_a_file_to_import);
            } else {
                this.performImport((File)fileChooserWidget.getFiles().get(0), (OrganizationUdidsDetailsPanel)tile.getFullNode(), (ImportCosCodesType)((Object)((Object)updateOptionsWidget.valueProperty().get())));
            }
        }).show((Node)source);
    }

    private void performImport(final File file, final OrganizationUdidsDetailsPanel full, final ImportCosCodesType updateOption) {
        Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Action_Import_UDID_values;
            }

            protected void execute() throws Exception {
                try {
                    boolean hasError;
                    HashMap allUdidValues;
                    HashMap categoryMap;
                    block47: {
                        categoryMap = new HashMap();
                        allUdidValues = new HashMap();
                        hasError = false;
                        ((CompactGroupsWidget)full.getExtraParametersCard().getContent()).getViews().forEach(view -> {
                            try {
                                if (((OrganizationUdidsDetailsUdidTypeContainer)view.getUdidTypeCard().getContent()).getCategoryHiddenNode().valueProperty().get() != null) {
                                    ServiceInvocationContext sic = ServiceInvocationContext.get();
                                    DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                                    CostCodeCategory category = (CostCodeCategory)dictService.load(sic, (DictionaryReference)((OrganizationUdidsDetailsUdidTypeContainer)view.getUdidTypeCard().getContent()).getCategoryHiddenNode().valueProperty().get());
                                    if (category != null) {
                                        categoryMap.put(category.getShortName(), view);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ErrorHandler.handle((Throwable)ex);
                            }
                        });
                        this.setProgress((byte)10, "");
                        try (FileInputStream is = new FileInputStream(file);
                             XSSFWorkbook workbook = FilenameUtils.getExtension((String)file.getAbsolutePath()).equals("xlsx") ? new XSSFWorkbook((InputStream)is) : new HSSFWorkbook((InputStream)is);){
                            Sheet sheet = workbook.getSheetAt(0);
                            Row headerRow = sheet.getRow(0);
                            String[] headers = new String[headerRow.getLastCellNum()];
                            for (int q = 0; q < headerRow.getLastCellNum(); ++q) {
                                headers[q] = headerRow.getCell(q).getStringCellValue();
                                if (allUdidValues.containsKey(headers[q])) continue;
                                allUdidValues.put(headers[q], new ArrayList());
                            }
                            Row subHeadersRow = sheet.getRow(1);
                            String[] subHeaders = new String[subHeadersRow.getLastCellNum()];
                            for (int q = 0; q < subHeadersRow.getLastCellNum(); ++q) {
                                subHeaders[q] = 0 == subHeadersRow.getCell(q).getCellType() ? this.fmt(subHeadersRow.getCell(q).getNumericCellValue()) : subHeadersRow.getCell(q).getStringCellValue();
                            }
                            this.setProgress((byte)20, "");
                            for (int rowIndex = 2; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                                Row row = sheet.getRow(rowIndex);
                                HashMap<String, CostCode> currentRowValues = new HashMap<String, CostCode>();
                                for (int colIndex = 0; colIndex < row.getLastCellNum(); ++colIndex) {
                                    Cell cell = row.getCell(colIndex);
                                    if (cell == null) continue;
                                    String category = headers[colIndex];
                                    String valueType = subHeaders[colIndex];
                                    if (TextUtil.isBlank((String)category) || TextUtil.isBlank((String)valueType)) continue;
                                    String value = null;
                                    value = 0 == cell.getCellType() ? this.fmt(row.getCell(colIndex).getNumericCellValue()) : row.getCell(colIndex).getStringCellValue();
                                    CostCode ccValue = (CostCode)currentRowValues.get(category);
                                    if (ccValue == null) {
                                        ccValue = new CostCode();
                                        currentRowValues.put(category, ccValue);
                                    }
                                    if ("SABRE_VALUE".equalsIgnoreCase(valueType)) {
                                        ccValue.setValue(value);
                                        continue;
                                    }
                                    if ("LOCAL_VALUE".equalsIgnoreCase(valueType)) {
                                        ccValue.setLocalValue(value);
                                        continue;
                                    }
                                    if ("ENGLISH_VALUE".equalsIgnoreCase(valueType)) {
                                        ccValue.setEnglishValue(value);
                                        continue;
                                    }
                                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Invalid_value + valueType), (Object[])new Object[0])});
                                    hasError = true;
                                    break block47;
                                }
                                for (Map.Entry entry : currentRowValues.entrySet()) {
                                    if (TextUtil.isBlank((String)((CostCode)entry.getValue()).getValue()) && TextUtil.isBlank((String)((CostCode)entry.getValue()).getLocalValue()) && TextUtil.isBlank((String)((CostCode)entry.getValue()).getEnglishValue())) continue;
                                    ((List)allUdidValues.get(entry.getKey())).add(entry.getValue());
                                }
                            }
                        }
                    }
                    this.setProgress((byte)40, "");
                    float progress = 40.0f;
                    float step = 60 / allUdidValues.size();
                    if (!hasError) {
                        for (Map.Entry entry : allUdidValues.entrySet()) {
                            if (categoryMap.get(entry.getKey()) != null) {
                                OrganizationUdidsDetailsExtraPanel panelVM = (OrganizationUdidsDetailsExtraPanel)categoryMap.get(entry.getKey());
                                HashSet<String> costCodes = new HashSet<String>();
                                if (updateOption == ImportCosCodesType.FULL_UPDATE) {
                                    try {
                                        FxUtil.waitForFxThread(() -> ((TableWidget)panelVM.getUdidValuesCard().getContent()).removeAllRows());
                                    }
                                    catch (Exception e) {
                                        ErrorHandler.handle((Throwable)e);
                                    }
                                } else {
                                    this.getCurrentCostCodes(costCodes, panelVM);
                                }
                                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                                    if (!(TextUtil.isBlank((String)((CostCode)((List)entry.getValue()).get(i)).getValue()) && TextUtil.isBlank((String)((CostCode)((List)entry.getValue()).get(i)).getLocalValue()) && TextUtil.isBlank((String)((CostCode)((List)entry.getValue()).get(i)).getEnglishValue()))) {
                                        if (!costCodes.contains(((CostCode)((List)entry.getValue()).get(i)).getValue() + ((CostCode)((List)entry.getValue()).get(i)).getLocalValue() + ((CostCode)((List)entry.getValue()).get(i)).getEnglishValue())) {
                                            this.addInformation(costCodes, panelVM, (String)entry.getKey(), (CostCode)((List)entry.getValue()).get(i), i);
                                            continue;
                                        }
                                        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Value + ((CostCode)((List)entry.getValue()).get(i)).getValue() + " - " + ((CostCode)((List)entry.getValue()).get(i)).getLocalValue() + " - " + ((CostCode)((List)entry.getValue()).get(i)).getEnglishValue() + Messages.With_category + (String)entry.getKey() + Messages.Already_exist), (Object[])new Object[0])});
                                        continue;
                                    }
                                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Values_for_type + (String)entry.getKey() + Messages.Miss), (Object[])new Object[0])});
                                }
                            } else {
                                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Values_for_the_category + (String)entry.getKey() + Messages.Not_founded), (Object[])new Object[0])});
                            }
                            this.setProgress((byte)(progress += step), "");
                        }
                    } else {
                        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Error_importing_UDID_values, (Object[])new Object[0])});
                    }
                    this.setProgress((byte)100, "");
                }
                catch (Exception ex) {
                    ErrorHandler.handle((Throwable)ex);
                }
            }

            private String fmt(double d) {
                int i = (int)d;
                return d == (double)i ? String.valueOf(i) : String.valueOf(d);
            }

            private void addInformation(Set<String> existingCostCodes, OrganizationUdidsDetailsExtraPanel panelVM, String category, CostCode values, int index) {
                try {
                    FxUtil.waitForFxThread(() -> {
                        AtomicBoolean rowAdded = new AtomicBoolean(false);
                        if (this.addValue(panelVM, category, values.getValue(), values.getLocalValue(), values.getEnglishValue(), rowAdded, "value")) {
                            return;
                        }
                        this.addValue(panelVM, category, values.getLocalValue(), values.getValue(), values.getEnglishValue(), rowAdded, "localValue");
                        this.addValue(panelVM, category, values.getEnglishValue(), values.getValue(), values.getLocalValue(), rowAdded, "englishValue");
                    });
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                existingCostCodes.add(values.getValue() + values.getLocalValue() + values.getEnglishValue());
            }

            private boolean addValue(OrganizationUdidsDetailsExtraPanel panelVM, String category, String value, String otherValue1, String otherValue2, AtomicBoolean rowAdded, String columnName) {
                switch (columnName) {
                    case "value": {
                        if (!this.hasIllegalSymbols(value)) break;
                        return true;
                    }
                }
                Optional<String> englishValue = Optional.ofNullable(value);
                englishValue.ifPresent(sabreValue -> {
                    if (!this.isBlank((String)sabreValue, category, otherValue1, otherValue2) && this.checkMask(((OrganizationUdidsDetailsUdidTypeContainer)panelVM.getUdidTypeCard().getContent()).getMaskNode().getValue(), (String)sabreValue)) {
                        if (!rowAdded.get()) {
                            ((TableWidget)panelVM.getUdidValuesCard().getContent()).addRow(((TableWidget)panelVM.getUdidValuesCard().getContent()).getRowsCount());
                            rowAdded.set(true);
                        }
                        ((TextFieldWidget)((TableWidget)panelVM.getUdidValuesCard().getContent()).getColumn(columnName).getWidget(((TableWidget)panelVM.getUdidValuesCard().getContent()).getRowsCount() - 1)).setValue(sabreValue);
                    }
                });
                return false;
            }

            private boolean hasIllegalSymbols(String sabreValue) {
                if (TextUtil.isBlank((String)sabreValue)) {
                    return false;
                }
                Matcher matcher = ProfileSynchronizationUtil.SABRE_ILLEGAL_SYMBOLS_STRICT.matcher(sabreValue);
                if (matcher.find()) {
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)(Messages.Value_in_Sabre_is_not_added + sabreValue), (Object[])new Object[0])});
                    return true;
                }
                return false;
            }

            private boolean isBlank(String value, String category, String otherValue1, String otherValue2) {
                if (TextUtil.isBlank((String)value)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(Messages.Value_in_the_Sabre_category);
                    builder.append(category);
                    builder.append(Messages.Unspecified);
                    builder.append(otherValue1);
                    builder.append(" - ");
                    builder.append(otherValue2);
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)builder.toString(), (Object[])new Object[0])});
                    return true;
                }
                return false;
            }

            private boolean checkMask(String mask, String value) {
                if (SabreProfileHelper.checkMask((String)mask, (String)value)) {
                    return true;
                }
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)(Messages.Value_did_not_match_the_mask_format + value), (Object[])new Object[0])});
                return false;
            }

            private Set<String> getCurrentCostCodes(Set<String> costCodes, OrganizationUdidsDetailsExtraPanel panelVM) {
                for (int i = 0; i < ((TableWidget)panelVM.getUdidValuesCard().getContent()).getRowsCount(); ++i) {
                    String value = ((TextFieldWidget)((TableWidget)panelVM.getUdidValuesCard().getContent()).getColumn("value").getWidget(i)).getValue();
                    String localValue = ((TextFieldWidget)((TableWidget)panelVM.getUdidValuesCard().getContent()).getColumn("localValue").getWidget(i)).getValue();
                    String englishValue = ((TextFieldWidget)((TableWidget)panelVM.getUdidValuesCard().getContent()).getColumn("englishValue").getWidget(i)).getValue();
                    if (TextUtil.isBlank((String)value) || TextUtil.isBlank((String)localValue) || TextUtil.isBlank((String)englishValue)) continue;
                    costCodes.add(value + localValue + englishValue);
                }
                return costCodes;
            }
        });
    }

    private static enum ImportCosCodesType {
        FULL_UPDATE{

            public String toString() {
                return Messages.Full_update;
            }
        }
        ,
        APPEND{

            public String toString() {
                return Messages.Add_to_existing_list;
            }
        };

    }
}

