/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.CCCExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.CCCExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.CCCExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.controllerinterceptors.CCCExchangeDocumentControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocumentIndex;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class CCCExchangeDocumentHandler
extends BaseRootEntityHandler<CCCExchangeDocument, Void, CCCExchangeDocumentSpaceVM, CCCExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return CCCExchangeDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<CCCExchangeDocument, Void>, CCCExchangeDocumentSpaceVM>> toVM, List<BiConsumer<CCCExchangeDocumentSpaceVM, DataTransferPackage<CCCExchangeDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CCCExchangeDocumentControllerInterceptor());
        toVM.add((dtp, vm) -> {
            CCCExchangeDocument model = (CCCExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, vm.getOverview());
            ParsersHelper.generalParametersToVM((BaseExchangeDocument)model, vm.getGeneralParametersFull());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, vm.getContentFull());
            vm.getCccFull().setTransactionType(model.getTransaction());
            vm.getCccFull().setSegmentNumber(model.getTransferSegment());
            vm.getCccFull().setTicketNumber(model.getTicketNumber());
            vm.getCccFull().setBlankType(model.getBlankType());
            vm.getCccFull().setPartNumber(model.getPartNum());
            vm.getCccFull().setPackNumber(model.getPackNum());
            vm.getCccFull().setAbcPeriod(DateUtils.asLocalDate((Date)model.getAbcPeriod()));
            vm.getCccFull().setIssueDate(DateUtils.asLocalDate((Date)model.getIssued()));
            vm.getCccFull().setSupplier(model.getSupplier());
            vm.getCccFull().setAgency(model.getAgency());
            vm.getCccFull().setAirlineCode(model.getSegmentCarrierCode());
            vm.getCccFull().setValidAirlineCode(model.getValidatingCarrierNumber());
            vm.getCccFull().setFlight(model.getFlightNo());
            vm.getCccFull().setFlightClass(model.getClassOfService());
            vm.getCccFull().setFlightDate(DateUtils.asLocalDate((Date)model.getStartDate()));
            vm.getCccFull().setDeparturePlace(model.getDepartureCityCode());
            vm.getCccFull().setDestination(model.getArrivalCityCode());
            vm.getCccFull().setTarifCode(model.getFareBasis());
            vm.getCccFull().setTarifAmount(model.getEquivalentFare());
            vm.getCccFull().setPenalty(model.getPenalty());
            vm.getCccFull().setAgsTax(model.getAgsTax());
            vm.getCccFull().setTchTax(model.getTchTax());
            if (model.getCommissionRate() != null) {
                vm.getCccFull().setCommissionRate(model.getCommissionRate() == null ? null : new BigDecimal(model.getCommissionRate()));
            }
            vm.getCccFull().setCommission(model.getCommissionValue());
            vm.getCccFull().setPaymentType(model.getPaymentType());
        });
        fromVM.add((vm, dtp) -> {
            CCCExchangeDocument model = (CCCExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.generalParametersFromVM(vm.getGeneralParametersFull(), (BaseExchangeDocument)model);
            ParsersHelper.contentFromVM(vm.getContentFull(), (BaseExchangeDocument)model);
            model.setTransaction(vm.getCccFull().getTransactionType());
            model.setTransferSegment(vm.getCccFull().getSegmentNumber());
            model.setTicketNumber(vm.getCccFull().getTicketNumber());
            model.setBlankType(vm.getCccFull().getBlankType());
            model.setPartNum(vm.getCccFull().getPartNumber());
            model.setPackNum(vm.getCccFull().getPackNumber());
            model.setAbcPeriod(DateUtils.asDate((LocalDate)vm.getCccFull().getAbcPeriod()));
            model.setIssued(DateUtils.asDate((LocalDate)vm.getCccFull().getIssueDate()));
            model.setSupplier(vm.getCccFull().getSupplier());
            model.setAgency(vm.getCccFull().getAgency());
            model.setSegmentCarrierCode(vm.getCccFull().getAirlineCode());
            model.setValidatingCarrierNumber(vm.getCccFull().getValidAirlineCode());
            model.setFlightNo(vm.getCccFull().getFlight());
            model.setClassOfService(vm.getCccFull().getFlightClass());
            model.setStartDate(DateUtils.asDate((LocalDate)vm.getCccFull().getFlightDate()));
            model.setDepartureCityCode(vm.getCccFull().getDeparturePlace());
            model.setArrivalCityCode(vm.getCccFull().getDestination());
            model.setFareBasis(vm.getCccFull().getTarifCode());
            model.setEquivalentFare(vm.getCccFull().getTarifAmount());
            model.setPenalty(vm.getCccFull().getPenalty());
            model.setAgsTax(vm.getCccFull().getAgsTax());
            model.setTchTax(vm.getCccFull().getTchTax());
            if (vm.getCccFull().getCommissionRate() != null) {
                model.setCommissionRate(Double.valueOf(vm.getCccFull().getCommissionRate().doubleValue()));
            }
            model.setCommissionValue(vm.getCccFull().getCommission());
            model.setPaymentType(vm.getCccFull().getPaymentType());
        });
    }

    public Class<CCCExchangeDocument> getEntityClass() {
        return CCCExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<CCCExchangeDocumentSpace, CCCExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new CCCExchangeDocumentSpaceController(readonly);
    }

    @Override
    protected CCCExchangeDocumentSpaceVM createVM() {
        return new CCCExchangeDocumentSpaceVM();
    }
}

