/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.IWayExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.IWayExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.IWayExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.IWayExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.IWayExchangeDocumentIndex;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class IWayExchangeDocumentHandler
extends BaseRootEntityHandler<IWayExchangeDocument, Void, IWayExchangeDocumentSpaceVM, IWayExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return IWayExchangeDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<IWayExchangeDocument, Void>, IWayExchangeDocumentSpaceVM>> toVM, List<BiConsumer<IWayExchangeDocumentSpaceVM, DataTransferPackage<IWayExchangeDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            IWayExchangeDocument model = (IWayExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, vm.getOverview());
            ParsersHelper.generalParametersToVM((BaseExchangeDocument)model, vm.getGeneralParametersFull());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, vm.getContentFull());
            StringBuilder builder = new StringBuilder();
            model.getTravellers().forEach(traveler -> {
                builder.append((String)traveler);
                builder.append(", ");
            });
            if (builder.length() > 1) {
                vm.getIWayFileFull().setTravelersNames(builder.substring(0, builder.length() - 2));
            }
            vm.getIWayFileFull().setBookingNumber(model.getSystemNumber());
            vm.getIWayFileFull().setOrderFile(model.getRelatedBookingFile());
            vm.getIWayFileFull().setOwner(model.getOwner());
            vm.getIWayFileFull().setTransactionType(model.getTransactionType());
            vm.getIWayFileFull().setProductType(model.getProductType());
            vm.getIWayFileFull().setBookerNumber(model.getBookerNumber());
            StringBuilder builder2 = new StringBuilder();
            model.getRelatedProductUids().forEach(product -> {
                builder2.append((String)product);
                builder2.append(", ");
            });
            if (builder2.length() > 1) {
                vm.getIWayFileFull().setProducts(builder2.substring(0, builder2.length() - 2));
            }
            vm.getIWayFileFull().setIssued(DateUtils.asLocalDate((Date)model.getIssued()));
        });
        fromVM.add((vm, dtp) -> {
            IWayExchangeDocument model = (IWayExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.generalParametersFromVM(vm.getGeneralParametersFull(), (BaseExchangeDocument)model);
            ParsersHelper.contentFromVM(vm.getContentFull(), (BaseExchangeDocument)model);
            model.getTravellers().clear();
            if (vm.getIWayFileFull().getTravelersNames() != null) {
                String[] travelers;
                for (String str : travelers = vm.getIWayFileFull().getTravelersNames().split(",")) {
                    model.getTravellers().add(str);
                }
            }
            model.setSystemNumber(vm.getIWayFileFull().getBookingNumber());
            model.setRelatedBookingFile(vm.getIWayFileFull().getOrderFile());
            model.setOwner(vm.getIWayFileFull().getOwner());
            model.setTransactionType(vm.getIWayFileFull().getTransactionType());
            model.setProductType(vm.getIWayFileFull().getProductType());
            model.setBookerNumber(vm.getIWayFileFull().getBookerNumber());
            model.getRelatedProductUids().clear();
            if (vm.getIWayFileFull().getProducts() != null) {
                String[] products;
                for (String str : products = vm.getIWayFileFull().getProducts().split(",")) {
                    model.getRelatedProductUids().add(str);
                }
            }
            model.setIssued(DateUtils.asDate((LocalDate)vm.getIWayFileFull().getIssued()));
        });
    }

    public Class<IWayExchangeDocument> getEntityClass() {
        return IWayExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<IWayExchangeDocumentSpace, IWayExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new IWayExchangeDocumentSpaceController(readonly);
    }

    @Override
    protected IWayExchangeDocumentSpaceVM createVM() {
        return new IWayExchangeDocumentSpaceVM();
    }
}

