/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.ContentFullVM;
import com.gridnine.xtrip.client.fx.model.parsers.ExchangeDocumentOverviewPanelVM;
import com.gridnine.xtrip.client.fx.model.parsers.GeneralParametersFullVM;
import com.gridnine.xtrip.client.fx.model.parsers.GeneralParametersOwnerVM;
import com.gridnine.xtrip.client.fx.model.parsers.MessageVM;
import com.gridnine.xtrip.client.fx.model.parsers.MessagesPaneVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.LinkedHashSet;

public final class ParsersHelper {
    public static void overviewToVM(BaseExchangeDocument model, ExchangeDocumentOverviewPanelVM vm) {
        vm.setLocation(model.getLocation());
        vm.setStatus(model.getStatus());
        vm.setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
    }

    public static void generalParametersToVM(BaseExchangeDocument model, GeneralParametersFullVM vm) {
        vm.setLocation(model.getLocation());
        vm.setStatus(model.getStatus());
        vm.setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
        vm.getOwners().clear();
        LinkedHashSet<EntityReference> owners = new LinkedHashSet<EntityReference>(model.getOwners());
        if (model.getOwner() != null) {
            owners.add(model.getOwner());
        }
        for (EntityReference ref : owners) {
            vm.getOwners().add(ParsersHelper.createOwnerVM((EntityReference<? extends BaseEntity>)ref));
        }
    }

    private static GeneralParametersOwnerVM createOwnerVM(EntityReference<? extends BaseEntity> ref) {
        GeneralParametersOwnerVM result = new GeneralParametersOwnerVM();
        result.setRef(ref);
        result.setLink(TextUtil.isBlank((String)ref.getCaption()) ? ref.getUid() : ref.getCaption());
        return result;
    }

    public static void generalParametersFromVM(GeneralParametersFullVM vm, BaseExchangeDocument model) {
        model.setLocation(vm.getLocation());
        model.setStatus(vm.getStatus());
        model.setCreated(DateUtils.asDate((LocalDate)vm.getCreated()));
    }

    public static void messagesToVM(BaseExchangeDocument model, MessagesPaneVM vm) {
        VMHelper.transfer(model.getMessages(), vm.getContent(), message -> {
            MessageVM result = new MessageVM();
            result.setType(message.getType() == null ? null : message.getType().toString());
            result.getDetails().setType(message.getType());
            result.getDetails().setDetails(message.getDetails());
            if (message.getMessage() != null) {
                result.setMessage(message.getMessage().toString());
                result.getDetails().setMessage(message.getMessage().toString());
            }
            return result;
        });
    }

    public static void contentToVM(BaseExchangeDocument model, ContentFullVM vm) {
        if (model.getContent() != null) {
            RichData rd = new RichData();
            rd.setContent(model.getContent());
            rd.setContentType(model.getContentType());
            vm.setContent(rd);
        } else {
            vm.setContent(null);
        }
    }

    public static void contentFromVM(ContentFullVM vm, BaseExchangeDocument model) {
        if (vm.getContent() != null) {
            model.setContent(vm.getContent().getContent());
            model.setContentType(vm.getContent().getContentType());
        } else {
            model.setContent(null);
            model.setContentType(null);
        }
    }

    private ParsersHelper() {
    }
}

