/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.TAISExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.TAISExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.TAISExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TaisExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TaisExchangeDocumentIndex;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class TAISExchangeDocumentHandler
extends BaseRootEntityHandler<TaisExchangeDocument, Void, TAISExchangeDocumentSpaceVM, TAISExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TaisExchangeDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<TaisExchangeDocument, Void>, TAISExchangeDocumentSpaceVM>> toVM, List<BiConsumer<TAISExchangeDocumentSpaceVM, DataTransferPackage<TaisExchangeDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            TaisExchangeDocument model = (TaisExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, vm.getOverview());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, vm.getContentFull());
            vm.getTaisFull().setIssued(DateUtils.asLocalDate((Date)model.getIssueDate()));
            StringBuilder builderTr = new StringBuilder();
            model.getTravellers().forEach(traveler -> {
                builderTr.append((String)traveler);
                builderTr.append(", ");
            });
            if (builderTr.length() > 1) {
                vm.getTaisFull().setTravelersNames(builderTr.substring(0, builderTr.length() - 2));
            }
            vm.getTaisFull().setBookingNumber(model.getSystemNumber());
            vm.getTaisFull().setOrderFile(model.getRelatedBookingFile());
            vm.getTaisFull().setOwner(model.getOwner());
            vm.getTaisFull().setTransactionType(model.getTransactionType());
        });
        fromVM.add((vm, dtp) -> {
            TaisExchangeDocument model = (TaisExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.contentFromVM(vm.getContentFull(), (BaseExchangeDocument)model);
            model.setIssueDate(DateUtils.asDate((LocalDate)vm.getTaisFull().getIssued()));
            model.setOwner(vm.getTaisFull().getOwner());
            model.getTravellers().clear();
            if (vm.getTaisFull().getTravelersNames() != null) {
                String[] travelers;
                for (String str : travelers = vm.getTaisFull().getTravelersNames().split(",")) {
                    model.getTravellers().add(str.trim());
                }
            }
            model.setSystemNumber(vm.getTaisFull().getBookingNumber());
            model.setRelatedBookingFile(vm.getTaisFull().getOrderFile());
            model.setOwner(vm.getTaisFull().getOwner());
            model.setTransactionType(vm.getTaisFull().getTransactionType());
        });
    }

    public Class<TaisExchangeDocument> getEntityClass() {
        return TaisExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<TAISExchangeDocumentSpace, TAISExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new TAISExchangeDocumentSpaceController(readonly);
    }

    @Override
    protected TAISExchangeDocumentSpaceVM createVM() {
        return new TAISExchangeDocumentSpaceVM();
    }
}

