/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.standard.processing.BaseExchangeFileProcessor;
import com.gridnine.xtrip.common.fx.rpc.ExchangeFilesService;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentType;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResource;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Element;

public abstract class BaseSirenaXmlFilesProcessor<E extends ExchageDocumentResource>
extends BaseExchangeFileProcessor<E> {
    @Override
    public String getFileType() {
        return "SIRENA-XML";
    }

    @Override
    public void process() {
        List resources;
        try {
            resources = this.getResourceProvider().getResources();
        }
        catch (Exception e) {
            this.log.error("unable to get resources list", (Throwable)e);
            return;
        }
        if (resources.isEmpty()) {
            return;
        }
        ExchangeFilesService service = null;
        ServiceInvocationContext ctx = ServiceInvocationContext.get();
        try {
            service = (ExchangeFilesService)RpcServiceManager.get().getService(ExchangeFilesService.class);
        }
        catch (Exception e) {
            this.log.error("failed retrieving exchange service", (Throwable)e);
            return;
        }
        for (ExchageDocumentResource resource : resources) {
            this.log.debug(String.format("processing of file %s was started", resource));
            if (this.isGeneralProblemExists()) {
                this.log.info("general problem exists, skipping processing");
                return;
            }
            try {
                String bsoNum;
                String mcoTypeStr;
                String typeStr;
                byte[] content = this.getResourceProvider().getContent(resource);
                Element ticketsElm = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(content)).getDocumentElement();
                Element elm = XmlUtil.getElement((Element)ticketsElm, (String)"TICKET");
                if ("2.1".equals(elm.getAttribute("version")) && ("MCO".equals(typeStr = XmlUtil.getValue((Element)elm, (String)"TYPE")) || "EMD".equals(typeStr)) && !"PENALTY".equals(mcoTypeStr = XmlUtil.getValue((Element)elm, (String)"MCO_TYPE")) && !"REF_NOTICE".equals(mcoTypeStr)) {
                    this.getResourceProvider().moveTo(resource, "receipts");
                }
                if (TextUtil.isBlank((String)(bsoNum = XmlUtil.getValue((Element)elm, (String)"BSONUM")))) {
                    bsoNum = XmlUtil.getValue((Element)elm, (String)"TICKNUM");
                }
                if (TextUtil.isBlank((String)bsoNum) || bsoNum.contains("0000000000")) {
                    this.getResourceProvider().moveTo(resource, "receipts");
                    this.log.error(String.format("resource %s has bad bsonum \"%s\"", resource, bsoNum));
                    continue;
                }
                this.log.debug(String.format("standard processing of resource %s", resource));
                this.process(service, ctx, content, resource);
                this.getResourceProvider().moveTo(resource, "processed");
                this.log.debug("resource processed " + resource);
            }
            catch (Exception e) {
                this.log.error("failed processing resource " + resource, (Throwable)e);
                try {
                    this.getResourceProvider().moveTo(resource, "error");
                }
                catch (Exception e1) {
                    this.log.error("unable to move resource to error folder", (Throwable)e1);
                }
            }
        }
    }

    private void process(ExchangeFilesService service, ServiceInvocationContext ctx, byte[] content, E resource) throws Exception {
        ExchangeFile exch = new ExchangeFile();
        exch.setType(this.getFileType());
        exch.setCreated(resource.getLastModified());
        exch.setLocation(resource.getName());
        exch.setContent(content);
        NamedValue typesMetadata = new NamedValue();
        typesMetadata.setName("types");
        StringBuilder sb = new StringBuilder();
        for (SirenaXmlExchangeDocumentType item : this.getSupportedTypes()) {
            sb.append(String.format("|%s|", item.name()));
        }
        typesMetadata.setValue(sb.toString());
        exch.getMetadata().add(typesMetadata);
        service.registerExchangeFile(ctx, exch);
    }

    protected abstract List<SirenaXmlExchangeDocumentType> getSupportedTypes();
}

