/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.standard.processing.BaseExchangeFileProcessor;
import com.gridnine.xtrip.common.parsers.register.ExchangeDocumentFileResource;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public abstract class BaseSsodSSODFilesProcessor
extends BaseExchangeFileProcessor<ExchangeDocumentFileResource> {
    static boolean matchesNewFormatName(String fileName) {
        if (fileName == null) {
            return false;
        }
        String lowerCase = fileName.trim().toLowerCase();
        return lowerCase.matches("ret\\..*-[0-9]{8}") || lowerCase.matches("hot\\..*-[0-9]{8}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            List resources = this.getResourceProvider().getResources();
            for (ExchangeDocumentFileResource res : resources) {
                if (!res.getFile().getName().endsWith(".gz")) continue;
                String realName = res.getFile().getName().substring(0, res.getFile().getName().length() - 3);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (FileInputStream fis = new FileInputStream(res.getFile());){
                    IoUtil.copyStream((InputStream)fis, (OutputStream)baos, (int)256);
                }
                byte[] uncompressed = GZIPUtil.gunzip((byte[])baos.toByteArray());
                try (FileOutputStream fos = new FileOutputStream(new File(res.getFile().getParentFile(), realName));){
                    IoUtil.copyStream((InputStream)new ByteArrayInputStream(uncompressed), (OutputStream)fos, (int)256);
                }
                res.getFile().delete();
            }
        }
        catch (Exception e) {
            this.log.error("unable to get file list", (Throwable)e);
        }
        super.process();
    }
}

