/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.standard.processing.BaseExchangeFileProcessor;
import com.gridnine.xtrip.client.fx.standard.processing.ExchangeDocumentFileResourceProvider;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResourceProvider;
import com.gridnine.xtrip.common.parsers.register.ExchangeDocumentFileResource;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class IURFilesProcessor
extends BaseExchangeFileProcessor<ExchangeDocumentFileResource> {
    @Override
    public String getFileType() {
        return "IUR";
    }

    @Override
    protected ExchageDocumentResourceProvider<ExchangeDocumentFileResource> createResourceProvider() {
        return new ExchangeDocumentFileResourceProvider("import.IUR.folder", "iur-files", new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String name = file.getName().toLowerCase(Locale.ENGLISH);
                if (name.startsWith(".")) {
                    return false;
                }
                if (name.endsWith(".pnr")) {
                    return true;
                }
                return name.endsWith(".fil");
            }
        }){

            @Override
            public void moveTo(ExchangeDocumentFileResource file, String targetFolder) {
                if (!file.getFile().exists()) {
                    return;
                }
                StringBuilder strBuilder = new StringBuilder();
                int dotPos = file.getName().lastIndexOf(46);
                String fileName = null;
                String fileExt = null;
                if (dotPos >= 0) {
                    fileName = file.getName().substring(0, dotPos);
                    fileExt = file.getName().substring(dotPos + 1);
                } else {
                    fileName = file.getName();
                }
                int linePos = fileName.indexOf(95);
                if (linePos >= 0) {
                    fileName = fileName.substring(0, linePos);
                }
                SimpleDateFormat format = new SimpleDateFormat("HHmmssMM_SSS_ddMMyy");
                strBuilder.append(fileName).append('_').append(format.format(new Date()));
                if (!TextUtil.isBlank((String)fileExt)) {
                    strBuilder.append('.').append(fileExt);
                }
                File fldr = new File(file.getFile().getParentFile(), targetFolder);
                fldr.mkdirs();
                File targetFile = new File(fldr, strBuilder.toString());
                try {
                    IoUtil.copyFile((File)file.getFile(), (File)targetFile, (boolean)false);
                    file.getFile().delete();
                }
                catch (IOException ioe) {
                    IURFilesProcessor.this.log.error(String.format("failed moving file %s to %s", file, targetFile), (Throwable)ioe);
                }
            }
        };
    }

    public Class getProcessorClass() {
        return IURFilesProcessor.class;
    }
}

