/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.standard.processing.BaseExchangeFileProcessor;
import com.gridnine.xtrip.client.fx.standard.processing.ExchangeDocumentFileResourceProvider;
import com.gridnine.xtrip.common.fx.rpc.ExchangeFilesService;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResultType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.Payment1CExchangeDocument;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResource;
import com.gridnine.xtrip.common.parsers.register.ExchangeDocumentFileResource;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class Payment1CFilesProcessor
extends BaseExchangeFileProcessor<ExchangeDocumentFileResource> {
    private static final String PREFIX = "V8Exch";
    private static final String REF_TAG_NAME = "Ref";
    private static final String ENCASHMENT = "\u0418\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f";
    private static final String OPERATION_TYPE = "\u0412\u0438\u0434\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u0438";
    private static final List<String> REFS_TAG_NAMES = Arrays.asList("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f", "\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442", "\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e\u0414\u04421", "\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e\u0414\u04422", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430");
    private static final List<String> ORDER_TAG_NAMES = Arrays.asList("DocumentObject.\u041f\u043e\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u0435\u041d\u0430\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439\u0421\u0447\u0435\u0442", "DocumentObject.\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u0421\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0433\u043e\u0421\u0447\u0435\u0442\u0430");
    private static final List<String> DICT_TAG_NAMES = Arrays.asList("CatalogObject.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b", "CatalogObject.\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438", "CatalogObject.\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430", "CatalogObject.\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432");

    protected ExchangeDocumentFileResourceProvider createResourceProvider() {
        return new ExchangeDocumentFileResourceProvider("import.payment1c.folder", "payments-1c", ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExchangeDocumentRegistrationResult process(ExchangeFilesService service, ServiceInvocationContext ctx, ExchangeDocumentFileResource resource) throws Throwable {
        XMLEventReader reader;
        boolean newExchangeDocumentRegistration = false;
        StaticTagsData staticTagsData = new StaticTagsData();
        try (InputStream is = this.createInputStream(resource);){
            reader = XSUtil.getXMLInputFactory().createXMLEventReader(is);
            try {
                this.readStaticTags(reader, staticTagsData);
            }
            finally {
                reader.close();
            }
        }
        is = this.createInputStream(resource);
        var7_7 = null;
        try {
            ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult;
            reader = XSUtil.getXMLInputFactory().createXMLEventReader(is);
            try {
                ExchangeDocumentRegistrationResult result = new ExchangeDocumentRegistrationResult();
                result.setResultType(ExchangeDocumentRegistrationResultType.OK);
                for (byte[] content : this.splitExchangeFile(reader, staticTagsData)) {
                    try {
                        ExchangeDocumentRegistrationResult res = this.registerExchangeFile(service, ctx, (ExchageDocumentResource)resource, content);
                        if (res.getResultType() == ExchangeDocumentRegistrationResultType.ERROR) {
                            result.setFolderName(res.getFolderName());
                            result.setResultType(ExchangeDocumentRegistrationResultType.ERROR);
                        } else if (res.getResultType() == ExchangeDocumentRegistrationResultType.IGNORE) {
                            result.setFolderName(res.getFolderName());
                            result.setResultType(ExchangeDocumentRegistrationResultType.IGNORE);
                        }
                        if (res.getResultType() != ExchangeDocumentRegistrationResultType.OK) continue;
                        newExchangeDocumentRegistration = true;
                    }
                    catch (Throwable t) {
                        this.log.error("error of registration 1C payment exchange file", t);
                        result.setResultType(ExchangeDocumentRegistrationResultType.ERROR);
                    }
                }
                if (newExchangeDocumentRegistration && result.getResultType() != ExchangeDocumentRegistrationResultType.OK) {
                    result.setResultType(ExchangeDocumentRegistrationResultType.OK);
                }
                exchangeDocumentRegistrationResult = result;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    var7_7 = throwable2;
                    throw throwable2;
                }
            }
            reader.close();
            return exchangeDocumentRegistrationResult;
        }
        finally {
            if (is != null) {
                if (var7_7 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    private List<byte[]> splitExchangeFile(XMLEventReader reader, StaticTagsData staticTagsData) throws Exception {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    HashSet<String> collectedRefs;
                    List<XMLEvent> orderEvents;
                    byte[] content;
                    String tagName = event.asStartElement().getName().getLocalPart();
                    if (!ORDER_TAG_NAMES.contains(tagName) || (content = this.generateContent(orderEvents = this.getOrderEvents(reader, tagName, collectedRefs = new HashSet<String>(), event), collectedRefs, staticTagsData)) == null) break;
                    result.add(content);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateContent(Collection<XMLEvent> orderEvents, Collection<String> collectedRefs, StaticTagsData staticTagsData) throws Exception {
        if (orderEvents.isEmpty()) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (XMLEventWriter writer = XSUtil.getXMLOutputFactory().createXMLEventWriter(baos);){
                for (XMLEvent startEvent : staticTagsData.startEvents) {
                    writer.add(startEvent);
                }
                for (XMLEvent orderEvent : orderEvents) {
                    writer.add(orderEvent);
                }
                for (String ref : collectedRefs) {
                    if (!staticTagsData.dictionaryRefs.containsKey(ref)) continue;
                    for (XMLEvent e : (List)staticTagsData.dictionaryRefs.get(ref)) {
                        writer.add(e);
                    }
                }
                for (XMLEvent endEvent : staticTagsData.endEvents) {
                    writer.add(endEvent);
                }
            }
            Object object = baos.toByteArray();
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<XMLEvent> getOrderEvents(XMLEventReader reader, String tagName, Collection<String> collectedRefs, XMLEvent startEvent) throws XMLStreamException {
        ArrayList<XMLEvent> result = new ArrayList<XMLEvent>();
        result.add(startEvent);
        boolean readRef = false;
        StringBuilder refSb = new StringBuilder();
        boolean readOperationType = false;
        StringBuilder opTypeSb = new StringBuilder();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            result.add(event);
            switch (event.getEventType()) {
                case 1: {
                    String localName = event.asStartElement().getName().getLocalPart();
                    if (REFS_TAG_NAMES.contains(localName)) {
                        readRef = true;
                    }
                    if (!TextUtil.isSame((String)OPERATION_TYPE, (String)localName)) break;
                    readOperationType = true;
                    break;
                }
                case 4: {
                    if (readRef) {
                        refSb.append(event.asCharacters().getData());
                    }
                    if (!readOperationType) break;
                    opTypeSb.append(event.asCharacters().getData());
                    break;
                }
                case 2: {
                    String name = event.asEndElement().getName().getLocalPart();
                    if (REFS_TAG_NAMES.contains(name)) {
                        String ref = refSb.toString();
                        if (TextUtil.nonBlank((String)ref)) {
                            collectedRefs.add(ref.trim());
                        }
                        readRef = false;
                        refSb = new StringBuilder();
                    }
                    if (TextUtil.isSame((String)OPERATION_TYPE, (String)name)) {
                        String opType = opTypeSb.toString();
                        if (TextUtil.isSame((String)opType, (String)ENCASHMENT)) {
                            return Collections.emptyList();
                        }
                        readOperationType = false;
                        opTypeSb = new StringBuilder();
                    }
                    if (!tagName.equals(name)) break;
                    return result;
                }
            }
        }
        return result;
    }

    private void readStaticTags(XMLEventReader reader, StaticTagsData staticTagsData) throws XMLStreamException {
        boolean startTags = true;
        boolean endTags = false;
        block6: while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    staticTagsData.startEvents.add(event);
                    continue block6;
                }
                case 8: {
                    staticTagsData.endEvents.add(event);
                    continue block6;
                }
                case 1: {
                    if (PREFIX.equals(event.asStartElement().getName().getPrefix())) {
                        staticTagsData.startEvents.add(event);
                        continue block6;
                    }
                    startTags = false;
                    String tagName = event.asStartElement().getName().getLocalPart();
                    if (!DICT_TAG_NAMES.contains(tagName)) continue block6;
                    this.readDictionaryTag(reader, tagName, event, staticTagsData);
                    continue block6;
                }
                case 2: {
                    if (!PREFIX.equals(event.asEndElement().getName().getPrefix())) continue block6;
                    staticTagsData.endEvents.add(event);
                    continue block6;
                }
            }
            if (!startTags && !endTags && reader.hasNext() && reader.peek().isEndElement() && PREFIX.equals(reader.peek().asEndElement().getName().getPrefix())) {
                endTags = true;
            }
            if (startTags) {
                staticTagsData.startEvents.add(event);
                continue;
            }
            if (!endTags) continue;
            staticTagsData.endEvents.add(event);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readDictionaryTag(XMLEventReader reader, String tagName, XMLEvent startEvent, StaticTagsData staticTagsData) throws XMLStreamException {
        String ref;
        boolean readRef = false;
        StringBuilder sb = new StringBuilder();
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(startEvent);
        block5: while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            events.add(event);
            switch (event.getEventType()) {
                case 1: {
                    if (!REF_TAG_NAME.equals(event.asStartElement().getName().getLocalPart())) break;
                    readRef = true;
                    break;
                }
                case 4: {
                    if (!readRef || event.asCharacters().getData() == null) break;
                    sb.append(event.asCharacters().getData());
                    break;
                }
                case 2: {
                    String name = event.asEndElement().getName().getLocalPart();
                    if (REF_TAG_NAME.equals(name)) {
                        readRef = false;
                    }
                    if (tagName.equals(name)) break block5;
                }
            }
        }
        if (TextUtil.nonBlank((String)(ref = sb.toString())) && events.size() > 0) {
            staticTagsData.dictionaryRefs.put(ref, events);
        }
    }

    @Override
    public String getFileType() {
        return Payment1CExchangeDocument.class.getName();
    }

    public Class getProcessorClass() {
        return Payment1CFilesProcessor.class;
    }

    private InputStream createInputStream(ExchangeDocumentFileResource resource) throws IOException {
        return new BufferedInputStream(new FileInputStream(resource.getFile()));
    }

    private ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFilesService service, ServiceInvocationContext ctx, ExchageDocumentResource resource, byte[] content) throws ServiceException {
        ExchangeFile exch = new ExchangeFile();
        exch.setType(this.getFileType());
        exch.setCreated(resource.getLastModified());
        exch.setLocation(resource.getName());
        exch.setContent(content);
        return service.registerExchangeFile(ctx, exch);
    }

    private class StaticTagsData {
        private final Map<String, List<XMLEvent>> dictionaryRefs = new HashMap<String, List<XMLEvent>>();
        private final List<XMLEvent> startEvents = new ArrayList<XMLEvent>();
        private final List<XMLEvent> endEvents = new ArrayList<XMLEvent>();

        private StaticTagsData() {
        }
    }
}

