/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors.SSODFilesProcessor;
import com.gridnine.xtrip.client.fx.standard.processing.BaseExchangeFileProcessor;
import com.gridnine.xtrip.client.fx.standard.processing.ExchangeDocumentFileResourceProvider;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResourceProvider;
import com.gridnine.xtrip.common.parsers.register.ExchangeDocumentFileResource;
import java.io.File;
import java.io.FileFilter;
import java.util.Locale;

public class RETFilesProcessor
extends BaseExchangeFileProcessor<ExchangeDocumentFileResource> {
    protected FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (!file.isFile()) {
                return false;
            }
            String name = file.getName().toLowerCase(Locale.ENGLISH);
            if (name.startsWith(".")) {
                return false;
            }
            if (name.endsWith(".att") || name.endsWith(".ret")) {
                return true;
            }
            if (name.matches("[a-z,A-Z]+\\.[0-9]{2}[A-Z,a-z]{3}")) {
                return true;
            }
            return SSODFilesProcessor.matchesNewFormatName(name);
        }
    };

    @Override
    public String getFileType() {
        return "RET";
    }

    @Override
    protected ExchageDocumentResourceProvider<ExchangeDocumentFileResource> createResourceProvider() {
        return new ExchangeDocumentFileResourceProvider("import.RET.folder", "ret-files", this.filter);
    }

    public Class getProcessorClass() {
        return RETFilesProcessor.class;
    }
}

