/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.standard.processing.BaseExchangeFileProcessor;
import com.gridnine.xtrip.client.fx.standard.processing.ExchangeDocumentFileResourceProvider;
import com.gridnine.xtrip.common.fx.rpc.ExchangeFilesService;
import com.gridnine.xtrip.common.model.parsers.UTSItineraryParserParameters;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResourceProvider;
import com.gridnine.xtrip.common.parsers.register.ExchangeDocumentFileResource;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class UTSItineraryFilesProcessor
extends BaseExchangeFileProcessor<ExchangeDocumentFileResource> {
    private static final String FAKE_ID = "FAKE_ID";
    private final String validatorProperty = this.getConfigValue("uts.validator");
    private final String pccProperty = this.getConfigValue("uts.pcc");
    private final String agentProperty;
    private final String agencyProperty;
    private final String salesPointProperty = this.getConfigValue("salesPointUid");

    public UTSItineraryFilesProcessor() {
        this.agencyProperty = this.getConfigValue("agencyUid");
        this.agentProperty = this.getConfigValue("agentUid");
    }

    private String getConfigValue(String key) {
        String value = ClientSettings.get().getProperty(key);
        if (TextUtil.isBlank((String)value)) {
            return null;
        }
        return value.trim();
    }

    @Override
    public String getFileType() {
        return "UTS_ITINERARY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExchangeDocumentRegistrationResult process(ExchangeFilesService service, ServiceInvocationContext ctx, ExchangeDocumentFileResource file) throws Exception {
        ExchangeFile exch = new ExchangeFile();
        exch.setType(this.getFileType());
        exch.setCreated(file.getLastModified());
        exch.setLocation(file.getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.getFile()));){
            IoUtil.copyStream((InputStream)in, (OutputStream)baos, (int)256);
        }
        String content = new String(baos.toByteArray(), "cp1251");
        UTSItineraryParserParameters params = service.getUTSItineraryParameters(ctx, this.validatorProperty, this.pccProperty, this.salesPointProperty, this.agentProperty, this.agencyProperty, FAKE_ID);
        if (!TextUtil.isBlank((String)params.getValidator()) && !params.getValidator().equals(FAKE_ID)) {
            content = content + "\r\nVALIDATOR:" + params.getValidator();
        }
        if (!TextUtil.isBlank((String)params.getPcc())) {
            content = content + "\r\nPCC:" + params.getPcc();
        }
        if (!TextUtil.isBlank((String)params.getAgentCode()) && !params.getAgentCode().equals(FAKE_ID)) {
            content = content + "\r\nAGENT CODE:" + params.getAgentCode();
        }
        if (params.getAgent() != null && !params.getAgent().getUid().equals(FAKE_ID)) {
            content = content + "\r\nAGENT UID:" + params.getAgent().getUid();
        }
        if (!TextUtil.isBlank((String)params.getSalesPointCode()) && !params.getSalesPointCode().equals(FAKE_ID)) {
            content = content + "\r\nSALES POINT CODE:" + params.getSalesPointCode();
        }
        if (params.getSalesPoint() != null && !params.getSalesPoint().getUid().equals(FAKE_ID)) {
            content = content + "\r\nSALES POINT UID:" + params.getSalesPoint().getUid();
        }
        exch.setContent(content.getBytes());
        return service.registerExchangeFile(ctx, exch);
    }

    @Override
    protected ExchageDocumentResourceProvider<ExchangeDocumentFileResource> createResourceProvider() {
        return new ExchangeDocumentFileResourceProvider("import.uts.itinerary.folder", "uts-itinerary-files", ".txt");
    }

    public Class getProcessorClass() {
        return UTSItineraryFilesProcessor.class;
    }
}

