/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonAgentAccessOptionsMainPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonGDSReferenceVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSalesPointReferenceVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

final class PersonAgentAccessOptionsTileHelper {
    private PersonAgentAccessOptionsTileHelper() {
    }

    static void toVM(Person model, PersonUIData supplement, PersonAgentAccessOptionsMainPanelVM full) {
        List salesPoints = model.getSalesPoints();
        salesPoints.sort(new PlaceOfSalesComparator(supplement.getSalesPointOrganizationMap()));
        VMHelper.transfer(salesPoints, full.getSalesPoints(), re -> new PersonSalesPointReferenceVM(), (ref, vm) -> {
            vm.setSalesPoint(ref.getSalesPoint());
            vm.setAgency((EntityReference)supplement.getSalesPointOrganizationMap().get(ref.getSalesPoint()));
            vm.setStartDate(DateUtils.asLocalDate((Date)ref.getOpened()));
            vm.setEndDate(DateUtils.asLocalDate((Date)ref.getClosed()));
            vm.setDefaultForOrg(ref.isDefaultForOrg());
        });
        VMHelper.transfer(model.getGdsReferences(), full.getGdsReferences(), ref -> new PersonGDSReferenceVM(), (ref, vm) -> {
            vm.setSystem(ref.getGdsName());
            vm.setAgency(ref.getAgency());
            vm.setSalesPoint(ref.getSalesPoint());
            vm.setReferenceCode(ref.getReference());
            vm.setAgencyCode(ref.getAgencyCode());
            vm.setStartDate(DateUtils.asLocalDate((Date)ref.getOpened()));
            vm.setEndDate(DateUtils.asLocalDate((Date)ref.getClosed()));
            vm.setComment(ref.getRemarks());
        });
    }

    static void fromVM(PersonAgentAccessOptionsMainPanelVM full, Person model) {
        VMHelper.transfer(full.getSalesPoints(), model.getSalesPoints(), vm -> new PlaceOfSales(), (vm, ref) -> {
            ref.setSalesPoint(vm.getSalesPoint());
            ref.setOpened(DateUtils.asDate((LocalDate)vm.getStartDate()));
            ref.setClosed(DateUtils.asDate((LocalDate)vm.getEndDate()));
            ref.setDefaultForOrg(vm.isDefaultForOrg());
        });
        VMHelper.transfer(full.getGdsReferences(), model.getGdsReferences(), vm -> new GdsReference(), (vm, ref) -> {
            ref.setGdsName(vm.getSystem());
            ref.setAgency(vm.getAgency());
            ref.setSalesPoint(vm.getSalesPoint());
            ref.setReference(vm.getReferenceCode());
            ref.setAgencyCode(vm.getAgencyCode());
            ref.setOpened(DateUtils.asDate((LocalDate)vm.getStartDate()));
            ref.setClosed(DateUtils.asDate((LocalDate)vm.getEndDate()));
            ref.setRemarks(vm.getComment());
        });
    }

    private static class PlaceOfSalesComparator
    implements Comparator<PlaceOfSales> {
        private final Map<EntityReference<SalesPoint>, EntityReference<Organization>> salesPointOrganizations;

        PlaceOfSalesComparator(Map<EntityReference<SalesPoint>, EntityReference<Organization>> salesPointOrganizationMap) {
            this.salesPointOrganizations = salesPointOrganizationMap;
        }

        @Override
        public int compare(PlaceOfSales pos1, PlaceOfSales pos2) {
            int result = MiscUtil.compare((Comparable)((Object)PlaceOfSalesComparator.toString(this.salesPointOrganizations.get(pos1.getSalesPoint()))), (Comparable)((Object)PlaceOfSalesComparator.toString(this.salesPointOrganizations.get(pos2.getSalesPoint()))));
            return result != 0 ? result : MiscUtil.compare((Comparable)((Object)PlaceOfSalesComparator.toString(pos1.getSalesPoint())), (Comparable)((Object)PlaceOfSalesComparator.toString(pos2.getSalesPoint())));
        }

        private static String toString(EntityReference ref) {
            return ref == null ? null : ref.getCaption();
        }
    }
}

