/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.CardVM;
import com.gridnine.xtrip.client.fx.model.profile.CardsMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Person;
import java.time.LocalDate;
import java.util.Date;

final class PersonCardsTileHelper {
    private PersonCardsTileHelper() {
    }

    static void toVM(Person model, CardsMainPanelVM full) {
        VMHelper.transfer(model.getCards(), full.getCards(), card -> new CardVM(), (card, vm) -> {
            vm.setOwner(card.getNameOnCard());
            vm.setCardType(card.getVendor());
            vm.setNumber(card.getNumber());
            vm.getExpirationDate().set((Object)DateUtils.asLocalDate((Date)card.getExpiration()));
            vm.setSof(card.isSof());
            vm.setBta(card.isBta());
            vm.setComment(card.getRemarks());
            vm.setUid(card.getUid());
            vm.setCirUid(card.getCirUid());
        });
    }

    static void fromVM(CardsMainPanelVM full, Person model) {
        VMHelper.transfer(full.getCards(), model.getCards(), vm -> new Card(), (vm, card) -> {
            card.setNameOnCard(vm.getOwner());
            card.setVendor(vm.getCardType());
            card.setNumber(vm.getNumber());
            card.setExpiration(DateUtils.asDate((LocalDate)((LocalDate)vm.getExpirationDate().get())));
            card.setSof(vm.isSof());
            card.setBta(vm.isBta());
            card.setRemarks(vm.getComment());
            card.setUid(vm.getUid());
            card.setCirUid(vm.getCirUid());
        });
    }
}

