/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.model.profile.PersonPNRSettingTransferRemarksOtherVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPNRSettingTypeVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPNRSettingsMainPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPNRSettingsVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.PNRBuilderSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;

final class PersonPNRSettingsTileHelper {
    private static final String ALL = Messages.Transfer_all;
    private static final String REQUARED = Messages.Mandatory_to_carry_over;
    private static final String NOTRANSFER = Messages.Do_not_transfer;

    private PersonPNRSettingsTileHelper() {
    }

    static void toVM(Person model, PersonPNRSettingsMainPanelVM full) {
        VMHelper.transfer(model.getPnrBuildersSettings(), full.getParameters(), pnr -> new PersonPNRSettingsVM(), (settings, vm) -> {
            vm.setApplicableTo(PersonType.PASSENGER.toString());
            PersonPNRSettingTypeVM typeVM = new PersonPNRSettingTypeVM();
            typeVM.setValue(settings.getType());
            vm.setType(typeVM);
            vm.setName(settings.getName());
            vm.setComment(settings.getDescription());
            vm.getTransferFields().setDKnumber(settings.isNeedDK());
            vm.getTransferFields().setCID(settings.isNeedCID());
            vm.getTransferFields().setTravelerName(settings.isNeedTravelerName());
            vm.getTransferFields().setBonusCards(settings.isNeedFrequentFlyer());
            vm.getTransferFields().setCreditCards(settings.isNeedCreditCards());
            vm.getTransferFields().setPhoneNumbers(settings.isNeedPhones());
            vm.getTransferFields().setEmail(settings.isNeedEmails());
            vm.getTransferFields().setAddresses(settings.isNeedAddresses());
            vm.getTransferFields().setDeliveryAddresses(settings.isNeedDeliveryAddresses());
            vm.getTransferRemarks().setPayers(settings.isNeedPayers());
            vm.getTransferRemarks().setPassports(settings.isNeedDOCS());
            if (settings.isNeedAllRemarks()) {
                PersonPNRSettingTransferRemarksOtherVM other = new PersonPNRSettingTransferRemarksOtherVM();
                other.setValue(ALL);
                vm.getTransferRemarks().setOtherRemarks(other);
            } else if (settings.isNeedOnlyAlwaysMoveRemarks()) {
                PersonPNRSettingTransferRemarksOtherVM other = new PersonPNRSettingTransferRemarksOtherVM();
                other.setValue(REQUARED);
                vm.getTransferRemarks().setOtherRemarks(other);
            } else {
                PersonPNRSettingTransferRemarksOtherVM other = new PersonPNRSettingTransferRemarksOtherVM();
                other.setValue(NOTRANSFER);
                vm.getTransferRemarks().setOtherRemarks(other);
            }
            vm.getProfileBinding().setAgency(settings.isAssociateWithAgency());
            vm.getProfileBinding().setCorporateClient(settings.isAssociateWithOrganization());
            vm.getProfileBinding().setRetailClient(settings.isAssociateWithRetailClient());
        });
    }

    static void fromVM(PersonPNRSettingsMainPanelVM full, Person model) {
        VMHelper.transfer(full.getParameters(), model.getPnrBuildersSettings(), vm -> new PNRBuilderSettings(), (vm, settings) -> {
            settings.setApplicableTo(PersonType.PASSENGER.name());
            if (vm.getType() != null) {
                settings.setType(vm.getType().getValue());
            }
            settings.setName(vm.getName());
            settings.setDescription(vm.getComment());
            settings.setNeedDK(vm.getTransferFields().isDKnumber());
            settings.setNeedCID(vm.getTransferFields().isCID());
            settings.setNeedTravelerName(vm.getTransferFields().isTravelerName());
            settings.setNeedFrequentFlyer(vm.getTransferFields().isBonusCards());
            settings.setNeedCreditCards(vm.getTransferFields().isCreditCards());
            settings.setNeedPhones(vm.getTransferFields().isPhoneNumbers());
            settings.setNeedEmails(vm.getTransferFields().isEmail());
            settings.setNeedAddresses(vm.getTransferFields().isAddresses());
            settings.setNeedDeliveryAddresses(vm.getTransferFields().isDeliveryAddresses());
            settings.setNeedPayers(vm.getTransferRemarks().isPayers());
            settings.setNeedDOCS(vm.getTransferRemarks().isPassports());
            if (vm.getTransferRemarks().getOtherRemarks() != null && vm.getTransferRemarks().getOtherRemarks().getValue().equals(ALL)) {
                settings.setNeedAllRemarks(true);
                settings.setNeedOnlyAlwaysMoveRemarks(false);
                settings.setNeedNoRemarks(false);
            } else if (vm.getTransferRemarks().getOtherRemarks() != null && vm.getTransferRemarks().getOtherRemarks().getValue().equals(REQUARED)) {
                settings.setNeedAllRemarks(false);
                settings.setNeedOnlyAlwaysMoveRemarks(true);
                settings.setNeedNoRemarks(false);
            } else {
                settings.setNeedAllRemarks(false);
                settings.setNeedOnlyAlwaysMoveRemarks(false);
                settings.setNeedNoRemarks(true);
            }
            settings.setAssociateWithAgency(vm.getProfileBinding().isAgency());
            settings.setAssociateWithOrganization(vm.getProfileBinding().isCorporateClient());
            settings.setAssociateWithRetailClient(vm.getProfileBinding().isRetailClient());
        });
    }
}

