/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportsMainPanelVM;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class PersonPassportsTileHelper {
    private PersonPassportsTileHelper() {
    }

    static void toVM(Person model, PersonPassportsMainPanelVM full) {
        full.getPassports().clear();
        full.getPassports().addAll(PersonPassportWrapper.wrap((List)model.getPassports()).stream().map(PersonPassportsTileHelper::toVM).collect(Collectors.toList()));
    }

    static PersonPassportVM toVM(PersonPassportWrapper w) {
        PersonPassportVM vm = new PersonPassportVM();
        vm.setUidLatin(w.getUidLatin());
        vm.setUidCyrillic(w.getUidCyrillic());
        vm.setLastNameLatin(w.getLastNameLatin());
        vm.setLastNameCyrillic(w.getLastNameCyrillic());
        vm.setFirstNameLatin(w.getFirstNameLatin());
        vm.setFirstNameCyrillic(w.getFirstNameCyrillic());
        vm.setSecondNameLatin(w.getSecondNameLatin());
        vm.setSecondNameCyrillic(w.getSecondNameCyrillic());
        vm.setMiddleNameLatin(w.getMiddleNameLatin());
        vm.setMiddleNameCyrillic(w.getMiddleNameCyrillic());
        vm.setGender(w.getGender());
        vm.setBirthDate(DateUtils.asLocalDate((Date)w.getBirthday()));
        vm.setPlaceOfBirth(w.getBirthPlace());
        vm.setType(w.getType());
        vm.setNumber(w.getNumber());
        vm.setExpired(DateUtils.asLocalDate((Date)w.getExpired()));
        vm.setCitizenship(w.getCitizenship());
        vm.setIssueCounty(w.getOriginCountry());
        vm.setIssueDate(DateUtils.asLocalDate((Date)w.getIssued()));
        vm.setIssueOrganization(w.getIssueOrganization());
        vm.setCorrelationId(w.getCorrelationId());
        return vm;
    }

    static void fromVM(PersonPassportsMainPanelVM full, Person model) {
        model.getPassports().clear();
        full.getPassports().stream().map(PersonPassportsTileHelper::fromVM).forEach(w -> w.unwrap((Collection)model.getPassports()));
    }

    static PersonPassportWrapper fromVM(PersonPassportVM vm) {
        PersonPassportWrapper w = new PersonPassportWrapper();
        w.setUidLatin(vm.getUidLatin());
        w.setUidCyrillic(vm.getUidCyrillic());
        w.setLastNameLatin(vm.getLastNameLatin());
        w.setLastNameCyrillic(vm.getLastNameCyrillic());
        w.setFirstNameLatin(vm.getFirstNameLatin());
        w.setFirstNameCyrillic(vm.getFirstNameCyrillic());
        w.setSecondNameLatin(vm.getSecondNameLatin());
        w.setSecondNameCyrillic(vm.getSecondNameCyrillic());
        w.setMiddleNameLatin(vm.getMiddleNameLatin());
        w.setMiddleNameCyrillic(vm.getMiddleNameCyrillic());
        w.setGender(vm.getGender());
        w.setBirthday(DateUtils.asDate((LocalDate)vm.getBirthDate()));
        w.setBirthPlace(vm.getPlaceOfBirth());
        w.setType(vm.getType());
        w.setNumber(vm.getNumber());
        w.setExpired(DateUtils.asDate((LocalDate)vm.getExpired()));
        w.setCitizenship(vm.getCitizenship());
        w.setOriginCountry(vm.getIssueCounty());
        w.setIssued(DateUtils.asDate((LocalDate)vm.getIssueDate()));
        w.setIssueOrganization(vm.getIssueOrganization());
        w.setCorrelationId(vm.getCorrelationId());
        return w;
    }

    public static Supplier<DictListParameters> getDictListParameters() {
        return () -> {
            DictListParameters result = DictHandler.forDictClass(Country.class).getStandardListParameters().copy();
            result.getSearchCriterions().add(new DictQuery.SearchCriterion("codeVariantsKey", new Object[]{CodeSystem.IATA.name()}));
            result.getSearchCriterions().add(new DictQuery.SearchCriterion("codeVariantsKey", new Object[]{CodeSystem.CRT.name()}));
            return result;
        };
    }
}

