/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonAirPreferencesPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonBonusCardAviaVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonBonusCardCarVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonBonusCardHotelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonBonusCardRailwayVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonBonusCardsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonDiscountCardAviaVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonDiscountCardsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonHotelPreferencesPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPreferredSuppliersPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPrivilegeMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrierReference;
import com.gridnine.xtrip.common.model.profile.AirPreferences;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.AirlineDiscountCard;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.HotelPreferences;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PreferredSuppliers;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.stream.Collectors;

public final class PersonPrivilegeTileHelper {
    private PersonPrivilegeTileHelper() {
    }

    static void toVM(Person model, PersonPrivilegeMainPanelVM privilegeFull) {
        PersonPrivilegeTileHelper.toVMBonusCards(model, privilegeFull.getBonusCard());
        PersonPrivilegeTileHelper.toVMPreferredSuppliers(model.getPreferredSuppliers(), privilegeFull.getPreferredSuppliers());
        PersonPrivilegeTileHelper.toVMDiscountCards(model, privilegeFull.getDiscountCard());
    }

    static void toVMBonusCards(Person model, PersonBonusCardsPanelVM full) {
        VMHelper.transfer(model.getAirlineBonusCards(), full.getAvia(), card -> new PersonBonusCardAviaVM(), (card, vm) -> {
            vm.setOwner(card.getNameOnCard());
            vm.setNumber(card.getNumber());
            vm.setAirline(card.getAirline());
        });
        VMHelper.transfer(model.getRailwayBonusCards(), full.getRailway(), card -> new PersonBonusCardRailwayVM(), (card, vm) -> {
            vm.setNumber(card.getNumber());
            vm.setCarrier((DictionaryReference)(card.getRailwayCarrierCode() == null ? null : new RailwayCarrierReference(card.getRailwayCarrierCode())));
        });
        VMHelper.transfer(model.getHotelBonusCards(), full.getHotel(), card -> new PersonBonusCardHotelVM(), (card, vm) -> {
            vm.setNumber(card.getNumber());
            vm.setBrand(card.getHotelBrand());
        });
        VMHelper.transfer(model.getCarBonusCards(), full.getCar(), card -> new PersonBonusCardCarVM(), (card, vm) -> {
            vm.setNumber(card.getNumber());
            vm.setSupplier(card.getCarSupplier());
        });
    }

    private static void toVMPreferredSuppliers(PreferredSuppliers preferredSuppliers, PersonPreferredSuppliersPanelVM preferredSuppliersVM) {
        if (preferredSuppliers != null) {
            VMHelper.transfer(preferredSuppliers.getAirPreferences(), preferredSuppliersVM.getAirlines(), preference -> new PersonAirPreferencesPanelVM(), (preference, vm) -> vm.setSupplier(preference.getSupplier()));
            VMHelper.transfer(preferredSuppliers.getHotelPreferences(), preferredSuppliersVM.getHotels(), preference -> new PersonHotelPreferencesPanelVM(), (preference, vm) -> vm.setSupplier(preference.getSupplier()));
        }
    }

    static void toVMDiscountCards(Person model, PersonDiscountCardsPanelVM full) {
        VMHelper.transfer(model.getAirlineDiscountCards(), full.getAvia(), card -> new PersonDiscountCardAviaVM(), (card, vm) -> {
            vm.setCode(card.getCode());
            vm.setNumber(card.getNumber());
            vm.setAirline(card.getAirline());
            vm.setStartDate(DateUtils.asLocalDate((Date)card.getStartDate()));
            vm.setEndDate(DateUtils.asLocalDate((Date)card.getEndDate()));
        });
    }

    static void fromVM(PersonPrivilegeMainPanelVM privilegeFull, Person model) {
        PersonPrivilegeTileHelper.fromVMBonusCards(privilegeFull.getBonusCard(), model);
        if (model.getPreferredSuppliers() == null) {
            model.setPreferredSuppliers(new PreferredSuppliers());
        }
        PersonPrivilegeTileHelper.fromVMPreferredSuppliers(privilegeFull.getPreferredSuppliers(), model.getPreferredSuppliers());
        PersonPrivilegeTileHelper.fromVMDiscountCards(privilegeFull.getDiscountCard(), model);
    }

    static void fromVMBonusCards(PersonBonusCardsPanelVM full, Person model) {
        VMHelper.transfer(full.getAvia().stream().filter(card -> TextUtil.nonBlank((String)card.getNumber())).collect(Collectors.toList()), model.getAirlineBonusCards(), vm -> new AirlineBonusCard(), (vm, card) -> {
            card.setNameOnCard(vm.getOwner());
            card.setNumber(vm.getNumber());
            card.setAirline(vm.getAirline());
        });
        VMHelper.transfer(full.getRailway(), model.getRailwayBonusCards(), vm -> new RailwayBonusCard(), (vm, card) -> {
            card.setNumber(vm.getNumber());
            card.setRailwayCarrierCode(vm.getCarrier() == null ? null : vm.getCarrier().getCode());
        });
        VMHelper.transfer(full.getHotel(), model.getHotelBonusCards(), vm -> new HotelBonusCard(), (vm, card) -> {
            card.setNumber(vm.getNumber());
            card.setHotelBrand(vm.getBrand());
        });
        VMHelper.transfer(full.getCar(), model.getCarBonusCards(), vm -> new CarBonusCard(), (vm, card) -> {
            card.setNumber(vm.getNumber());
            card.setCarSupplier(vm.getSupplier());
        });
    }

    private static void fromVMPreferredSuppliers(PersonPreferredSuppliersPanelVM preferredSuppliersVM, PreferredSuppliers preferredSuppliers) {
        VMHelper.transfer(preferredSuppliersVM.getAirlines(), preferredSuppliers.getAirPreferences(), vm -> new AirPreferences(), (vm, preference) -> preference.setSupplier(vm.getSupplier()));
        VMHelper.transfer(preferredSuppliersVM.getHotels(), preferredSuppliers.getHotelPreferences(), vm -> new HotelPreferences(), (vm, preference) -> preference.setSupplier(vm.getSupplier()));
    }

    static void fromVMDiscountCards(PersonDiscountCardsPanelVM full, Person model) {
        VMHelper.transfer(full.getAvia(), model.getAirlineDiscountCards(), vm -> new AirlineDiscountCard(), (vm, card) -> {
            card.setCode(vm.getCode());
            card.setNumber(vm.getNumber());
            card.setAirline(vm.getAirline());
            card.setStartDate(DateUtils.asDate((LocalDate)vm.getStartDate()));
            card.setEndDate(DateUtils.asDate((LocalDate)vm.getEndDate()));
        });
    }
}

