/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonPCCSabreIDVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSPLoadMessagesVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSPSyncMessagesVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSabreSyncPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSabreSyncParamVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

final class PersonSabreSyncTileHelper {
    private PersonSabreSyncTileHelper() {
    }

    static void toVM(Person model, PersonSabreSyncPanelVM full) {
        VMHelper.transfer(model.getSabreProfilesPccSettings(), full.getSyncParams(), param -> new PersonSabreSyncParamVM(), (param, vm) -> {
            vm.setPassword(param.getPassword());
            vm.setPcc(param.getPcc());
            vm.setDescription(param.getDescription());
        });
        full.getSyncResult().setLastSyncStatus(model.getSabreProfilesLastSyncStatus());
        full.getSyncResult().setLastAttemptSyncDate(DateUtils.asLocalDateTime((Date)model.getSabreProfilesLastSyncAttemptDate()));
        full.getSyncResult().setLastSuccessSyncDate(DateUtils.asLocalDateTime((Date)model.getSabreProfilesLastSyncDate()));
        full.getSyncResult().setLastOperationType(model.getSabreProfilesLastOperationType());
        full.getSyncResult().setSabreProfilesLastLoadDate(DateUtils.asLocalDateTime((Date)model.getSabreProfilesLastLoadDate()));
        full.getSyncResult().setSabreProfilesLastLoadAttemptDate(DateUtils.asLocalDateTime((Date)model.getSabreProfilesLastLoadAttemptDate()));
        full.getSyncResult().setSabreProfilesLastLoadStatus(model.getSabreProfilesLastLoadStatus());
        full.getSyncResult().setSabreProfilesLastLoadOperationType(model.getSabreProfilesLastLoadOperationType());
        VMHelper.transfer(model.getSabreProfilesUniqueIDs(), full.getSabreID(), md -> new PersonPCCSabreIDVM(), (md, vm) -> {
            vm.setPcc(md.getPcc());
            vm.setSabreID(md.getUniqueID());
            vm.setProfileName(md.getProfileName());
        });
        List messages = full.getSyncMessages();
        messages.clear();
        model.getSabreProfilesMessages().forEach(msg -> {
            PersonSPSyncMessagesVM msgVM = new PersonSPSyncMessagesVM();
            msgVM.setMessageType(msg.getType().toString());
            if (msg.getMessage() != null) {
                msgVM.setMessageBody(msg.getMessage().toString());
            }
            msgVM.getDetails().setType(msg.getType());
            msgVM.getDetails().setMessage(msg.getMessage().toString());
            msgVM.getDetails().setDetails(msg.getDetails());
            messages.add(msgVM);
        });
        List loadMessages = full.getSabreProfilesLoadMessages();
        loadMessages.clear();
        model.getSabreProfilesLoadMessages().forEach(msg -> {
            PersonSPLoadMessagesVM msgVM = new PersonSPLoadMessagesVM();
            msgVM.setMessageType(msg.getType().toString());
            if (msg.getMessage() != null) {
                msgVM.setMessageBody(msg.getMessage().toString());
            }
            msgVM.getDetails().setType(msg.getType());
            msgVM.getDetails().setMessage(msg.getMessage().toString());
            msgVM.getDetails().setDetails(msg.getDetails());
            loadMessages.add(msgVM);
        });
    }

    static void fromVM(PersonSabreSyncPanelVM full, Person model) {
        List syncParamVM = full.getSyncParams().stream().filter(param -> TextUtil.nonBlank((String)param.getPcc()) || TextUtil.nonBlank((String)param.getPassword())).collect(Collectors.toList());
        VMHelper.transfer(syncParamVM, model.getSabreProfilesPccSettings(), vm -> new SabreProfilesPccSettings(), (vm, param) -> {
            param.setPcc(vm.getPcc());
            param.setPassword(vm.getPassword());
            param.setDescription(vm.getDescription());
        });
    }
}

