/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.profile.CardPanel;
import com.gridnine.xtrip.client.fx.model.profile.CardsMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonGeneralParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpace;
import com.gridnine.xtrip.client.fx.standard.helpers.CardsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.PCIDSSService;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public enum PersonCardsTileAction implements TileAction<Node, CardsMainPanel>
{
    ADD{

        public String getName(Tile<Node, CardsMainPanel> tile) {
            return Messages.Add_Card;
        }

        public String getDescription(Tile<Node, CardsMainPanel> tile) {
            return Messages.Add_Card;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, CardsMainPanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null) {
                isEnabled = !((PersonGeneralParametersPanel)((PersonMainPanel)((PersonSpace)pane.getEditor()).getMainTile().getFullNode()).getGeneralCard().getContent()).getFirstNameNode().getViewState().isImmutable();
            }
            return isEnabled;
        }

        public void execute(Control source, Tile<Node, CardsMainPanel> tile, boolean alt) {
            RootEntityPane context = RootEntityPane.lookup((Node)tile.getFullNode());
            PCIDSSServerExchangeSettings settings = Prefetched.getData().getPCIDSSServerExchangeSettings();
            if (!context.isDataChanged()) {
                this.getDialogForAddCard(context, settings, source);
            } else {
                Dialog dialog = new Dialog();
                dialog.setTitle(Messages.Confirmation_required).setMessage(Messages.Must_save_the_changes).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> Notifications.get().submitTask(() -> {
                    context.saveData();
                    FxUtil.waitForFxThread(() -> this.getDialogForAddCard(context, settings, source));
                }, Messages.Saving)).show((Node)source);
            }
        }

        private void getDialogForAddCard(RootEntityPane<?, ?> context, PCIDSSServerExchangeSettings settings, Control source) {
            CardPanel dialogContainer = CardsHelper.getNewCardPanel();
            StringBuilder nameOnCard = this.getNameOnCard(context);
            dialogContainer.getOwnerNode().setValue(nameOnCard.length() > 0 ? nameOnCard.toString().toUpperCase() : null);
            VBox body = new VBox(new Node[]{dialogContainer});
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Adding_New_Card).setBody((Node)body).setAutoClose(false).setExpandToParent(true).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Save_Card_And_Open_Browser, () -> {
                body.getChildren().removeAll((Collection)body.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                List<String> listMessage = CardsHelper.validateData(dialogContainer);
                if (!listMessage.isEmpty()) {
                    listMessage.forEach(message -> body.getChildren().add(0, (Object)MessagePane.error((String)message)));
                    return;
                }
                ((ExpandedGroupsWidget)((CardsMainPanel)((PersonSpace)context.getEditor()).getCardsTile().getFullNode()).getCardsCard().getContent()).getViews().add((Object)dialogContainer);
                try {
                    Notifications.get().submitTask(() -> ((RootEntityPane)context).saveData(), Messages.Saving);
                    EntityReference ref = context.getData().getContainer().toReference();
                    Card shortcutCard = CardsHelper.getShortcutCardFromView(dialogContainer);
                    CardsHelper.getAddressAndOpenWeb(settings, shortcutCard, ref);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                dialog.close();
            }).show((Node)source);
        }

        private StringBuilder getNameOnCard(RootEntityPane<?, ?> context) {
            String lastName;
            StringBuilder nameOnCard = new StringBuilder();
            if (context == null) {
                return nameOnCard;
            }
            PersonGeneralParametersPanel generalPanel = (PersonGeneralParametersPanel)((PersonMainPanel)((PersonSpace)context.getEditor()).getMainTile().getFullNode()).getGeneralCard().getContent();
            String firstName = L10nStringHelper.getValue((L10nString)generalPanel.getFirstNameNode().getValue(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
            if (!TextUtil.isBlank((String)firstName)) {
                if (nameOnCard.length() > 0) {
                    nameOnCard.append(" ");
                }
                nameOnCard.append(firstName.trim());
            }
            if (!TextUtil.isBlank((String)(lastName = L10nStringHelper.getValue((L10nString)generalPanel.getLastNameNode().getValue(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true)))) {
                if (nameOnCard.length() > 0) {
                    nameOnCard.append(" ");
                }
                nameOnCard.append(lastName.trim());
            }
            return nameOnCard;
        }
    }
    ,
    DELETE{

        public String getName(Tile<Node, CardsMainPanel> tile) {
            return Messages.Delete_Card;
        }

        public String getDescription(Tile<Node, CardsMainPanel> tile) {
            return Messages.Delete_Card;
        }

        public double getWeight() {
            return 2.0;
        }

        public boolean isEnabled(Tile<Node, CardsMainPanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            if (pane == null || ((ExpandedGroupsWidget)((CardsMainPanel)((PersonSpace)pane.getEditor()).getCardsTile().getFullNode()).getCardsCard().getContent()).getViews().isEmpty()) {
                return false;
            }
            return !((PersonGeneralParametersPanel)((PersonMainPanel)((PersonSpace)pane.getEditor()).getMainTile().getFullNode()).getGeneralCard().getContent()).getFirstNameNode().getViewState().isImmutable();
        }

        public void execute(Control source, Tile<Node, CardsMainPanel> tile, boolean alt) {
            RootEntityPane rootPane = RootEntityPane.lookup((Node)tile.getFullNode());
            PersonSpace personSpace = (PersonSpace)rootPane.getEditor();
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Confirmation_required).setMessage(Messages.Deleting_card_will_save_your_profile_changes).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Continue, () -> {
                ComboBoxWidget<String> widget = CardsHelper.getWidgetForCard((ObservableList<CardPanel>)((ExpandedGroupsWidget)((CardsMainPanel)personSpace.getCardsTile().getFullNode()).getCardsCard().getContent()).getViews());
                new LightDialog().setTitle(Messages.Select_the_card_to_be_deleted).setBody(widget).setActionAvailability((BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).setActionHandler(() -> {
                    String uid = (String)widget.getValue();
                    ObservableList listCardVM = ((ExpandedGroupsWidget)((CardsMainPanel)personSpace.getCardsTile().getFullNode()).getCardsCard().getContent()).getViews();
                    Iterator itr = listCardVM.iterator();
                    Card card = null;
                    while (itr.hasNext()) {
                        CardPanel cardVM = (CardPanel)itr.next();
                        if (!cardVM.getUidNode().getValue().equals(uid)) continue;
                        card = CardsHelper.getShortcutCardFromView(cardVM);
                        itr.remove();
                    }
                    Card shortCard = card;
                    PCIDSSServerExchangeSettings setting = Prefetched.getData().getPCIDSSServerExchangeSettings();
                    try {
                        Notifications.get().submitTask(() -> {
                            ServiceInvocationContext sic = ServiceInvocationContext.get();
                            RpcServiceManager rsm = RpcServiceManager.get();
                            PCIDSSService service = (PCIDSSService)rsm.getService(PCIDSSService.class);
                            Card updatedCard = service.updateCard(sic, shortCard, setting, rootPane.getData().getContainer().toReference());
                            try {
                                service.deleteCard(sic, updatedCard, setting, rootPane.getData().getContainer().toReference());
                            }
                            catch (Exception e1) {
                                ErrorHandler.handle((Throwable)e1);
                            }
                        }, Messages.Deleting_card);
                        Notifications.get().submitTask(() -> ((RootEntityPane)rootPane).saveData(), Messages.Saving_Object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).show((Region)source);
            }).show((Node)source);
        }
    }
    ,
    SYNC{

        public String getName(Tile<Node, CardsMainPanel> tile) {
            return Messages.Synchronize_cards_with_CIR;
        }

        public String getDescription(Tile<Node, CardsMainPanel> tile) {
            return Messages.Synchronization_of_cards_with_CIR;
        }

        public double getWeight() {
            return 3.0;
        }

        public boolean isEnabled(Tile<Node, CardsMainPanel> tile) {
            return true;
        }

        public void execute(Control source, Tile<Node, CardsMainPanel> tile, boolean alt) {
            RootEntityPane context = RootEntityPane.lookup((Node)tile.getFullNode());
            PCIDSSServerExchangeSettings settings = Prefetched.getData().getPCIDSSServerExchangeSettings();
            if (!context.isDataChanged()) {
                Notifications.get().submitTask(() -> {
                    this.updateCard(tile, settings, context.getData().getContainer().toReference());
                    context.saveData();
                }, Messages.Retrieving_data_from_CIR);
            } else {
                Dialog dialog = new Dialog();
                dialog.setTitle(Messages.Confirmation_required).setMessage(Messages.Must_save_the_changes).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> Notifications.get().submitTask(() -> {
                    context.saveData();
                    this.updateCard(tile, settings, context.getData().getContainer().toReference());
                    context.saveData();
                }, Messages.Retrieving_data_from_CIR)).show(tile.getFullNode());
            }
        }

        private void updateCard(Tile<Node, CardsMainPanel> tile, PCIDSSServerExchangeSettings settings, EntityReference<?> ref) throws Exception {
            class DataItem {
                CardPanel panel;
                Card card;

                DataItem() {
                }
            }
            ArrayList items = new ArrayList();
            FxUtil.waitForFxThread(() -> {
                for (CardPanel cardPanel : ((ExpandedGroupsWidget)((CardsMainPanel)tile.getFullNode()).getCardsCard().getContent()).getViews()) {
                    DataItem item = new DataItem();
                    item.panel = cardPanel;
                    item.card = CardsHelper.getShortcutCardFromView(cardPanel);
                    items.add(item);
                }
            });
            ArrayList<Message> errors = new ArrayList<Message>();
            for (DataItem item : items) {
                try {
                    ServiceInvocationContext sic = ServiceInvocationContext.get();
                    RpcServiceManager rsm = RpcServiceManager.get();
                    PCIDSSService service = (PCIDSSService)rsm.getService(PCIDSSService.class);
                    boolean cardUpdated = false;
                    try {
                        item.card = service.updateCard(sic, item.card, settings, ref);
                        cardUpdated = true;
                    }
                    catch (Exception e) {
                        errors.add(MessageHelper.createExceptonMessage((String)Messages.Updating_card_error, (Throwable)e, (Object[])new Object[]{TextUtil.objToNotNullString((Object)item.card.getVendor()), TextUtil.objToNotNullString((Object)item.card.getNumber()), item.card.getExpiration() != null ? new SimpleDateFormat("mmYY").format(item.card.getExpiration()) : "", TextUtil.objToNotNullString((Object)item.card.getNameOnCard())}));
                    }
                    if (!cardUpdated) continue;
                    FxUtil.waitForFxThread(() -> {
                        item.panel.getCirUidNode().setValue(item.card.getCirUid());
                        item.panel.getNumberNode().setValue(item.card.getNumber());
                        item.panel.getNumberCell().setHidden(false);
                        item.panel.getExpirationDateNode().readData((Object)new ValueHolder((Object)DateUtils.asLocalDate((Date)item.card.getExpiration())));
                        item.panel.getOwnerNode().setValue(item.card.getNameOnCard());
                    });
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
            if (!errors.isEmpty()) {
                Notifications.get().showMessages(errors);
            }
        }
    };

}

