/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.PersonBalanceDataVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonBalanceFilterContainer;
import com.gridnine.xtrip.client.fx.model.profile.PersonBalanceSummaryFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonBalanceSummaryPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpace;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpaceController;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceProperties;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceResult;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.scene.Node;
import javafx.util.Pair;

public class PersonFilterableDataViewHandler
extends FilterableDataViewHandler<PersonBalanceDataVM, PersonBalanceFilterContainer> {
    private static final int DEFAULT_LIMIT = 40;
    private int offset;
    private final PersonSpaceController controller;
    private final PersonBalanceSummaryFullPanel balanceSummary;

    protected PersonFilterableDataViewHandler(PersonBalanceSummaryFullPanel balanceSummary, PersonSpaceController controller) {
        super(() -> PersonFilterableDataViewHandler.createBalanceFilterPanel(controller.getView()), true);
        this.controller = controller;
        this.balanceSummary = balanceSummary;
    }

    private static PersonBalanceFilterContainer createBalanceFilterPanel(PersonSpace space) {
        PersonBalanceFilterContainer filterPanel = new PersonBalanceFilterContainer(false);
        filterPanel.getClientNode().setItemsSupplier(() -> {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            EntityContainer ctr = RootEntityPane.lookup((Node)space).getData().getContainer();
            if (ctr != null) {
                for (PersonEmployment empl : ((Person)ctr.getEntity()).getEmployments()) {
                    result.add(empl.getOrganization());
                }
            }
            return result;
        }, false);
        LocalDate startDateTime = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toLocalDate();
        filterPanel.getStartDateNode().setValue(startDateTime.minusDays(1L));
        filterPanel.getEndDateNode().setValue(startDateTime);
        return filterPanel;
    }

    protected int getLimit() {
        return 40;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected void reloadData(int newOffset, List<Pair<String, SortOrder>> sorting) {
        FinanceServiceProperties prop = new FinanceServiceProperties();
        EntityContainer container = RootEntityPane.lookup((Node)this.controller.getView()).getData().getContainer();
        if (container == null || container.getRevision() == null) {
            return;
        }
        PersonBalanceFilterContainer filterPane = (PersonBalanceFilterContainer)this.getFilteringPane().getContent();
        if (filterPane.getClientNode().getValue() == null) {
            Notifications.get().showFlashNotification(Messages.Must_specify_the_client, "");
            return;
        }
        if (filterPane.getEndDateNode().getValue() == null || filterPane.getStartDateNode().getValue() == null) {
            Notifications.get().showFlashNotification(Messages.Must_specify_dates, "");
            return;
        }
        prop.setClientRef(filterPane.getClientNode().getValue());
        prop.setAgentRef(container.toReference());
        prop.setStartDate(DateUtils.asDate((LocalDate)filterPane.getStartDateNode().getValue()));
        prop.setEndDate(DateUtils.asDate((LocalDate)filterPane.getEndDateNode().getValue()));
        prop.setOffset(newOffset);
        prop.setLimit(this.getLimit());
        prop.setCreditLimitInfo(((Person)container.getEntity()).getFinanceRestrictions().getCreditLimits());
        Notifications.get().submitTask(() -> {
            FinanceService financeService = (FinanceService)RpcServiceManager.get().getService(FinanceService.class);
            FinanceServiceResult result = financeService.loadDataForPerson(ServiceInvocationContext.get(), prop);
            FxUtil.waitForFxThread(() -> {
                this.offset = result.getOffset();
                this.getData().setAll(this.filingDataView(result));
            });
        }, this.getMutex());
    }

    private List<PersonBalanceDataVM> filingDataView(FinanceServiceResult result) {
        ArrayList<PersonBalanceDataVM> dataVM = new ArrayList<PersonBalanceDataVM>();
        if (result == null || result.getTransactionData() == null) {
            return dataVM;
        }
        this.fillingDataBalancePanel(result);
        result.getTransactionData().forEach(index -> {
            PersonBalanceDataVM view = new PersonBalanceDataVM();
            view.setClientReference(index.getClientRef());
            if (index.getTransactionSum() != null) {
                Money amount = new Money();
                amount.setValue(index.getTransactionSum());
                amount.setCurrency(index.getCurrency());
                view.setAmountValue(amount);
            }
            view.setAgencyReference(index.getAgencyRef());
            view.setClient(index.getClientRef().getCaption());
            view.setPaymentTypeValue(index.getPaymentType());
            view.setContractValue(index.getContractType());
            view.setDateValue(DateUtils.asLocalDateTime((Date)index.getTransactionDate()));
            view.setCategoryValue(index.getCategory());
            view.setAgentReference(index.getAgentRef());
            view.setTypeValue(index.getType());
            view.setOrderReference(index.getReferencedEntity());
            view.setStatusValue(index.getStatus());
            view.setSource(index.getSourceBillingTransaction());
            if (index.getAgencyRef() != null) {
                view.setAgency(index.getAgencyRef().getCaption());
            }
            if (index.getType() != null) {
                view.setType(index.getType().toString());
            }
            if (index.getStatus() != null) {
                view.setStatus(index.getStatus().toString());
            }
            if (index.getCategory() != null && index.getCategory().equals((Object)BillingTransactionCategory.DEBIT) && index.getTransactionSum() != null && index.getTransactionSum() != null) {
                view.setDebit((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
            }
            if (index.getCategory() != null && index.getCategory().equals((Object)BillingTransactionCategory.CREDIT) && index.getTransactionSum() != null && index.getTransactionSum() != null) {
                view.setCredit((String)StandardRenderers.PRICE.apply((Object)index.getTransactionSum()));
            }
            if (index.getPaymentType() != null) {
                view.setPaymentMethod(index.getPaymentType().toString());
            }
            if (index.getTransactionDate() != null) {
                view.setDate((String)StandardRenderers.DATE_TIME.apply((Object)index.getTransactionDate()));
            }
            if (index.getAgentRef() != null) {
                view.setAgent(index.getAgentRef().getCaption());
            }
            if (index.getReferencedEntity() != null) {
                view.setOrder(index.getReferencedEntity().getCaption());
                view.setOrderReference(index.getReferencedEntity());
            }
            view.setDescription(index.getDescription());
            dataVM.add(view);
        });
        return dataVM;
    }

    private void fillingDataBalancePanel(FinanceServiceResult result) {
        PersonBalanceSummaryPanel balancePanel = (PersonBalanceSummaryPanel)this.balanceSummary.getBalanceSummaryCard().getContent();
        balancePanel.getAvailableAmountNode().getAvailableAmountValueNode().setValue((Number)result.getAvailableAmount());
        balancePanel.getBalanceAmountNode().getBalanceAmountValueNode().setValue((Number)result.getBalanceAmount());
        balancePanel.getEndDateBalanceAmountNode().getEndDateBalanceAmountValueNode().setValue((Number)result.getEndDateBalanceAmount());
        balancePanel.getStartDateBalanceAmountNode().getStartDateBalanceAmountValueNode().setValue((Number)result.getStartDateBalanceAmount());
        balancePanel.getDebitAmountCell().setHidden(true);
        balancePanel.getCreditAmountCell().setHidden(true);
    }
}

