/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.PersonCostCodeVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonUdidValuePanelController;
import com.gridnine.xtrip.client.fx.standard.custom.SabreMaskWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class PersonUdidsControllerInterceptor
extends ControllerInterceptor<PersonCostCodeVM, PersonUdidValuePanelController> {
    private static final StringConverter<CostCodeProperties> COST_CODE_PROPERTIES_CONVERTER = new StringConverter<CostCodeProperties>(){

        public String toString(CostCodeProperties prop) {
            return prop != null ? prop.getName() : null;
        }

        public CostCodeProperties fromString(String string) {
            return null;
        }
    };

    protected Class<PersonUdidValuePanelController> getControllerClass() {
        return PersonUdidValuePanelController.class;
    }

    protected void onCreate(PersonUdidValuePanelController controller) {
        EntityBoxWidget organizationWidget = controller.getView().getOrganizationNode();
        organizationWidget.setLive(true);
        organizationWidget.setItemsSupplier(() -> {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            EntityContainer ctr = RootEntityPane.lookup((Node)controller.getView()).getData().getContainer();
            if (ctr != null) {
                for (PersonEmployment empl : ((Person)ctr.getEntity()).getEmployments()) {
                    result.add(empl.getOrganization());
                }
            }
            return result;
        }, false);
        ComboBoxWidget propertyWidget = controller.getView().getPropertyNode();
        propertyWidget.setConverter(COST_CODE_PROPERTIES_CONVERTER);
        propertyWidget.setLive(true);
        propertyWidget.setAsync(true);
        propertyWidget.setItemsSupplier(() -> {
            Organization organization = PersonUdidsControllerInterceptor.loadOrganization((EntityBoxWidget<Organization>)organizationWidget);
            return organization != null ? organization.getCostCodeProperties() : Collections.emptyList();
        });
        SabreMaskWidget valueNode = (SabreMaskWidget)controller.getView().getValueNode();
        valueNode.setMaskSupplier(() -> {
            CostCodeProperties selectedProperties = (CostCodeProperties)propertyWidget.getValue();
            return selectedProperties != null ? selectedProperties.getMask() : null;
        });
        if (!controller.isReadonly()) {
            TextFieldWidget localValueNode = controller.getView().getLocalValueNode();
            TextFieldWidget englishValueNode = controller.getView().getEnglishValueNode();
            PersonUdidsControllerInterceptor.updateValueNodes(valueNode, localValueNode, englishValueNode, (EntityBoxWidget<Organization>)organizationWidget, (ComboBoxWidget<CostCodeProperties>)propertyWidget, false);
            propertyWidget.valueProperty().addListener((ChangeListener)new CostCodePropertiesListener(valueNode, localValueNode, englishValueNode, (EntityBoxWidget<Organization>)organizationWidget, (ComboBoxWidget<CostCodeProperties>)propertyWidget));
        }
        organizationWidget.valueProperty().addListener((s, oldValue, newValue) -> {
            if (!MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                propertyWidget.setValue(null);
                propertyWidget.redraw();
            }
        });
    }

    protected void beforeReadData(PersonUdidValuePanelController controller, PersonCostCodeVM model) {
        EntityBoxWidget organizationWidget = controller.getView().getOrganizationNode();
        ComboBoxWidget propertyWidget = controller.getView().getPropertyNode();
        SabreMaskWidget valueNode = (SabreMaskWidget)controller.getView().getValueNode();
        TextFieldWidget localValueNode = controller.getView().getLocalValueNode();
        TextFieldWidget englishValueNode = controller.getView().getEnglishValueNode();
        propertyWidget.valueProperty().removeListener((ChangeListener)new CostCodePropertiesListener(valueNode, localValueNode, englishValueNode, (EntityBoxWidget<Organization>)organizationWidget, (ComboBoxWidget<CostCodeProperties>)propertyWidget));
    }

    protected void afterReadData(PersonUdidValuePanelController controller, PersonCostCodeVM model) {
        if (!controller.isReadonly()) {
            EntityBoxWidget organizationWidget = controller.getView().getOrganizationNode();
            ComboBoxWidget propertyWidget = controller.getView().getPropertyNode();
            SabreMaskWidget valueNode = (SabreMaskWidget)controller.getView().getValueNode();
            TextFieldWidget localValueNode = controller.getView().getLocalValueNode();
            TextFieldWidget englishValueNode = controller.getView().getEnglishValueNode();
            PersonUdidsControllerInterceptor.updateValueNodes(valueNode, localValueNode, englishValueNode, (EntityBoxWidget<Organization>)organizationWidget, (ComboBoxWidget<CostCodeProperties>)propertyWidget, false);
            propertyWidget.valueProperty().addListener((ChangeListener)new CostCodePropertiesListener(valueNode, localValueNode, englishValueNode, (EntityBoxWidget<Organization>)organizationWidget, (ComboBoxWidget<CostCodeProperties>)propertyWidget));
        }
    }

    private static Organization loadOrganization(EntityBoxWidget<Organization> orgWidget) {
        EntityReference orgReference = orgWidget.getValue();
        if (orgReference == null) {
            return null;
        }
        try {
            EntityContainer orgContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), orgReference);
            if (orgContainer != null) {
                return (Organization)orgContainer.getEntity();
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return null;
    }

    private static Map<String, CostCode> getCostCodeValues(EntityBoxWidget<Organization> orgWidget, ComboBoxWidget<CostCodeProperties> propertyWidget) {
        CostCodeProperties selectedProperties = (CostCodeProperties)propertyWidget.getValue();
        if (selectedProperties == null) {
            return Collections.emptyMap();
        }
        Organization organization = PersonUdidsControllerInterceptor.loadOrganization(orgWidget);
        if (organization == null) {
            return Collections.emptyMap();
        }
        return organization.getCostCodes().stream().filter(costCode -> selectedProperties.equals((Object)costCode.getCostCodeProperties())).filter(costCode -> TextUtil.nonBlank((String)costCode.getValue())).collect(Collectors.toMap(costCode -> costCode.getValue().trim(), costCode -> costCode, (first, second) -> first, LinkedHashMap::new));
    }

    private static void updateValueNodes(SabreMaskWidget valueNode, TextFieldWidget localValueNode, TextFieldWidget englishValueNode, EntityBoxWidget<Organization> organizationWidget, ComboBoxWidget<CostCodeProperties> propertyWidget, boolean clearValuesIfHaveValuesSupplier) {
        Notifications.get().submitTask(() -> {
            Map<String, CostCode> costCodeValues = PersonUdidsControllerInterceptor.getCostCodeValues(organizationWidget, propertyWidget);
            FxUtil.waitForFxThread(() -> {
                if (costCodeValues.isEmpty()) {
                    valueNode.setItemsSupplier(null);
                    valueNode.setPopupListener(null);
                    localValueNode.setDisable(false);
                    englishValueNode.setDisable(false);
                } else {
                    if (clearValuesIfHaveValuesSupplier) {
                        valueNode.setValue(null);
                        localValueNode.setValue(null);
                        englishValueNode.setValue(null);
                    }
                    valueNode.setItemsSupplier(() -> new ArrayList(costCodeValues.keySet()));
                    valueNode.setPopupListener((oldVal, newVal) -> {
                        CostCode newCostCode = (CostCode)costCodeValues.get(newVal);
                        if (newCostCode == null) {
                            localValueNode.setValue(null);
                            englishValueNode.setValue(null);
                        } else {
                            localValueNode.setValue(newCostCode.getLocalValue());
                            englishValueNode.setValue(newCostCode.getEnglishValue());
                        }
                    });
                    localValueNode.setDisable(true);
                    englishValueNode.setDisable(true);
                }
            });
        }, ObservableMutex.lookup(propertyWidget));
    }

    protected void validateData(PersonUdidValuePanelController controller, List<Message> messages) {
        if (((EntityBoxWidget)controller.getView().getOrganizationCell().getPayload()).getValue() == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.emptyOrganization, (Object[])new Object[0]));
        } else if (((ComboBoxWidget)controller.getView().getPropertyCell().getPayload()).getValue() == null) {
            String organization = ((EntityBoxWidget)controller.getView().getOrganizationCell().getPayload()).getValue().getCaption();
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.emptyUDIDTypeAtPersonPanel, (Object[])new Object[]{organization}));
        }
    }

    private static class CostCodePropertiesListener
    implements ChangeListener<CostCodeProperties> {
        private final SabreMaskWidget valueNode;
        private final TextFieldWidget localValueNode;
        private final TextFieldWidget englishValueNode;
        private final EntityBoxWidget<Organization> organizationWidget;
        private final ComboBoxWidget<CostCodeProperties> propertyWidget;

        CostCodePropertiesListener(SabreMaskWidget valueNode, TextFieldWidget localValueNode, TextFieldWidget englishValueNode, EntityBoxWidget<Organization> organizationWidget, ComboBoxWidget<CostCodeProperties> propertyWidget) {
            this.valueNode = Objects.requireNonNull(valueNode);
            this.localValueNode = Objects.requireNonNull(localValueNode);
            this.englishValueNode = Objects.requireNonNull(englishValueNode);
            this.organizationWidget = Objects.requireNonNull(organizationWidget);
            this.propertyWidget = Objects.requireNonNull(propertyWidget);
        }

        public void changed(ObservableValue<? extends CostCodeProperties> observable, CostCodeProperties oldValue, CostCodeProperties newValue) {
            if (newValue != null) {
                if (this.valueNode.hasItemsSupplier()) {
                    this.valueNode.setValue(null);
                    this.localValueNode.setValue(null);
                    this.englishValueNode.setValue(null);
                }
                PersonUdidsControllerInterceptor.updateValueNodes(this.valueNode, this.localValueNode, this.englishValueNode, (EntityBoxWidget<Organization>)this.organizationWidget, (ComboBoxWidget<CostCodeProperties>)this.propertyWidget, true);
            } else {
                this.valueNode.setItemsSupplier(null);
                this.valueNode.setPopupListener(null);
                this.localValueNode.setDisable(false);
                this.englishValueNode.setDisable(false);
            }
        }

        public int hashCode() {
            return this.propertyWidget.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CostCodePropertiesListener && this.propertyWidget.equals(((CostCodePropertiesListener)obj).propertyWidget);
        }
    }
}

