/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.PersonVisaPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonVisaPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonVisaVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.notifications.EventNotificationTool;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import javafx.scene.Node;

public class PersonVisaPanelControllerInterceptor
extends ControllerInterceptor<PersonVisaVM, PersonVisaPanelController> {
    protected Class<PersonVisaPanelController> getControllerClass() {
        return PersonVisaPanelController.class;
    }

    protected void onCreate(PersonVisaPanelController controller) {
        final PersonVisaPanel view = controller.getView();
        view.getIssueCityNode().valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            view.getIssueCountryNode().setDisable(true);
            Notifications.get().submitTask(() -> {
                GeoLocation city = (GeoLocation)((DictService)RpcServiceManager.get().getService(DictService.class)).load(ServiceInvocationContext.get(), newValue);
                FxUtil.submitToFxThread(() -> {
                    if (city != null) {
                        view.getIssueCountryNode().valueProperty().set((Object)city.getCountry());
                    }
                    view.getIssueCountryNode().setDisable(false);
                });
            }, ObservableMutex.lookup((Node)view));
        });
        view.getIssueCityNode().setListParametersSupplier(() -> {
            DictListParameters dictListParameters = new DictListParameters();
            TableColumnSettings codes = new TableColumnSettings();
            codes.setId(BaseDictionary.Property.codeVariants.name());
            codes.setDisplayName(Messages.Codes);
            codes.setRenderer((Renderer)StandardRenderers.CODE_VARIANTS);
            TableColumnSettings names = new TableColumnSettings();
            names.setId(BaseDictionary.Property.translations.name());
            names.setDisplayName(Messages.Names);
            names.setRenderer((Renderer)StandardRenderers.TRANSLATIONS);
            TableColumnSettings country = new TableColumnSettings();
            country.setId(GeoLocation.Property.country.name());
            country.setDisplayName(Messages.Country);
            country.setRenderer((Renderer)StandardRenderers.GENERIC);
            dictListParameters.getColumns().add(codes);
            dictListParameters.getColumns().add(names);
            dictListParameters.getColumns().add(country);
            dictListParameters.getFilters().add(codes);
            dictListParameters.getFilters().add(names);
            dictListParameters.getFilters().add(country);
            dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.type.name(), new Object[]{LocationType.CITY}));
            if (view.getIssueCountryNode().valueProperty().get() != null) {
                dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.country.name(), new Object[]{view.getIssueCountryNode().valueProperty().get()}));
            }
            return dictListParameters;
        });
        EventNotificationTool.install(view.getEndDateNode(), new EventNotificationTool.Configurator(){

            @Override
            public String getTitle() {
                return Messages.Notification_visa_title;
            }

            @Override
            public String getText() {
                StringBuilder buf = new StringBuilder();
                if (!TextUtil.isBlank((String)view.getNumberNode().getValue())) {
                    buf.append(Messages.Notification_visa_number).append(": ").append(view.getNumberNode().getValue()).append('\n');
                }
                if (view.getActionCountryNode().getValue() != null) {
                    buf.append(Messages.Notification_visa_action_country).append(": ").append(view.getActionCountryNode().getValue()).append('\n');
                }
                if (view.getStartDateNode().getValue() != null) {
                    buf.append(Messages.Notification_visa_start_date).append(": ").append((String)StandardRenderers.DATE.apply((Object)view.getStartDateNode().getValue())).append('\n');
                }
                if (view.getIssueCountryNode().getValue() != null) {
                    buf.append(Messages.Notification_visa_issue_country).append(": ").append(view.getIssueCountryNode().getValue()).append('\n');
                }
                if (view.getIssueDateNode().getValue() != null) {
                    buf.append(Messages.Notification_visa_issue_date).append(": ").append((String)StandardRenderers.DATE.apply((Object)view.getIssueDateNode().getValue())).append('\n');
                }
                return buf.toString();
            }

            @Override
            public EntityReference<?> getNestedEntityReference() {
                Object uid = view.getProperties().get((Object)"model-uid");
                String caption = !TextUtil.isBlank((String)view.getNumberNode().getValue()) ? Messages.getNotification_visa_reference(view.getNumberNode().getValue()) : Messages.Notification_visa_reference_stub;
                return uid == null ? null : new EntityReference(uid.toString(), Passport.class, caption);
            }
        });
    }
}

