/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.personal.data;

import com.gridnine.xtrip.client.fx.core.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ActionColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.SuperColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataOrganizationRequestSearchDataPanelController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataOrganizationRequestTileSpaceController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonEmailVM;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonNameVM;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonPassportVM;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonPhoneVM;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonRequestSearchDataPanelController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonRequestTileSpaceController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataPersonVM;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataRequestMainPanelController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataRequestOverviewPanelController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataRequestSearchResultsCardsPanelController;
import com.gridnine.xtrip.client.fx.model.personal.data.PersonalDataRequestSearchResultsItemVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ContactsPaneHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PersonalDataRequestControllerInterceptorHelper {
    private static final List<PersonalDataRequestStatus> searchDataEditableStatuses = Arrays.asList(PersonalDataRequestStatus.NEW, PersonalDataRequestStatus.SEARCH_INTERRUPTED, PersonalDataRequestStatus.SEARCH_FAILED, PersonalDataRequestStatus.SEARCH_DONE);
    private static final List<PersonalDataRequestStatus> searchResutsEditableStatuses = Arrays.asList(PersonalDataRequestStatus.SEARCH_DONE);

    static void configurePerson(PersonalDataPersonRequestTileSpaceController controller, BooleanSupplier supplier) {
        PersonalDataRequestControllerInterceptorHelper.configureOverview(controller.getOverview(), controller.getMainFull(), controller.getSearchResultsFull());
        PersonalDataRequestControllerInterceptorHelper.configureMain(controller.getOverview(), controller.getMainFull(), controller.getSearchResultsFull());
        controller.getMainFull().getMain().getView().getStatusNode().valueProperty().addListener((observable, oldValue, newValue) -> controller.getSearchDataFull().getSearchData().setNotEditable(!searchDataEditableStatuses.contains(newValue)));
        PersonalDataRequestControllerInterceptorHelper.configurePersonSearchData(controller.getSearchDataFull().getSearchData(), supplier);
        PersonalDataRequestControllerInterceptorHelper.configureSearchResults(controller.getOverview(), controller.getMainFull(), controller.getSearchResultsFull());
    }

    public static void configurePersonSearchData(PersonalDataPersonRequestSearchDataPanelController controller, BooleanSupplier supplier) {
        controller.getView().getPersonNode().valueProperty().addListener((observable, oldVaule, newValue) -> {
            if (supplier.getAsBoolean()) {
                return;
            }
            controller.getView().getNamesNode().removeAllRows();
            controller.getView().getPassportsNode().removeAllRows();
            controller.getView().getPhonesNode().removeAllRows();
            controller.getView().getEmailsNode().removeAllRows();
            if (newValue != null) {
                Notifications.get().submitTask(() -> {
                    Person person = Optional.ofNullable(((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), newValue)).map(item -> (Person)item.getEntity()).orElse(null);
                    if (person != null) {
                        ArrayList<PersonalDataPersonNameVM> nameRows = new ArrayList<PersonalDataPersonNameVM>();
                        ArrayList<PersonalDataPersonPassportVM> passportRows = new ArrayList<PersonalDataPersonPassportVM>();
                        ArrayList<PersonalDataPersonPhoneVM> phoneRows = new ArrayList<PersonalDataPersonPhoneVM>();
                        ArrayList<PersonalDataPersonEmailVM> emailRows = new ArrayList<PersonalDataPersonEmailVM>();
                        Set locales = Stream.concat(person.getLastName().getValues().keySet().stream(), Stream.concat(person.getFirstName().getValues().keySet().stream(), person.getMiddleName().getValues().keySet().stream())).collect(Collectors.toSet());
                        for (Locale locale : locales) {
                            String lastName = (String)person.getLastName().getValues().get(locale);
                            String firstName = (String)person.getFirstName().getValues().get(locale);
                            String middleName = (String)person.getMiddleName().getValues().get(locale);
                            lastName = !TextUtil.isBlank((String)lastName) ? lastName.trim() : null;
                            firstName = !TextUtil.isBlank((String)firstName) ? firstName.trim() : null;
                            String string = middleName = !TextUtil.isBlank((String)middleName) ? middleName.trim() : null;
                            if (lastName == null && firstName == null && middleName == null) continue;
                            PersonalDataPersonNameVM nameRow = new PersonalDataPersonNameVM();
                            if (lastName != null) {
                                nameRow.setLastName(lastName);
                            }
                            if (firstName != null) {
                                nameRow.setFirstName(firstName);
                            }
                            if (middleName != null) {
                                nameRow.setMiddleName(middleName);
                            }
                            nameRows.add(nameRow);
                        }
                        for (Object passport : person.getPassports()) {
                            PersonalDataPersonPassportVM passportRow = new PersonalDataPersonPassportVM();
                            String number = passport.getNumber();
                            number = !TextUtil.isBlank((String)number) ? number.trim() : null;
                            if (number == null) continue;
                            passportRow.setNumber(number);
                            passportRows.add(passportRow);
                        }
                        List phones = person.getCommunications().stream().filter(item -> ContactsPaneHelper.PHONE_TYPES.contains(item.getType())).collect(Collectors.toList());
                        for (Communication phone : phones) {
                            PersonalDataPersonPhoneVM phoneRow = new PersonalDataPersonPhoneVM();
                            String number = ProfileHelper.buildFullPhoneNumber((Communication)phone);
                            number = !TextUtil.isBlank((String)number) ? number.trim() : null;
                            if (number == null) continue;
                            phoneRow.setNumber(number);
                            phoneRows.add(phoneRow);
                        }
                        List emails = person.getCommunications().stream().filter(item -> item.getType() == CommunicationType.EMAIL).collect(Collectors.toList());
                        for (Communication email : emails) {
                            PersonalDataPersonEmailVM emailRow = new PersonalDataPersonEmailVM();
                            String address = email.getSense();
                            address = !TextUtil.isBlank((String)address) ? address.trim() : null;
                            if (address == null) continue;
                            emailRow.setAddress(address);
                            emailRows.add(emailRow);
                        }
                        FxUtil.submitToFxThread(() -> {
                            controller.getNames().readData((Object)nameRows);
                            controller.getPassports().readData((Object)passportRows);
                            controller.getPhones().readData((Object)phoneRows);
                            controller.getEmails().readData((Object)emailRows);
                        });
                    }
                }, Messages.Loading_data);
            }
        });
    }

    static void configureOrganization(PersonalDataOrganizationRequestTileSpaceController controller, BooleanSupplier supplier) {
        PersonalDataRequestControllerInterceptorHelper.configureOverview(controller.getOverview(), controller.getMainFull(), controller.getSearchResultsFull());
        PersonalDataRequestControllerInterceptorHelper.configureMain(controller.getOverview(), controller.getMainFull(), controller.getSearchResultsFull());
        Card searchDataCard = controller.getSearchDataFull().getView().getSearchDataCard();
        searchDataCard.setAdaptiveHeight(true);
        controller.getMainFull().getMain().getView().getStatusNode().valueProperty().addListener((observable, oldValue, newValue) -> controller.getSearchDataFull().getSearchData().setNotEditable(!searchDataEditableStatuses.contains(newValue)));
        PersonalDataRequestControllerInterceptorHelper.configureOrganizationSearchData(controller.getSearchDataFull().getSearchData(), supplier);
        PersonalDataRequestControllerInterceptorHelper.configureSearchResults(controller.getOverview(), controller.getMainFull(), controller.getSearchResultsFull());
    }

    public static void configureOrganizationSearchData(PersonalDataOrganizationRequestSearchDataPanelController controller, BooleanSupplier supplier) {
        BigTableWidget searchDataTable = (BigTableWidget)controller.getPersons().getView();
        ActionColumn linkColumn = (ActionColumn)searchDataTable.getColumn("link");
        searchDataTable.setControlButtonsAvailability(ControlsPane.NONE);
        linkColumn.setActionHandler(event -> EntityEditorHelper.navigate((EntityReference)((PersonalDataPersonVM)event.getItem()).getPerson(), (boolean)false));
        controller.getView().getOrganizationNode().valueProperty().addListener((observable, oldVaule, newValue) -> {
            if (supplier.getAsBoolean()) {
                return;
            }
            controller.getView().getPersonsNode().removeAllRows();
            if (newValue != null) {
                Notifications.get().submitTask(() -> {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)newValue.getUid()));
                    List persons = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), PersonIndex.class, query).stream().map(item -> item.getSource()).distinct().sorted(MiscUtil.comparator(item -> item.toString())).collect(Collectors.toList());
                    ArrayList<PersonalDataPersonVM> personRows = new ArrayList<PersonalDataPersonVM>();
                    for (EntityReference person : persons) {
                        PersonalDataPersonVM personRow = new PersonalDataPersonVM();
                        personRow.setPerson(person);
                        personRow.setLink(person.toString());
                        personRow.setSearch(true);
                        personRows.add(personRow);
                    }
                    FxUtil.submitToFxThread(() -> controller.getPersons().readData((Object)personRows));
                }, Messages.Loading_data);
            }
        });
    }

    static void configureOverview(PersonalDataRequestOverviewPanelController overviewController, PersonalDataRequestMainPanelController mainController, PersonalDataRequestSearchResultsCardsPanelController searchResultsController) {
    }

    static void configureMain(PersonalDataRequestOverviewPanelController overviewController, PersonalDataRequestMainPanelController mainController, PersonalDataRequestSearchResultsCardsPanelController searchResultsController) {
    }

    static void configureSearchResults(PersonalDataRequestOverviewPanelController overviewController, PersonalDataRequestMainPanelController mainController, PersonalDataRequestSearchResultsCardsPanelController searchResultsController) {
        Card searchResultsCard = searchResultsController.getView().getSearchResultsCard();
        searchResultsCard.setAdaptiveHeight(true);
        BigTableWidget searchResultsTable = (BigTableWidget)searchResultsController.getSearchResults().getView();
        ActionColumn linkColumn = (ActionColumn)searchResultsTable.getColumn("link");
        SuperColumn itemsColumn = (SuperColumn)searchResultsTable.getColumn("items");
        searchResultsTable.setControlButtonsAvailability(ControlsPane.NONE);
        linkColumn.setActionHandler(event -> EntityEditorHelper.navigate((EntityReference)((PersonalDataRequestSearchResultsItemVM)event.getItem()).getEntity(), (boolean)false));
        itemsColumn.setActionTextSupplier((index, panel) -> null);
        itemsColumn.setInfoLabelConfigurator((rowIndex, rowData, label) -> {
            int matchCount = (int)rowData.getItems().getContent().stream().filter(item -> item.getExpected() != null && item.getActual() != null).count();
            int totalCount = rowData.getItems().getContent().size();
            label.setText(String.format("%s/%s", String.valueOf(matchCount), String.valueOf(totalCount)));
            label.setStyle(String.format("-fx-background-color: linear-gradient(to right, %s, transparent)", FxUtil.getColor((double)((double)matchCount / (double)totalCount))));
        });
        itemsColumn.setPopupConfigurator((row, dialog, view) -> dialog.setTitle(Messages.personalDataRequestSearchResultItems));
        mainController.getMain().getView().getStatusNode().valueProperty().addListener((observable, oldValue, newValue) -> searchResultsController.getSearchResults().setNotEditable(!searchResutsEditableStatuses.contains(newValue)));
    }
}

