/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint;

import com.gridnine.xtrip.client.fx.model.profile.SalesPointAddressVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointContactsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPhoneVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSiteVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import java.util.ArrayList;

final class SalesPointContactsTileHelper {
    private SalesPointContactsTileHelper() {
    }

    static void toVM(SalesPoint model, SalesPointContactsPanelVM full) {
        full.getPreferredLanguage().setPrefLang(model.getPreferredLocale());
        ArrayList<Communication> phones = new ArrayList<Communication>();
        ArrayList<Communication> emails = new ArrayList<Communication>();
        ArrayList<Communication> sites = new ArrayList<Communication>();
        block4: for (Communication cmm2 : model.getCommunications()) {
            if (cmm2.getType() == null) {
                phones.add(cmm2);
                continue;
            }
            switch (cmm2.getType()) {
                case EMAIL: {
                    emails.add(cmm2);
                    continue block4;
                }
                case WEB: {
                    sites.add(cmm2);
                    continue block4;
                }
            }
            phones.add(cmm2);
        }
        VMHelper.transfer(phones, full.getPhones(), cmm -> new SalesPointPhoneVM(), (cmm, vm) -> {
            vm.setType(cmm.getType());
            vm.setCountryCode(cmm.getCountryCode());
            vm.setCityCode(cmm.getCityCode());
            vm.setPhoneNumber(cmm.getSense());
            vm.setInternalNumber(cmm.getInternalNumber());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(emails, full.getEmails(), cmm -> new SalesPointEmailVM(), (cmm, vm) -> {
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(sites, full.getSites(), cmm -> new SalesPointSiteVM(), (cmm, vm) -> {
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(model.getAddresses(), full.getAddresses(), cmm -> new SalesPointAddressVM(), (address, vm) -> {
            vm.setType(address.getAddressType());
            vm.setZip(address.getZip());
            vm.setCountry(address.getCountry());
            vm.setCity(address.getCity());
            vm.setStreet(address.getAddress());
            vm.setBuilding(address.getHouse());
            vm.setOffice(address.getOffice());
            vm.getExtraMain().setRegion(address.getRegion());
            vm.getExtraMain().setDistrict(address.getDistrict());
            vm.getExtraMain().setLocality(address.getTown());
            vm.getExtraMain().setPoBox(address.getPoBox());
            vm.getExtraMain().setHousing(address.getHousing());
            vm.getExtraMain().setBuilding(address.getBuilding());
            vm.getExtraMain().setPavilion(address.getPavilion());
            vm.getExtraMain().setFlat(address.getFlat());
            vm.getExtraMain().setMetroStation(address.getMetroStation());
            vm.getExtraMain().setDeliveryRegion(address.getDeliveryRegion());
            vm.getExtraMain().setComment(address.getNotes());
        });
    }

    static void fromVM(SalesPointContactsPanelVM full, SalesPoint model) {
        model.setPreferredLocale(full.getPreferredLanguage().getPrefLang());
        ArrayList communicationVMs = new ArrayList();
        communicationVMs.addAll(full.getPhones());
        communicationVMs.addAll(full.getEmails());
        communicationVMs.addAll(full.getSites());
        VMHelper.transfer(communicationVMs, model.getCommunications(), vm -> new Communication(), (vm, cmm) -> {
            if (vm instanceof SalesPointPhoneVM) {
                SalesPointPhoneVM phoneVm = (SalesPointPhoneVM)vm;
                cmm.setType(phoneVm.getType());
                cmm.setCountryCode(phoneVm.getCountryCode());
                cmm.setCityCode(phoneVm.getCityCode());
                cmm.setSense(phoneVm.getPhoneNumber());
                cmm.setInternalNumber(phoneVm.getInternalNumber());
                cmm.setRemarks(phoneVm.getNotes());
            } else if (vm instanceof SalesPointEmailVM) {
                SalesPointEmailVM emailVm = (SalesPointEmailVM)vm;
                cmm.setType(CommunicationType.EMAIL);
                cmm.setSense(emailVm.getAddress());
                cmm.setRemarks(emailVm.getNotes());
            } else if (vm instanceof SalesPointSiteVM) {
                SalesPointSiteVM siteVm = (SalesPointSiteVM)vm;
                cmm.setType(CommunicationType.WEB);
                cmm.setSense(siteVm.getAddress());
                cmm.setRemarks(siteVm.getNotes());
            }
        });
        VMHelper.transfer(full.getAddresses(), model.getAddresses(), vm -> new Address(), (vm, address) -> {
            address.setAddressType(vm.getType());
            address.setZip(vm.getZip());
            address.setCountry(vm.getCountry());
            address.setCity(vm.getCity());
            address.setRegion(vm.getExtraMain().getRegion());
            VMHelper.fromVM(vm.getStreet(), address.getAddress());
            VMHelper.fromVM(vm.getBuilding(), address.getHouse());
            VMHelper.fromVM(vm.getOffice(), address.getOffice());
            VMHelper.fromVM(vm.getExtraMain().getDistrict(), address.getDistrict());
            VMHelper.fromVM(vm.getExtraMain().getLocality(), address.getTown());
            VMHelper.fromVM(vm.getExtraMain().getHousing(), address.getHousing());
            VMHelper.fromVM(vm.getExtraMain().getBuilding(), address.getBuilding());
            VMHelper.fromVM(vm.getExtraMain().getPavilion(), address.getPavilion());
            VMHelper.fromVM(vm.getExtraMain().getFlat(), address.getFlat());
            address.setPoBox(vm.getExtraMain().getPoBox());
            address.setMetroStation(vm.getExtraMain().getMetroStation());
            address.setDeliveryRegion(vm.getExtraMain().getDeliveryRegion());
            address.setNotes(vm.getExtraMain().getComment());
            model.getAddresses().add(address);
        });
    }
}

