/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint;

import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccParameterVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointPccsTableItemVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointTerminalAddressesVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameter;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

final class SalesPointPccsTileHelper {
    private SalesPointPccsTileHelper() {
    }

    static void toVM(SalesPoint model, List<SalesPointPccsTableItemVM> full) {
        VMHelper.transfer(model.getPccs(), full, pcc -> new SalesPointPccsTableItemVM(), (pcc, vm) -> {
            vm.getFullData().setBookingSystem(pcc.getGdsName());
            vm.getFullData().setId(pcc.getCode());
            vm.getFullData().setAgency(pcc.getAgency());
            vm.getFullData().setStartDate(DateUtils.asLocalDate((Date)pcc.getOpened()));
            vm.getFullData().setEndDate(DateUtils.asLocalDate((Date)pcc.getClosed()));
            vm.getFullData().setCurrency(pcc.getCurrency());
            vm.getFullData().setComment(pcc.getNotes());
            VMHelper.transfer(pcc.getParameters(), vm.getFullData().getParameters(), pccParameter -> {
                SalesPointPccParameterVM pccParameterVM = new SalesPointPccParameterVM();
                pccParameterVM.setName(pccParameter.getName());
                pccParameterVM.setValue(pccParameter.getValue());
                return pccParameterVM;
            });
            VMHelper.transfer(pcc.getTerminalNames(), vm.getFullData().getTerminalAddresses(), terminalName -> {
                SalesPointTerminalAddressesVM result = new SalesPointTerminalAddressesVM();
                result.setValue(terminalName);
                return result;
            });
            vm.setBookingSystem(pcc.getGdsName() == null ? null : pcc.getGdsName().toString());
            vm.setId(pcc.getCode());
            vm.setStartDate((String)StandardRenderers.DATE.apply((Object)pcc.getOpened()));
            vm.setEndDate((String)StandardRenderers.DATE.apply((Object)pcc.getClosed()));
        });
    }

    static void fromVM(List<SalesPointPccsTableItemVM> full, SalesPoint model) {
        VMHelper.transfer(full, model.getPccs(), vm -> new Pcc(), (vm, pcc) -> {
            pcc.setGdsName(vm.getFullData().getBookingSystem());
            pcc.setCode(vm.getFullData().getId());
            pcc.setAgency(vm.getFullData().getAgency());
            pcc.setOpened(DateUtils.asDate((LocalDate)vm.getFullData().getStartDate()));
            pcc.setClosed(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)vm.getFullData().getEndDate())));
            pcc.setCurrency(vm.getFullData().getCurrency());
            pcc.setNotes(vm.getFullData().getComment());
            VMHelper.transfer(vm.getFullData().getParameters(), pcc.getParameters(), pccParameterVM -> {
                PccParameter pccParameter = new PccParameter();
                pccParameter.setName(pccParameterVM.getName());
                pccParameter.setValue(pccParameterVM.getValue());
                return pccParameter;
            });
            VMHelper.transfer(vm.getFullData().getTerminalAddresses(), pcc.getTerminalNames(), SalesPointTerminalAddressesVM::getValue);
        });
    }
}

