/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.settings.BookingArchiveSettingsControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.settings.model.AdditionalEntityVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.BookingArchiveSettingsContainer;
import com.gridnine.xtrip.client.fx.standard.settings.model.BookingArchiveSettingsContainerController;
import com.gridnine.xtrip.client.fx.standard.settings.model.BookingArchiveSettingsContainerVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.archive.BookingArchiveSettings;
import com.gridnine.xtrip.common.model.booking.archive.RelatedObjectQueryData;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class BookingArchiveSettingsHandler
extends BaseRootEntityHandler<BookingArchiveSettings, Void, BookingArchiveSettingsContainerVM, BookingArchiveSettingsContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<BookingArchiveSettings, Void>, BookingArchiveSettingsContainerVM>> toVM, List<BiConsumer<BookingArchiveSettingsContainerVM, DataTransferPackage<BookingArchiveSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new BookingArchiveSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            BookingArchiveSettings model = (BookingArchiveSettings)dtp.getContainer().getEntity();
            vm.getGeneralPanel().setTitle(model.getName());
            vm.getGeneralPanel().setObjectClassName((IndexType)MetaRegistry.get().getIndexes().get(model.getBookingQueryData().getIndexClassName()));
            if (model.getBookingQueryData().getIndexClassName() != null) {
                try {
                    vm.getCriterions().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getBookingQueryData().getCriterions(), Class.forName(model.getBookingQueryData().getIndexClassName()), Collections.emptyList()));
                }
                catch (ClassNotFoundException e) {
                    ErrorHandler.handle((Throwable)e);
                }
                vm.getCriterions().setRestrictionId(model.getBookingQueryData().getIndexClassName());
            }
            ArrayList<AdditionalEntityVM> list = new ArrayList<AdditionalEntityVM>();
            Map handlersIdAndDisplayNameMap = Prefetched.getData().getArchivedBookingHandlersIdAndDisplayName();
            for (Map.Entry handlerData : handlersIdAndDisplayNameMap.entrySet()) {
                AdditionalEntityVM ent = new AdditionalEntityVM();
                ent.setHandlerId((String)handlerData.getValue());
                for (RelatedObjectQueryData data : model.getAdditionalEntities()) {
                    if (!data.getHandlerId().equals(handlerData.getKey())) continue;
                    ent.setInclude(data.isInclude());
                }
                list.add(ent);
            }
            vm.getRelated().addAll(list);
        });
        fromVM.add((vm, dtp) -> {
            BookingArchiveSettings model = (BookingArchiveSettings)dtp.getContainer().getEntity();
            model.setName(vm.getGeneralPanel().getTitle());
            model.getBookingQueryData().setIndexClassName(vm.getGeneralPanel().getObjectClassName() == null ? null : vm.getGeneralPanel().getObjectClassName().getId());
            model.getBookingQueryData().getCriterions();
            model.getBookingQueryData().getCriterions().clear();
            if (vm.getCriterions().getRestrictionId() != null) {
                try {
                    model.getBookingQueryData().getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getCriterions().getRestrictions(), Class.forName(vm.getCriterions().getRestrictionId()), Collections.emptyList()));
                }
                catch (ClassNotFoundException e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
            model.getAdditionalEntities().clear();
            Map handlersIdAndDisplayNameMap = Prefetched.getData().getArchivedBookingHandlersIdAndDisplayName();
            vm.getRelated().forEach(entityVM -> {
                RelatedObjectQueryData relatedObjectQueryData = new RelatedObjectQueryData();
                for (Map.Entry handlerData : handlersIdAndDisplayNameMap.entrySet()) {
                    if (!entityVM.getHandlerId().equals(handlerData.getValue())) continue;
                    relatedObjectQueryData.setHandlerId((String)handlerData.getKey());
                }
                relatedObjectQueryData.setInclude(entityVM.isInclude());
                model.getAdditionalEntities().add(relatedObjectQueryData);
            });
        });
    }

    @Override
    protected ViewController<BookingArchiveSettingsContainer, BookingArchiveSettingsContainerVM> createSpaceController(boolean readonly) {
        return new BookingArchiveSettingsContainerController(readonly);
    }

    public Class<BookingArchiveSettings> getEntityClass() {
        return BookingArchiveSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected BookingArchiveSettingsContainerVM createVM() {
        return new BookingArchiveSettingsContainerVM();
    }
}

