/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.model.Payment1CParserSettingsContainer;
import com.gridnine.xtrip.client.fx.standard.settings.model.Payment1CParserSettingsContainerController;
import com.gridnine.xtrip.client.fx.standard.settings.model.Payment1CParserSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.PaymentSettingsTreeModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.PaymentSettingsTreeModelVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.StandardExchangeDocumentParserSettingsGrid;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.model.OtherBlankOwnersCreditBankTransferOrdersImportFilterType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;

class Payment1CParserSettingsControllerInterceptor
extends ControllerInterceptor<Payment1CParserSettingsContainerVM, Payment1CParserSettingsContainerController> {
    Payment1CParserSettingsControllerInterceptor() {
    }

    private TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>> createTableWidget(final ObservableList<EntityReference<Organization>> hiddenTableData) {
        return new TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>>(){
            private final TableWidget<ValueHolder<EntityReference<Organization>>> tableWidget = new TableWidget(false);
            {
                this.tableWidget.setItemsProvider(ValueHolder::new);
                this.tableWidget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
                EntityBoxWidgetColumn blankOwnersColumn = new EntityBoxWidgetColumn(Organization.class, ValueHolder::get, ValueHolder::set);
                ArrayList<EntityBoxWidgetColumn> columns = new ArrayList<EntityBoxWidgetColumn>();
                columns.add(blankOwnersColumn);
                blankOwnersColumn.setId("organization");
                blankOwnersColumn.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
                this.tableWidget.setColumns(columns);
                this.tableWidget.setOnRowsAction(this.getBlankOwnersTableListener());
            }

            private EventHandler<TableRowEvent> getBlankOwnersTableListener() {
                return event -> {
                    Collection blankOwnersTableData = this.getView().getRowsData();
                    if (TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                        EntityBoxWidgetColumn blankOwnersColumn = (EntityBoxWidgetColumn)this.tableWidget.getColumn("organization");
                        ((EntityBoxWidget)blankOwnersColumn.getWidget(event.getRowIndex().intValue())).valueProperty().addListener((obj, o, n) -> {
                            this.tableWidget.addRow(this.tableWidget.getRowsCount());
                            this.tableWidget.removeRow(this.tableWidget.getRowsCount() - 1);
                            Payment1CParserSettingsControllerInterceptor.this.updateHiddenTable(blankOwnersTableData, (ObservableList<EntityReference<Organization>>)hiddenTableData);
                        });
                    }
                    Payment1CParserSettingsControllerInterceptor.this.updateHiddenTable(blankOwnersTableData, (ObservableList<EntityReference<Organization>>)hiddenTableData);
                };
            }

            public TableWidget<ValueHolder<EntityReference<Organization>>> getView() {
                return this.tableWidget;
            }
        };
    }

    private void updateHiddenTable(Collection<ValueHolder<EntityReference<Organization>>> blankOwnersTableData, ObservableList<EntityReference<Organization>> hiddenTableData) {
        hiddenTableData.clear();
        blankOwnersTableData.stream().map(ValueHolder::get).collect(Collectors.toCollection(() -> hiddenTableData));
    }

    private void showTreeSelectionContent(Payment1CParserSettingsContainerController controller, TreeItem<String> selectedTreeItem, SimpleContainer<Node> contentContainer, TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>> tableWidgetController) {
        contentContainer.getChildren().clear();
        PaymentSettingsTreeModel hiddenContainer = controller.getPaymentSettingsTreeHidden().getView();
        PaymentSettingsTreeModelVM hiddenContainerVM = controller.getData().getPaymentSettingsTreeHidden();
        switch ((String)selectedTreeItem.getValue()) {
            case "U6": {
                GridContainer innerContainer = new GridContainer();
                TextFieldWidget dimensionWidget = new TextFieldWidget(false);
                dimensionWidget.setValue(hiddenContainerVM.getDimension());
                dimensionWidget.valueProperty().addListener((obj, o, n) -> this.setHiddenDimensionWidgetValue(hiddenContainer, (String)n));
                innerContainer.setAdaptive(true);
                innerContainer.getCells().add((Object)new GridCell(Messages.Subconto, (Node)dimensionWidget));
                contentContainer.getChildren().add((Object)innerContainer);
                break;
            }
            case "\u0414\u0440\u0443\u0433\u0438\u0435": {
                GridContainer innerContainer = new GridContainer();
                ComboBoxWidget filterTypeWidget = new ComboBoxWidget(false);
                filterTypeWidget.setValue((Object)hiddenContainerVM.getFilter());
                filterTypeWidget.setItemsSupplier(Suppliers.createEnumSupplier(OtherBlankOwnersCreditBankTransferOrdersImportFilterType.class));
                filterTypeWidget.valueProperty().addListener((obj, o, n) -> this.setHiddenFilterWidgetValue(hiddenContainer, (OtherBlankOwnersCreditBankTransferOrdersImportFilterType)n));
                innerContainer.setAdaptive(true);
                innerContainer.getCells().add((Object)new GridCell(Messages.Filter_type, (Node)filterTypeWidget));
                contentContainer.getChildren().add((Object)innerContainer);
                CardsContainer container = new CardsContainer();
                container.getCards().add((Object)new Card("blankOwners", UiCardsContainer.Style.EXPANDED, Messages.Letterhead_owners, tableWidgetController.getView()));
                contentContainer.getChildren().add((Object)container);
                break;
            }
        }
    }

    private void setHiddenFilterWidgetValue(PaymentSettingsTreeModel hiddenContainer, OtherBlankOwnersCreditBankTransferOrdersImportFilterType n) {
        hiddenContainer.getFilterNode().setValue((Object)n);
    }

    private void setHiddenDimensionWidgetValue(PaymentSettingsTreeModel hiddenContainer, String n) {
        hiddenContainer.getDimensionNode().setValue(n);
    }

    private TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>> createBlankOwnersTableWidget(ObservableList<EntityReference<Organization>> hiddenTableData) {
        TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>> tableWidgetController = this.createTableWidget(hiddenTableData);
        tableWidgetController.readData(this.from(hiddenTableData));
        return tableWidgetController;
    }

    private List<ValueHolder<EntityReference<Organization>>> from(ObservableList<EntityReference<Organization>> hiddenTableData) {
        return hiddenTableData.stream().map(this.toValueHolder()).collect(Collectors.toList());
    }

    private Function<EntityReference<Organization>, ValueHolder<EntityReference<Organization>>> toValueHolder() {
        return entityReference -> {
            ValueHolder valueHolder = new ValueHolder();
            valueHolder.set(entityReference);
            return valueHolder;
        };
    }

    private void hideConnectionCards(Payment1CParserSettingsContainer view) {
        view.getCards().forEach(card -> card.setHidden(true));
        view.getGeneralPanelCard().setHidden(false);
    }

    protected Class<Payment1CParserSettingsContainerController> getControllerClass() {
        return Payment1CParserSettingsContainerController.class;
    }

    protected void onCreate(Payment1CParserSettingsContainerController controller) {
        Payment1CParserSettingsContainer view = controller.getView();
        ((StandardExchangeDocumentParserSettingsGrid)view.getGeneralPanelCard().getContent()).getContractCell().setHidden(true);
        this.hideConnectionCards(view);
        this.initConnectionTypeNode(controller);
    }

    protected void afterReadData(Payment1CParserSettingsContainerController controller, Payment1CParserSettingsContainerVM model) {
        if (controller.getView().getCards().stream().noneMatch(card -> card.getId().equals("paymentSettings"))) {
            controller.getView().getCards().add((Object)new Card("paymentSettings", UiCardsContainer.Style.EXPANDED, Messages.Customize_the_processing_of_payment, (Node)this.createPaymentSettingsPanel(controller)));
        }
        PaymentSettingsTreeModelVM hiddenContainerVM = controller.getData().getPaymentSettingsTreeHidden();
        PaymentSettingsTreeModel hiddenContainer = controller.getPaymentSettingsTreeHidden().getView();
        GridContainer gridContainer = (GridContainer)controller.getView().getCards().stream().filter(card -> card.getId().equals("paymentSettings")).findFirst().get().getContent();
        TreeViewWrapper treeView = (TreeViewWrapper)gridContainer.getCells().stream().map(GridCell::getPayload).filter(node -> node instanceof TreeViewWrapper).findFirst().get();
        treeView.init(hiddenContainerVM, hiddenContainer);
    }

    private void initConnectionTypeNode(Payment1CParserSettingsContainerController controller) {
        ComboBoxWidget connectionTypeNode = controller.getGeneralPanel().getView().getConnectionTypeNode();
        connectionTypeNode.setNoNulls(true);
        connectionTypeNode.valueProperty().addListener((obj, o, newConnectionType) -> {
            Payment1CParserSettingsContainer view = controller.getView();
            switch (newConnectionType) {
                case FTP: {
                    view.getFTPConnectionSettingsCard().setHidden(false);
                    view.getHTTPConnectionSettingsCard().setHidden(true);
                    view.getFileConnectionSettingsCard().setHidden(true);
                    view.getSFTPConnectionSettingsCard().setHidden(true);
                    break;
                }
                case HTTP_HOTELBOOK: {
                    view.getFTPConnectionSettingsCard().setHidden(true);
                    view.getHTTPConnectionSettingsCard().setHidden(false);
                    view.getFileConnectionSettingsCard().setHidden(true);
                    view.getSFTPConnectionSettingsCard().setHidden(true);
                    break;
                }
                case FILE: {
                    view.getFTPConnectionSettingsCard().setHidden(true);
                    view.getHTTPConnectionSettingsCard().setHidden(true);
                    view.getFileConnectionSettingsCard().setHidden(false);
                    view.getSFTPConnectionSettingsCard().setHidden(true);
                    break;
                }
                case SFTP: {
                    view.getFTPConnectionSettingsCard().setHidden(true);
                    view.getHTTPConnectionSettingsCard().setHidden(true);
                    view.getFileConnectionSettingsCard().setHidden(true);
                    view.getSFTPConnectionSettingsCard().setHidden(false);
                }
            }
        });
    }

    private GridContainer createPaymentSettingsPanel(Payment1CParserSettingsContainerController controller) {
        SimpleContainer treeContentContainer = new SimpleContainer();
        ObservableList hiddenTableData = controller.getPaymentSettingsTreeHidden().getTable();
        TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>> blankOwnersTableWidgetController = this.createBlankOwnersTableWidget((ObservableList<EntityReference<Organization>>)hiddenTableData);
        TreeViewWrapper treeView = new TreeViewWrapper();
        GridContainer result = new GridContainer();
        result.getStyleClass().add((Object)"payment-1c-parser-settings");
        result.setColumnsCount(2);
        result.getCells().addAll((Object[])new GridCell[]{new GridCell((Node)treeView), new GridCell((Node)treeContentContainer)});
        treeView.getSelectionModel().getSelectedItems().addListener(this.getTreeSelectionListener(controller, (SimpleContainer<Node>)treeContentContainer, blankOwnersTableWidgetController));
        return result;
    }

    private ListChangeListener<TreeItem<String>> getTreeSelectionListener(Payment1CParserSettingsContainerController controller, SimpleContainer<Node> contentContainer, TableWidgetController<TableWidget<ValueHolder<EntityReference<Organization>>>, ValueHolder<EntityReference<Organization>>> tableWidgetController) {
        return listChangeListener -> this.showTreeSelectionContent(controller, (TreeItem<String>)((TreeItem)listChangeListener.getList().get(0)), contentContainer, tableWidgetController);
    }

    private class TreeViewWrapper
    extends TreeView<String> {
        final CheckBoxTreeItem<String> rootItem = new CheckBoxTreeItem((Object)"");
        final CheckBoxTreeItem<String> debitItem = new CheckBoxTreeItem((Object)Messages.Refill);
        final CheckBoxTreeItem<String> subAgentItem = new CheckBoxTreeItem((Object)Messages.Subagents);
        final CheckBoxTreeItem<String> customerItem = new CheckBoxTreeItem((Object)Messages.Clients);
        final CheckBoxTreeItem<String> u6Item = new CheckBoxTreeItem((Object)"U6");
        final CheckBoxTreeItem<String> otherItem = new CheckBoxTreeItem((Object)Messages.Others);
        final CheckBoxTreeItem<String> creditItem = new CheckBoxTreeItem((Object)Messages.Offs);
        final CheckBoxTreeItem<String> blankOwnerItem = new CheckBoxTreeItem((Object)Messages.Letterhead_owners);

        private TreeViewWrapper() {
        }

        public void init(PaymentSettingsTreeModelVM hiddenContainerVM, PaymentSettingsTreeModel hiddenContainer) {
            this.debitItem.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getDebitNode().setSelected(newValue.booleanValue()));
            this.subAgentItem.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getSubagentNode().setSelected(newValue.booleanValue()));
            this.customerItem.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getCustomerNode().setSelected(newValue.booleanValue()));
            this.u6Item.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getU6Node().setSelected(newValue.booleanValue()));
            this.otherItem.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getOtherNode().setSelected(newValue.booleanValue()));
            this.creditItem.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getCreditNode().setSelected(newValue.booleanValue()));
            this.blankOwnerItem.selectedProperty().addListener((observable, oldValue, newValue) -> hiddenContainer.getBlankOwnerItemNode().setSelected(newValue.booleanValue()));
            if (this.rootItem.getChildren().isEmpty()) {
                this.rootItem.getChildren().add(this.debitItem);
                this.rootItem.getChildren().add(this.creditItem);
                this.creditItem.getChildren().add(this.blankOwnerItem);
                this.creditItem.getChildren().add(this.subAgentItem);
                this.creditItem.getChildren().add(this.customerItem);
                this.blankOwnerItem.getChildren().add(this.u6Item);
                this.blankOwnerItem.getChildren().add(this.otherItem);
                this.rootItem.setExpanded(true);
                this.creditItem.setExpanded(true);
                this.blankOwnerItem.setExpanded(true);
            }
            this.debitItem.setSelected(hiddenContainerVM.isDebit());
            this.customerItem.setSelected(hiddenContainerVM.isCustomer());
            this.subAgentItem.setSelected(hiddenContainerVM.isSubagent());
            this.u6Item.setSelected(hiddenContainerVM.isU6());
            this.otherItem.setSelected(hiddenContainerVM.isOther());
            this.setRoot((TreeItem)this.rootItem);
            this.setShowRoot(false);
            this.setCellFactory(CheckBoxTreeCell.forTreeView());
        }
    }
}

