/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.KeyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainer;
import com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerController;
import com.gridnine.xtrip.client.fx.settings.model.PaymentCodeSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.system.model.PaymentCode;
import com.gridnine.xtrip.common.system.model.PaymentCodeSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class PaymentCodeSettingsHandler
extends BaseRootEntityHandler<PaymentCodeSettings, Void, com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM, PaymentCodeSettingsContainer> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<PaymentCodeSettings, Void>, com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM>> toVM, List<BiConsumer<com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM, DataTransferPackage<PaymentCodeSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new PaymentCodeSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            PaymentCodeSettings model = (PaymentCodeSettings)dtp.getContainer().getEntity();
            VMHelper.transfer(model.getPaymentCodes(), vm.getPaymentCodes(), settings -> new PaymentCodeSettingsContainerVM(), (settings, settingsVM) -> {
                settingsVM.setProductType(new Pair((Object)settings.getProductType(), (Object)settings.getUniversalProductDescription()));
                settingsVM.setCode(String.valueOf(settings.getCode()));
            });
        });
        fromVM.add((vm, dtp) -> {
            PaymentCodeSettings model = (PaymentCodeSettings)dtp.getContainer().getEntity();
            VMHelper.transfer(vm.getPaymentCodes().stream().filter(type -> type.getProductType() != null && TextUtil.nonBlank((String)type.getCode())).collect(Collectors.toList()), model.getPaymentCodes(), settings -> new PaymentCode(), (settingsVM, settings) -> {
                settings.setProductType((ProductType)settingsVM.getProductType().getKey());
                settings.setUniversalProductDescription((EntityReference)settingsVM.getProductType().getValue());
                settings.setCode(settingsVM.getCode());
            });
        });
    }

    @Override
    protected ViewController<PaymentCodeSettingsContainer, com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM> createSpaceController(boolean readonly) {
        return new PaymentCodeSettingsContainerController(readonly);
    }

    @Override
    protected com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM createVM() {
        return new com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM();
    }

    public Class<PaymentCodeSettings> getEntityClass() {
        return PaymentCodeSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    private static class PaymentCodeSettingsControllerInterceptor
    extends ControllerInterceptor<com.gridnine.xtrip.client.fx.model.system.PaymentCodeSettingsContainerVM, PaymentCodeSettingsContainerController> {
        private PaymentCodeSettingsControllerInterceptor() {
        }

        protected void onCreate(PaymentCodeSettingsContainerController controller) {
            KeyValueWidgetColumn productColumn = (KeyValueWidgetColumn)((TableWidget)controller.getPaymentCodes().getView()).getColumn("productType");
            productColumn.setKeysSupplier(Suppliers.createEnumSupplier(ProductType.class));
            productColumn.setRendererSupplier(key -> key == ProductType.MISC_PRODUCT ? StandardNodeRenderer.ENTITYBOX_UNIVERSAL_PRODUCT_DESCRIPTION : null);
        }

        protected Class<PaymentCodeSettingsContainerController> getControllerClass() {
            return PaymentCodeSettingsContainerController.class;
        }
    }
}

