/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.system.PersonCodeSettingsContainer;
import com.gridnine.xtrip.client.fx.model.system.PersonCodeSettingsContainerController;
import com.gridnine.xtrip.client.fx.model.system.PersonCodeSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.system.model.PersonCodeSettings;
import java.util.List;
import java.util.function.BiConsumer;

public class PersonCodeSettingsHandler
extends BaseRootEntityHandler<PersonCodeSettings, Void, PersonCodeSettingsContainerVM, PersonCodeSettingsContainer> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<PersonCodeSettings, Void>, PersonCodeSettingsContainerVM>> toVM, List<BiConsumer<PersonCodeSettingsContainerVM, DataTransferPackage<PersonCodeSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new PersonCodeSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            PersonCodeSettings model = (PersonCodeSettings)dtp.getContainer().getEntity();
            vm.setGenerateCode(model.isGenerateCode());
            vm.setPrefix(model.getPrefix());
            vm.setSuffix(model.getSuffix());
            vm.setDigitsCount(model.getDigitsCount());
        });
        fromVM.add((vm, dtp) -> {
            PersonCodeSettings model = (PersonCodeSettings)dtp.getContainer().getEntity();
            model.setGenerateCode(vm.isGenerateCode());
            model.setPrefix(vm.getPrefix());
            model.setSuffix(vm.getSuffix());
            model.setDigitsCount(vm.getDigitsCount());
        });
    }

    @Override
    protected ViewController<PersonCodeSettingsContainer, PersonCodeSettingsContainerVM> createSpaceController(boolean readonly) {
        return new PersonCodeSettingsContainerController(readonly);
    }

    @Override
    protected PersonCodeSettingsContainerVM createVM() {
        return new PersonCodeSettingsContainerVM();
    }

    public Class<PersonCodeSettings> getEntityClass() {
        return PersonCodeSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    private static class PersonCodeSettingsControllerInterceptor
    extends ControllerInterceptor<PersonCodeSettingsContainerVM, PersonCodeSettingsContainerController> {
        private PersonCodeSettingsControllerInterceptor() {
        }

        protected void onCreate(PersonCodeSettingsContainerController controller) {
            controller.getView().getDigitsCountNode().setValueValidator(value -> value > 0 && value <= 20);
        }

        protected Class<PersonCodeSettingsContainerController> getControllerClass() {
            return PersonCodeSettingsContainerController.class;
        }
    }
}

