/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.settings.ScheduledTaskSettingsMainPaneControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.settings.model.ScheduledTaskSettingsMainPaneVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.ScheduledTaskSettingsPane;
import com.gridnine.xtrip.client.fx.standard.settings.model.ScheduledTaskSettingsPaneController;
import com.gridnine.xtrip.client.fx.standard.settings.model.ScheduledTaskSettingsPaneVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.ScheduledTaskSettingsParameterVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class ScheduledTaskSettingsHandler
extends BaseRootEntityHandler<ScheduledTaskSettings, Void, ScheduledTaskSettingsPaneVM, ScheduledTaskSettingsPane> {
    public Class<ScheduledTaskSettings> getEntityClass() {
        return ScheduledTaskSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ScheduledTaskSettings, Void>, ScheduledTaskSettingsPaneVM>> toVM, List<BiConsumer<ScheduledTaskSettingsPaneVM, DataTransferPackage<ScheduledTaskSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ScheduledTaskSettingsMainPaneControllerInterceptor());
        toVM.add((dtp, vm) -> {
            ScheduledTaskSettings model = (ScheduledTaskSettings)dtp.getContainer().getEntity();
            ScheduledTaskSettingsMainPaneVM mainVM = vm.getMain();
            mainVM.setName(model.getName());
            mainVM.setJobClass(model.getJobClass());
            mainVM.setEnabled(model.isEnabled());
            mainVM.setLocal(model.isLocal());
            mainVM.setFixedNode(!TextUtil.isBlank((String)model.getInstallationId(), (boolean)false));
            mainVM.setInstallationId(model.getInstallationId());
            mainVM.setDelay(model.getDelay() == null ? null : Integer.valueOf(model.getDelay().intValue() / 1000));
            mainVM.setPeriodical(model.getPeriod() != null && model.getPeriod() > 0L);
            mainVM.setPeriod(model.getPeriod() == null ? null : Integer.valueOf(model.getPeriod().intValue() / 1000));
            mainVM.setCron(model.getCron());
            VMHelper.transfer(model.getDataMap(), vm.getParameters(), nv -> new ScheduledTaskSettingsParameterVM(), (nv, paramVM) -> {
                paramVM.setName(nv.getName());
                paramVM.setValue(nv.getValue());
            });
            vm.getParameters().sort((p1, p2) -> TextUtil.compare((String)p1.getName(), (String)p2.getName(), (boolean)false, (boolean)false));
        });
        fromVM.add((vm, dtp) -> {
            ScheduledTaskSettings model = (ScheduledTaskSettings)dtp.getContainer().getEntity();
            model.setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
            ScheduledTaskSettingsMainPaneVM data = vm.getMain();
            model.setName(data.getName());
            model.setJobClass(data.getJobClass());
            model.setEnabled(data.isEnabled());
            model.setLocal(data.isLocal());
            model.setInstallationId(data.isFixedNode() && !TextUtil.isBlank((String)data.getInstallationId()) ? data.getInstallationId() : null);
            model.setDelay(data.getDelay() == null ? null : Long.valueOf(data.getDelay() * 1000));
            if (data.isPeriodical()) {
                model.setPeriod(data.getPeriod() == null ? null : Long.valueOf(data.getPeriod() * 1000));
                model.setCron(null);
            } else {
                model.setPeriod(null);
                model.setCron(data.getCron());
            }
            ArrayList<ScheduledTaskSettingsParameterVM> params = new ArrayList<ScheduledTaskSettingsParameterVM>(vm.getParameters());
            params.removeIf(param -> TextUtil.isBlank((String)param.getName()) && TextUtil.isBlank((String)param.getValue()));
            VMHelper.transfer(params, model.getDataMap(), paramVM -> new NamedValue(), (paramVM, nv) -> {
                nv.setName(paramVM.getName());
                nv.setValue(paramVM.getValue());
            });
        });
    }

    @Override
    protected ViewController<ScheduledTaskSettingsPane, ScheduledTaskSettingsPaneVM> createSpaceController(boolean readonly) {
        return new ScheduledTaskSettingsPaneController(readonly);
    }

    @Override
    protected ScheduledTaskSettingsPaneVM createVM() {
        return new ScheduledTaskSettingsPaneVM();
    }
}

