/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsAddAgencyDialogContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsAgenciesTokensContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsAgenciesTokensContainerController;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsAgencyDataDialogContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsCIRUploadDataContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsContainerController;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsKeysGeneratorDataContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsKeysGeneratorDialogContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsMainContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsTokensContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.settings.PCIDSSServerExchangeSettingsHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.PCIDSSService;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.CirToken;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.SecurityHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javax.crypto.BadPaddingException;
import org.json.JSONObject;

public class StandardPCIDSSServerExchangeSettingsHandlerConfigurator
implements PCIDSSServerExchangeSettingsHandlerConfigurator {
    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<PCIDSSServerExchangeSettings, Void>, PCIDSSServerExchangeSettingsContainerVM>> toVM, List<BiConsumer<PCIDSSServerExchangeSettingsContainerVM, DataTransferPackage<PCIDSSServerExchangeSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new PCIDSSServerExchangeSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            PCIDSSServerExchangeSettings model = (PCIDSSServerExchangeSettings)dtp.getContainer().getEntity();
            vm.getMain().setEnabled(model.isEnabled());
            vm.getMain().setServerAddress(model.getServerAddress());
            vm.getMain().setUploadCardsCallbackUrl(model.getUploadCardsCallbackUrl());
            vm.getMain().setToken(model.getToken());
            vm.getMain().setUUID(model.getCirUid());
            VMHelper.transfer(model.getAgencyTokens(), vm.getAgenciesTokens().getContent(), token -> new PCIDSSServerExchangeSettingsTokensContainerVM(), (token, tokenVM) -> {
                tokenVM.setAgency(token.getAgencyProfile());
                tokenVM.setToken(token.getTokenData());
                tokenVM.setCirUID(token.getAgencyUid());
            });
        });
        fromVM.add((vm, dtp) -> {
            PCIDSSServerExchangeSettings model = (PCIDSSServerExchangeSettings)dtp.getContainer().getEntity();
            model.setEnabled(vm.getMain().isEnabled());
            model.setServerAddress(vm.getMain().getServerAddress());
            model.setUploadCardsCallbackUrl(vm.getMain().getUploadCardsCallbackUrl());
            model.setToken(vm.getMain().getToken());
            model.setCirUid(vm.getMain().getUUID());
            VMHelper.transfer(vm.getAgenciesTokens().getContent(), model.getAgencyTokens(), token -> new CirToken(), (tokenVM, token) -> {
                token.setAgencyProfile(tokenVM.getAgency());
                token.setTokenData(tokenVM.getToken());
                token.setAgencyUid(tokenVM.getCirUID());
            });
        });
    }

    static class PCIDSSServerExchangeSettingsControllerInterceptor
    extends ControllerInterceptor<PCIDSSServerExchangeSettingsContainerVM, PCIDSSServerExchangeSettingsContainerController> {
        private static final String CIR_KEY_SELECTOR_TOOLTIP = Messages.Files_with_key;
        private static final String CIR_KEY_EXTENSION = "*.epk";

        PCIDSSServerExchangeSettingsControllerInterceptor() {
        }

        protected Class<PCIDSSServerExchangeSettingsContainerController> getControllerClass() {
            return PCIDSSServerExchangeSettingsContainerController.class;
        }

        protected void onCreate(PCIDSSServerExchangeSettingsContainerController controller) {
            ((HyperlinkWidget)controller.getMain().getView().getTestCell().getPayload()).onActionProperty().setValue(event -> Notifications.get().submitTask(() -> PCIDSSServerExchangeSettingsControllerInterceptor.testServerConnection(controller), Messages.Test_cir_connection));
            controller.getMain().getView().getGenerateCIRKeysNode().onActionProperty().setValue(event -> PCIDSSServerExchangeSettingsControllerInterceptor.popUpCIRGenerationDialog(controller));
            controller.getMain().getView().getCirUploadNode().onActionProperty().setValue(event -> this.popUpCIRUploadConfirmDialog(controller));
            controller.getMain().getView().getTokensEditorNode().onActionProperty().setValue(event -> this.popUpCIRAgenciesDialog(controller));
            ((TableWidget)controller.getAgenciesTokens().getView().getContent()).setControlButtonsAvailability(ControlsPane.NONE);
            ((PCIDSSServerExchangeSettingsMainContainer)controller.getView().getMainCard().getContent()).getTokenCell().setHidden(true);
            TableWidget tokensWidget = (TableWidget)controller.getAgenciesTokens().getView().getContent();
            tokensWidget.setItemsProvider(this.createDialogProvider());
        }

        private void popUpCIRAgenciesDialog(PCIDSSServerExchangeSettingsContainerController controller) {
            Dialog tokensDialog = new Dialog();
            PCIDSSServerExchangeSettingsAgenciesTokensContainerController tokensController = new PCIDSSServerExchangeSettingsAgenciesTokensContainerController(false);
            PCIDSSServerExchangeSettingsAgenciesTokensContainer tokensContainer = tokensController.getView();
            ((TableWidget)tokensContainer.getContent()).setItemsProvider(this.createDialogProvider());
            Collection rowsData = ((TableWidget)controller.getAgenciesTokens().getView().getContent()).getRowsData();
            for (PCIDSSServerExchangeSettingsTokensContainerVM row : rowsData) {
                ((TableWidget)tokensController.getView().getContent()).addRow((Object)row);
            }
            tokensDialog.setTitle(Messages.Tokens_editor).setExpandToParent(true).setBody((Node)tokensContainer).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Apply, () -> {
                Collection agenciesRowsData = ((TableWidget)tokensController.getView().getContent()).getRowsData();
                ((TableWidget)controller.getAgenciesTokens().getView().getContent()).removeAllRows();
                for (PCIDSSServerExchangeSettingsTokensContainerVM row : agenciesRowsData) {
                    ((TableWidget)controller.getAgenciesTokens().getView().getContent()).addRow((Object)row);
                }
                Notifications.get().submitTask(() -> {
                    ArrayList tokens = new ArrayList();
                    VMHelper.transfer(((TableWidget)tokensContainer.getContent()).getRowsData(), tokens, tokenVM -> new CirToken(), (tokenVM, token) -> {
                        token.setAgencyProfile(tokenVM.getAgency());
                        token.setTokenData(tokenVM.getToken());
                        token.setAgencyUid(tokenVM.getCirUID());
                    });
                    UUID mainUUID = controller.getData().getMain().getUUID() == null ? null : UUID.fromString(controller.getData().getMain().getUUID());
                    String serverAddress = controller.getData().getMain().getServerAddress();
                    CirHelper.MultiAgencyTokenResponse multiAgencyToken = CirHelper.getMultiAgencyToken((String)serverAddress, (UUID)mainUUID, tokens);
                    controller.getMain().setToken(multiAgencyToken.token);
                    FxUtil.waitForFxThread(() -> controller.getMain().setUUID(multiAgencyToken.uid.toString()));
                }, Messages.Changes_saving);
            }).show((Node)controller.getView());
        }

        private void popUpCIRUploadConfirmDialog(PCIDSSServerExchangeSettingsContainerController controller) {
            Dialog confirmDialog = new Dialog();
            confirmDialog.setTitle(Messages.Download_cards_to_cir).setMessage(Messages.Need_download_cards_to_cir).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accept, () -> this.popUpCIRUploadDialog(controller)).setOnCloseRequest(null).show((Node)controller.getView());
        }

        private void popUpCIRUploadDialog(PCIDSSServerExchangeSettingsContainerController controller) {
            PCIDSSServerExchangeSettingsCIRUploadDataContainer dil = new PCIDSSServerExchangeSettingsCIRUploadDataContainer(false);
            List orgRefList = controller.getData().getAgenciesTokens().getContent().stream().map(PCIDSSServerExchangeSettingsTokensContainerVM::getAgency).collect(Collectors.toList());
            dil.getOrganizationNode().setItemsSupplier(() -> orgRefList);
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Download_cards_to_cir).setBody((Node)dil).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accept, () -> {
                ArrayList messages = new ArrayList();
                Consumer<PCIDSSServerExchangeSettings> cons = settings -> {
                    try {
                        if (CirHelper.cirEnabled((PCIDSSServerExchangeSettings)settings)) {
                            JSONObject payload = new JSONObject();
                            payload.put("callbackUrl", (Object)settings.getUploadCardsCallbackUrl());
                            URL url = new URL(settings.getServerAddress() + "/addCardsPrepare");
                            CirHelper.ResponseData data = CirHelper.send((String)payload.toString(), (URL)url, (PCIDSSServerExchangeSettings)settings, (EntityReference)((EntityReference)dil.getOrganizationNode().getValue()), (boolean)false);
                            if (data != null && data.getCode() == 200) {
                                Desktop desktop;
                                JSONObject object = new JSONObject(data.getValue());
                                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                                    desktop.browse(new URI(object.getString("addCardsUrl")));
                                }
                                messages.add(MessageHelper.createMessage((String)Messages.CirUploadToolHandler_uploadSuccess, (Object[])new Object[0]));
                            } else {
                                messages.add(MessageHelper.createErrorMessage((String)Messages.CirUploadToolHandler_uploadFailed, (String)L10n.replace((String)Messages.CirUploadToolHandler_responseCode, (Object[])new Object[]{String.valueOf(data != null ? Integer.valueOf(data.getCode()) : "")}), (Object[])new Object[0]));
                            }
                        }
                    }
                    catch (Exception e) {
                        messages.add(MessageHelper.createErrorMessage((String)Messages.CirUploadToolHandler_uploadFailed, (Object[])new Object[]{e}));
                    }
                    Notifications.get().showMessages((Collection)messages);
                };
                Notifications.get().submitTask(() -> {
                    PCIDSSServerExchangeSettings settings = (PCIDSSServerExchangeSettings)((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), PCIDSSServerExchangeSettings.class, UniqueSettingsRegistry.get().getUidByClassName(PCIDSSServerExchangeSettings.class.getName())).getEntity();
                    cons.accept(settings);
                }, Messages.Notifications_getting_data);
            }).setOnCloseRequest(null).show((Node)controller.getView());
        }

        private MultiProvider<PCIDSSServerExchangeSettingsTokensContainerVM> createDialogProvider() {
            return new MultiProvider<PCIDSSServerExchangeSettingsTokensContainerVM>(){

                public void createAny(Consumer<Collection<PCIDSSServerExchangeSettingsTokensContainerVM>> consumer) {
                    Dialog dialog = new Dialog();
                    PCIDSSServerExchangeSettingsTokensContainerVM result = new PCIDSSServerExchangeSettingsTokensContainerVM();
                    PCIDSSServerExchangeSettingsAddAgencyDialogContainer dialogData = new PCIDSSServerExchangeSettingsAddAgencyDialogContainer(false);
                    dialog.setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setBody((Node)dialogData).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                        dialogData.getChildren().removeAll((Collection)dialogData.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                        String tokenValue = ((PCIDSSServerExchangeSettingsAgencyDataDialogContainer)dialogData.getMainCard().getContent()).getTokenNode().getValue();
                        EntityReference agencyValue = ((PCIDSSServerExchangeSettingsAgencyDataDialogContainer)dialogData.getMainCard().getContent()).getAgencyNode().getValue();
                        List listMessage = PCIDSSServerExchangeSettingsControllerInterceptor.validateAddAgencyTokenDialog((EntityReference<Organization>)agencyValue, tokenValue);
                        if (!listMessage.isEmpty()) {
                            listMessage.forEach(error -> dialogData.getChildren().add(0, error));
                            return;
                        }
                        try {
                            result.setCirUID(CirHelper.getAgencyUidFromToken((String)tokenValue).toString());
                            result.setAgency(agencyValue);
                            result.setToken(tokenValue);
                            consumer.accept(Collections.singletonList(result));
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Throwable)e);
                        }
                        finally {
                            dialog.close();
                        }
                    }).showGlobal();
                }

                public PCIDSSServerExchangeSettingsTokensContainerVM createOne() {
                    return new PCIDSSServerExchangeSettingsTokensContainerVM();
                }
            };
        }

        private static void testServerConnection(PCIDSSServerExchangeSettingsContainerController controller) {
            try {
                int resultCode;
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                RpcServiceManager rpcServiceManager = RpcServiceManager.get();
                PCIDSSService service = (PCIDSSService)rpcServiceManager.getService(PCIDSSService.class);
                String token = controller.getMain().getToken();
                if (TextUtil.isBlank((String)token)) {
                    token = controller.getAgenciesTokens().getData().getContent().stream().findAny().map(PCIDSSServerExchangeSettingsTokensContainerVM::getToken).orElse("");
                }
                if ((resultCode = service.testCirConnection(sic, controller.getMain().getServerAddress(), token)) == 200) {
                    Notifications.get().showFlashNotification(Messages.Connection_is_successfully_established, "");
                } else {
                    Notifications.get().showFlashNotification(Messages.Incorrect_server_response_code + resultCode + Messages.Token_may_be_incorrectly_specified, "");
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }

        private static void popUpCIRGenerationDialog(PCIDSSServerExchangeSettingsContainerController controller) {
            PCIDSSServerExchangeSettingsKeysGeneratorDialogContainer keysDialog = new PCIDSSServerExchangeSettingsKeysGeneratorDialogContainer(false);
            PCIDSSServerExchangeSettingsKeysGeneratorDataContainer keysPanel = (PCIDSSServerExchangeSettingsKeysGeneratorDataContainer)keysDialog.getKeygenCard().getContent();
            keysPanel.getNewFileNode().setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(CIR_KEY_SELECTOR_TOOLTIP, new String[]{CIR_KEY_EXTENSION})));
            keysPanel.getOldFileNode().setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(CIR_KEY_SELECTOR_TOOLTIP, new String[]{CIR_KEY_EXTENSION})));
            keysPanel.getAgencyNode().setItemsSupplier(() -> ((TableWidget)controller.getAgenciesTokens().getView().getContent()).getRowsData().stream().map(PCIDSSServerExchangeSettingsTokensContainerVM::getAgency).collect(Collectors.toList()), false);
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Key_generation_CIR).setBody((Node)keysDialog).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Generate, () -> {
                keysDialog.getChildren().removeAll((Collection)keysDialog.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                String oldKeyFileName = !keysPanel.getOldFileNode().getFiles().isEmpty() ? ((File)keysPanel.getOldFileNode().getFiles().get(0)).getAbsolutePath() : "";
                String oldKeyPassword = keysPanel.getOldPasswordNode().getValue();
                String newKeyFileName = !keysPanel.getNewFileNode().getFiles().isEmpty() ? ((File)keysPanel.getNewFileNode().getFiles().get(0)).getAbsolutePath() : "";
                String newKeyPassword = keysPanel.getNewPasswordNode().getValue();
                EntityReference agency = keysPanel.getAgencyNode().getValue();
                List<Node> listMessage = PCIDSSServerExchangeSettingsControllerInterceptor.validateKeyGenData(oldKeyFileName, oldKeyPassword, newKeyFileName, newKeyPassword, (EntityReference<Organization>)agency);
                if (!listMessage.isEmpty()) {
                    listMessage.forEach(error -> keysDialog.getChildren().add(0, error));
                    return;
                }
                dialog.close();
                Notifications.get().submitTask(() -> {
                    try {
                        int code = PCIDSSServerExchangeSettingsControllerInterceptor.generateNewCIRKeyAndSendToTheServer(oldKeyFileName, oldKeyPassword, newKeyFileName, newKeyPassword, (EntityReference<Organization>)agency);
                        if (code == 204) {
                            String resultMessage = Messages.getPublic_key_accepted_by_the_server(Integer.toString(code));
                            Notifications.get().showStaticNotification(resultMessage, resultMessage);
                        } else {
                            String resultMessage = L10n.replace((String)Messages.Error_sending_key_to_server, (Object[])new Object[]{code});
                            Notifications.get().showStaticNotification(resultMessage, resultMessage);
                        }
                    }
                    catch (BadPaddingException bpe) {
                        Notifications.get().showStaticNotification(Messages.Decrypt_error, null);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }, Messages.Keys_are_updated);
            }).show((Node)controller.getView());
        }

        private static int generateNewCIRKeyAndSendToTheServer(String oldKeyFileName, String oldKeyPassword, String newKeyFileName, String newKeyPassword, EntityReference<Organization> agency) throws Exception {
            PrivateKey oldPrivateKey;
            PCIDSSServerExchangeSettings settings = (PCIDSSServerExchangeSettings)((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), PCIDSSServerExchangeSettings.class, UniqueSettingsRegistry.get().getUidByClassName(PCIDSSServerExchangeSettings.class.getName())).getEntity();
            SecurityHelper.SecurityData keys = SecurityHelper.generateKeys();
            CirHelper.writeNewCIRKeyToFile((PrivateKey)keys.getPrivateKey(), (String)newKeyFileName, (String)newKeyPassword);
            if (!TextUtil.isBlank((String)oldKeyFileName) && !TextUtil.isBlank((String)oldKeyPassword)) {
                SecurityHelper.PBEStorage storage = SecurityHelper.PBEStorage.read((byte[])Files.readAllBytes(Paths.get(oldKeyFileName, new String[0])));
                SecurityHelper.PBE pbe = new SecurityHelper.PBE(oldKeyPassword.toCharArray());
                byte[] storageContent = pbe.decrypt(storage);
                oldPrivateKey = SecurityHelper.createPrivateKey((byte[])storageContent);
            } else {
                oldPrivateKey = keys.getPrivateKey();
            }
            return CirHelper.sendCIRKeyToTheServer((PublicKey)keys.getPublicKey(), (PrivateKey)oldPrivateKey, (PCIDSSServerExchangeSettings)settings, agency);
        }

        private static List<Node> validateKeyGenData(String oldKeyFileName, String oldKeyPassword, String newKeyFileName, String newKeyPassword, EntityReference<Organization> agency) {
            ArrayList<Node> result = new ArrayList<Node>();
            if (TextUtil.isBlank((String)newKeyPassword)) {
                result.add((Node)MessagePane.error((String)Messages.Enter_the_password_for_the_new_key));
            }
            if (TextUtil.isBlank((String)newKeyFileName)) {
                result.add((Node)MessagePane.error((String)Messages.Specify_the_file_for_the_new_key));
            }
            if (!TextUtil.isBlank((String)oldKeyFileName) && TextUtil.isBlank((String)oldKeyPassword)) {
                result.add((Node)MessagePane.error((String)Messages.Enter_the_password_for_the_old_key));
            }
            if (agency == null) {
                result.add((Node)MessagePane.error((String)Messages.Enter_agency));
            }
            return result;
        }

        private static List<Node> validateAddAgencyTokenDialog(EntityReference<Organization> agency, String token) {
            ArrayList<Node> result = new ArrayList<Node>();
            if (TextUtil.isBlank((String)token)) {
                result.add((Node)MessagePane.error((String)Messages.Specify_the_token));
            }
            if (agency == null) {
                result.add((Node)MessagePane.error((String)Messages.Enter_agency));
            }
            return result;
        }
    }
}

