/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StockControlHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityContainer;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.control.Control;

enum StockBlankTileActions implements TileAction<Node, StockBlankContainer>
{
    CHANGE_STATUS{

        public String getName(Tile<Node, StockBlankContainer> tile) {
            return Messages.Change_status;
        }

        public String getDescription(Tile<Node, StockBlankContainer> tile) {
            return Messages.Change_form_status;
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, StockBlankContainer> tile) {
            return !((TableWidget)((StockBlankContainer)tile.getFullNode()).getBlankHistoryCard().getContent()).getViewState().isImmutable();
        }

        public void execute(Control source, Tile<Node, StockBlankContainer> tile, boolean alt) {
            EntityContainer container = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            if (container == null) {
                Dialog.info((Node)source, (String)"Could not get stock blank!");
                return;
            }
            StockControlHelper.changeStockBlankStatus(Collections.singletonList(container.toReference()), tile.getFullNode());
        }
    }
    ,
    CHANGE_LOCATION{

        public String getName(Tile<Node, StockBlankContainer> tile) {
            return Messages.Change_location;
        }

        public String getDescription(Tile<Node, StockBlankContainer> tile) {
            return Messages.Change_from_location;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, StockBlankContainer> tile) {
            return !((TableWidget)((StockBlankContainer)tile.getFullNode()).getBlankHistoryCard().getContent()).getViewState().isImmutable();
        }

        public void execute(Control source, Tile<Node, StockBlankContainer> tile, boolean alt) {
            EntityContainer container = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            if (container == null) {
                Dialog.info((Node)source, (String)"Could not get stock blank!");
                return;
            }
            StockControlHelper.changeStockBlankLocation(Collections.singletonList(container.toReference()), tile.getFullNode());
        }
    };

}

